/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.breakpointactions.AbstractBreakpointAction;
import org.eclipse.cdt.debug.core.breakpointactions.ICLIDebugActionEnabler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CLICommandAction
extends AbstractBreakpointAction {
    private static final String COMMAND_ATT = "command";
    private String command = "";

    public IStatus execute(IBreakpoint breakpoint, IAdaptable context, IProgressMonitor monitor) {
        ICLIDebugActionEnabler enabler = (ICLIDebugActionEnabler)context.getAdapter(ICLIDebugActionEnabler.class);
        if (enabler != null) {
            try {
                enabler.execute(this.getCommand());
            }
            catch (Exception e) {
                return this.errorStatus(e);
            }
        } else {
            return new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, Messages.getString("CLICommandAction.NoSupport"), null);
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private IStatus errorStatus(Exception ex) {
        String errorMsg = MessageFormat.format(Messages.getString("CLICommandAction.error.0"), this.getSummary());
        return new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, errorMsg, (Throwable)ex);
    }

    public String getDefaultName() {
        return Messages.getString("CLICommandAction.UntitledName");
    }

    public String getIdentifier() {
        return "org.eclipse.cdt.debug.ui.breakpointactions.CLICommandAction";
    }

    public String getMemento() {
        try {
            Document doc = DebugPlugin.newDocument();
            Element rootElement = doc.createElement(COMMAND_ATT);
            rootElement.setAttribute(COMMAND_ATT, this.command);
            doc.appendChild(rootElement);
            return DebugPlugin.serializeDocument((Document)doc);
        }
        catch (CoreException | DOMException e) {
            CDebugUIPlugin.log(e);
            return "";
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getSummary() {
        String summary = this.getCommand();
        if (summary.length() > 32) {
            summary = summary.substring(0, 32);
        }
        return summary;
    }

    public String getTypeName() {
        return Messages.getString("CLICommandAction.TypeName");
    }

    public void initializeFromMemento(String data) {
        try {
            Element root = DebugPlugin.parseDocument((String)data);
            String value = root.getAttribute(COMMAND_ATT);
            if (value == null) {
                value = "";
            }
            this.command = value;
        }
        catch (Exception e) {
            CDebugUIPlugin.log(e);
        }
    }
}

