/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.datamodel;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.CompositeDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

public abstract class AbstractDMVMNode
extends AbstractVMNode
implements IVMNode {
    private DsfSession fSession;
    private DsfServicesTracker fServicesTracker;
    private Class<? extends IDMContext> fDMCClassType;

    public AbstractDMVMNode(AbstractDMVMProvider provider, DsfSession session, Class<? extends IDMContext> dmcClassType) {
        super(provider);
        this.fSession = session;
        this.fServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
        this.fDMCClassType = dmcClassType;
    }

    @Override
    public void dispose() {
        this.fServicesTracker.dispose();
        super.dispose();
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object event, DataRequestMonitor<IVMContext[]> rm) {
        IDMEvent dmEvent;
        IDMContext dmc;
        if (event instanceof IDMEvent && (dmc = DMContexts.getAncestorOfType((IDMContext)(dmEvent = (IDMEvent)event).getDMContext(), this.fDMCClassType)) != null) {
            rm.setData((Object)new IVMContext[]{this.createVMContext(dmc)});
            rm.done();
            return;
        }
        super.getContextsForEvent(parentDelta, event, rm);
    }

    protected AbstractDMVMProvider getDMVMProvider() {
        return (AbstractDMVMProvider)this.getVMProvider();
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected DsfServicesTracker getServicesTracker() {
        return this.fServicesTracker;
    }

    @Override
    protected boolean checkUpdate(IViewerUpdate update) {
        IDMContext dmc;
        if (!super.checkUpdate(update)) {
            return false;
        }
        Object element = update.getElement();
        if (!(!(element instanceof IDMVMContext) || (dmc = ((IDMVMContext)element).getDMContext()).getSessionId().equals(this.getSession().getId()) && DsfSession.isSessionActive((String)dmc.getSessionId()))) {
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void update(final IHasChildrenUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
                        int n = updates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
                            if (AbstractDMVMNode.this.checkUpdate((IViewerUpdate)update)) {
                                AbstractDMVMNode.this.updateHasElementsInSessionThread(update);
                            }
                            ++n2;
                        }
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException e) {
                var6_3 = updates;
                var5_4 = updates.length;
                var4_5 = 0;
                ** while (var4_5 < var5_4)
            }
lbl-1000:
            // 1 sources

            {
                update = var6_3[var4_5];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++var4_5;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateHasElementsInSessionThread(IHasChildrenUpdate update) {
        update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "Not implemented, clients should call to update all children instead.", null));
        update.done();
    }

    /*
     * Unable to fully structure code
     */
    public void update(final IChildrenCountUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
                        int n = updates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                            if (AbstractDMVMNode.this.checkUpdate((IViewerUpdate)update)) {
                                AbstractDMVMNode.this.updateElementCountInSessionThread(update);
                            }
                            ++n2;
                        }
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException e) {
                var6_3 = updates;
                var5_4 = updates.length;
                var4_5 = 0;
                ** while (var4_5 < var5_4)
            }
lbl-1000:
            // 1 sources

            {
                update = var6_3[var4_5];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++var4_5;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateElementCountInSessionThread(IChildrenCountUpdate update) {
        update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "Not implemented, clients should call to update all children instead.", null));
        update.done();
    }

    /*
     * Unable to fully structure code
     */
    public void update(final IChildrenUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IChildrenUpdate[] iChildrenUpdateArray = updates;
                        int n = updates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IChildrenUpdate update = iChildrenUpdateArray[n2];
                            if (AbstractDMVMNode.this.checkUpdate((IViewerUpdate)update)) {
                                AbstractDMVMNode.this.updateElementsInSessionThread(update);
                            }
                            ++n2;
                        }
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException e) {
                var6_3 = updates;
                var5_4 = updates.length;
                var4_5 = 0;
                ** while (var4_5 < var5_4)
            }
lbl-1000:
            // 1 sources

            {
                update = var6_3[var4_5];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++var4_5;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected abstract void updateElementsInSessionThread(IChildrenUpdate var1);

    protected IVMContext[] dmcs2vmcs(IDMContext[] dmcs) {
        IVMContext[] vmContexts = new IVMContext[dmcs.length];
        int i = 0;
        while (i < dmcs.length) {
            vmContexts[i] = this.createVMContext(dmcs[i]);
            ++i;
        }
        return vmContexts;
    }

    protected void fillUpdateWithVMCs(IChildrenUpdate update, IDMContext[] dmcs) {
        this.fillUpdateWithVMCs(update, dmcs, 0);
    }

    protected void fillUpdateWithVMCs(IChildrenUpdate update, IDMContext[] dmcs, int firstIndex) {
        int updateIdx = update.getOffset() != -1 ? update.getOffset() : 0;
        int endIdx = updateIdx + (update.getLength() != -1 ? update.getLength() : dmcs.length);
        int dmcIdx = updateIdx - firstIndex;
        if (dmcIdx < 0) {
            updateIdx -= dmcIdx;
            dmcIdx = 0;
        }
        while (updateIdx < endIdx && dmcIdx < dmcs.length) {
            update.setChild((Object)this.createVMContext(dmcs[dmcIdx++]), updateIdx++);
        }
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new DMVMContext(dmc);
    }

    protected IDMContext createCompositeDMVMContext(IViewerUpdate update) {
        return new CompositeDMVMContext(update);
    }

    protected <T extends IDMContext> T findDmcInPath(Object inputObject, TreePath path, Class<T> dmcType) {
        Object retVal = null;
        int i = path.getSegmentCount() - 1;
        while (i >= 0) {
            IDMContext dmc;
            if (path.getSegment(i) instanceof IDMVMContext && (dmc = ((IDMVMContext)path.getSegment(i)).getDMContext()).getSessionId().equals(this.getSession().getId()) && (retVal = DMContexts.getAncestorOfType((IDMContext)dmc, dmcType)) != null) break;
            --i;
        }
        if (retVal == null) {
            if (inputObject instanceof ITreeSelection) {
                ITreeSelection inputSelection = (ITreeSelection)inputObject;
                if (inputSelection.getPaths().length == 1) {
                    retVal = this.findDmcInPath(null, inputSelection.getPaths()[0], dmcType);
                }
            } else if (inputObject instanceof IStructuredSelection) {
                Object rootElement = ((IStructuredSelection)inputObject).getFirstElement();
                if (rootElement instanceof IDMVMContext) {
                    retVal = DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)rootElement).getDMContext(), dmcType);
                }
            } else if (inputObject instanceof IDMVMContext) {
                retVal = DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)inputObject).getDMContext(), dmcType);
            }
        }
        return (T)retVal;
    }

    protected void getVMCIndexForDmc(IVMNode nodetype, final IDMContext wantedCtx, VMDelta parentDelta, final DataRequestMonitor<Integer> rm) {
        boolean indexFailed = false;
        this.getVMProvider().updateNode(nodetype, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            protected void handleSuccess() {
                boolean found = false;
                int i = 0;
                while (i < ((List)this.getData()).size()) {
                    IDMVMContext vmc;
                    if (((List)this.getData()).get(i) instanceof IDMVMContext && (vmc = (IDMVMContext)((List)this.getData()).get(i)).getDMContext().equals(wantedCtx)) {
                        rm.setData((Object)i);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    rm.setData((Object)0);
                }
                rm.done();
            }
        }));
    }

    @Immutable
    protected class DMVMContext
    extends AbstractVMContext
    implements IDMVMContext {
        private final IDMContext fDmc;

        public DMVMContext(IDMContext dmc) {
            super(AbstractDMVMNode.this);
            assert (dmc != null);
            this.fDmc = dmc;
        }

        @Override
        public IDMContext getDMContext() {
            return this.fDmc;
        }

        @Override
        public <T> T getAdapter(Class<T> adapter) {
            T superAdapter = super.getAdapter(adapter);
            if (superAdapter != null) {
                return superAdapter;
            }
            if (adapter.isInstance(this.fDmc)) {
                return (T)this.fDmc;
            }
            return (T)this.fDmc.getAdapter(adapter);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof DMVMContext)) {
                return false;
            }
            DMVMContext otherVmc = (DMVMContext)other;
            return AbstractDMVMNode.this.equals(otherVmc.getVMNode()) && this.fDmc.equals(otherVmc.fDmc);
        }

        @Override
        public int hashCode() {
            return AbstractDMVMNode.this.hashCode() + this.fDmc.hashCode();
        }

        public String toString() {
            return this.fDmc.toString();
        }
    }
}

