/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.launch;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class RustLaunchDelegateTools {
    public static final String PROJECT_ATTRIBUTE = "PROJECT";
    public static final String OPTIONS_ATTRIBUTE = "OPTIONS";
    public static final String ARGUMENTS_ATTRIBUTE = "ARGUMENTS";
    public static final String WORKING_DIRECTORY_ATTRIBUTE = "WORKING_DIRECTORY";

    private RustLaunchDelegateTools() {
        throw new IllegalStateException("Utility class");
    }

    public static IResource firstResourceFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                if (element instanceof IResource) {
                    return (IResource)element;
                }
                if (!(element instanceof IAdaptable)) continue;
                return (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
        }
        return null;
    }

    public static IResource resourceFromEditor(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        return (IResource)input.getAdapter(IResource.class);
    }

    public static File convertToAbsolutePath(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        IResource filePath = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (filePath == null) {
            return file;
        }
        return filePath.getRawLocation().toFile();
    }

    public static void launch(ILaunchConfiguration launchConfig, String mode) throws CoreException {
        if (launchConfig != null) {
            launchConfig.launch(mode, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static ILaunchConfiguration getLaunchConfiguration(IResource resource, String launchConfigurationType) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType(launchConfigurationType);
        try {
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(configType);
            String projectName = resource.getProject().getName();
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n = launchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n2];
                if (iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").equals(projectName)) {
                    return iLaunchConfiguration;
                }
                ++n2;
            }
            String configName = launchManager.generateLaunchConfigurationName(projectName);
            return configType.newInstance(null, configName);
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
            return null;
        }
    }

    public static String performVariableSubstitution(String string) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(string);
    }

    public static void openError(String title, String message) {
        Display.getDefault().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 1, 0, new String[]{IDialogConstants.OK_LABEL});
            dialog.setBlockOnOpen(false);
            dialog.open();
        });
    }
}

