/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.dltk.ui.dialogs.PropToPrefLinkArea;
import org.eclipse.dltk.ui.preferences.ControlBindingManager;
import org.eclipse.dltk.ui.preferences.IFieldValidator;
import org.eclipse.dltk.ui.preferences.IPreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class AbstractOptionsBlock
extends OptionsConfigurationBlock
implements IPreferenceDelegate<PreferenceKey> {
    private final List<PreferenceKey> keys = new ArrayList<PreferenceKey>();
    private ControlBindingManager<PreferenceKey> bindManager;

    public AbstractOptionsBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
        this.bindManager = new ControlBindingManager<PreferenceKey>(this, context);
    }

    @Override
    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Control control = this.createOptionsBlock(parent);
        this.initialize();
        return control;
    }

    protected void initialize() {
        if (!this.keys.isEmpty()) {
            this.addKeys(this.keys);
            this.keys.clear();
        }
        this.initializeProjectSettings();
        this.bindManager.initialize();
    }

    protected abstract Control createOptionsBlock(Composite var1);

    protected final void bindControl(Button button, PreferenceKey key) {
        this.bindControl(button, key, null);
    }

    protected final void bindControl(Button button, PreferenceKey key, Control[] dependencies) {
        this.bindManager.bindControl(button, key, dependencies);
        this.keys.add(key);
    }

    protected final void bindControl(Text textBox, PreferenceKey key, IFieldValidator validator) {
        this.bindManager.bindControl(textBox, key, validator);
        this.keys.add(key);
    }

    protected final void bindControl(Combo combo, PreferenceKey key) {
        this.bindManager.bindControl(combo, key);
        this.keys.add(key);
    }

    protected final void bindControl(Combo combo, PreferenceKey key, String[] itemValues) {
        this.bindManager.bindControl(combo, key, itemValues);
        this.keys.add(key);
    }

    @Deprecated
    protected final String getBuildDialogTitle() {
        return null;
    }

    @Deprecated
    protected final String getFullBuildDialogMessage() {
        return null;
    }

    @Deprecated
    protected final String getProjectBuildDialogMessage() {
        return null;
    }

    protected final boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.bindManager.initialize();
    }

    protected boolean saveValues() {
        return true;
    }

    @Override
    public boolean performOk() {
        return this.saveValues() && super.performOk();
    }

    @Override
    public boolean performApply() {
        return this.saveValues() && super.performApply();
    }

    @Override
    public final boolean getBoolean(PreferenceKey key) {
        return this.getBooleanValue(key);
    }

    @Override
    public final String getString(PreferenceKey key) {
        return this.getValue(key);
    }

    @Override
    public final void setBoolean(PreferenceKey key, boolean value) {
        super.setValue(key, value);
    }

    @Override
    public final void setString(PreferenceKey key, String value) {
        this.setValue(key, value);
    }

    protected final IProject getProject() {
        return this.fProject;
    }

    protected final void updateStatus(IStatus status) {
        this.bindManager.updateStatus(status);
    }

    protected void createPrefLink(Composite composite, String message, String prefPageId, Object data) {
        PreferenceLinkArea area = new PreferenceLinkArea(composite, 0, prefPageId, message, this.getPreferenceContainer(), data);
        area.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
    }

    protected void createPropToPrefLink(Composite composite, String message, String prefPageId, Object data) {
        PropToPrefLinkArea area = new PropToPrefLinkArea(composite, 0, prefPageId, message, this.getShell(), data);
        area.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
    }

    @Override
    protected Shell getShell() {
        return super.getShell();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void statusChanged(IStatus status) {
        super.statusChanged(status);
    }

    @Override
    protected IPreferenceChangeRebuildPrompt getPreferenceChangeRebuildPrompt(boolean workspaceSettings, Collection<PreferenceKey> changedOptions) {
        return super.getPreferenceChangeRebuildPrompt(workspaceSettings, changedOptions);
    }
}

