/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.editor;

import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.security.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.security.internal.ui.editor.CDOSecurityFormActionBarContributor;
import org.eclipse.emf.cdo.security.internal.ui.editor.CDOSecurityPage;
import org.eclipse.emf.cdo.security.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.security.provider.SecurityItemProviderAdapterFactory;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class CDOSecurityFormEditor
extends FormEditor
implements IEditingDomainProvider {
    public static final String ID = "org.eclipse.emf.cdo.security.ui.CDOSecurityFormEditor";
    private ComposedAdapterFactory adapterFactory;
    private CDOView view;
    private EditingDomain editingDomain;
    private CDOSecurityPage mainPage;
    private CommandStackListener dirtyStackListener;

    protected void addPages() {
        try {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
            this.mainPage = new CDOSecurityPage(this);
            this.addPage((IFormPage)this.mainPage);
        }
        catch (PartInitException e) {
            OM.LOG.error((Throwable)e);
        }
    }

    public boolean isDirty() {
        return this.view != null && this.view.isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.view instanceof CDOTransaction) {
            try {
                ((CDOTransaction)this.view).commit(monitor);
                this.fireDirtyStateChanged();
            }
            catch (CommitException e) {
                StatusAdapter status = new StatusAdapter((IStatus)new Status(4, "org.eclipse.emf.cdo.security.ui", Messages.CDOSecurityFormEditor_0, (Throwable)e));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.CDOSecurityFormEditor_1);
                status.setProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY, (Object)System.currentTimeMillis());
                StatusManager.getManager().handle(status, 2);
            }
        }
    }

    protected void fireDirtyStateChanged() {
        Display display = this.getContainer().getDisplay();
        if (display == Display.getCurrent()) {
            this.firePropertyChange(257);
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    CDOSecurityFormEditor.this.fireDirtyStateChanged();
                }
            });
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    boolean isReadOnly() {
        return this.view == null || this.view.isReadOnly();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initializeEditingDomain();
    }

    public void dispose() {
        try {
            if (this.dirtyStackListener != null) {
                if (this.editingDomain != null) {
                    this.editingDomain.getCommandStack().removeCommandStackListener(this.dirtyStackListener);
                }
                this.dirtyStackListener = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    protected void initializeEditingDomain() {
        try {
            CDOResource resource = this.getResource();
            this.view = resource.cdoView();
            this.dirtyStackListener = new CommandStackListener(){

                public void commandStackChanged(EventObject event) {
                    CDOSecurityFormEditor.this.fireDirtyStateChanged();
                }
            };
            BasicCommandStack commandStack = new BasicCommandStack();
            commandStack.addCommandStackListener(this.dirtyStackListener);
            ResourceSet resourceSet = this.view.getResourceSet();
            this.editingDomain = this.createEditingDomain((CommandStack)commandStack, resourceSet);
            resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider(this.editingDomain));
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
    }

    protected EditingDomain createEditingDomain(CommandStack commandStack, ResourceSet resourceSet) {
        ComposedAdapterFactory.Descriptor.Registry registry = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        this.adapterFactory = new ComposedAdapterFactory(registry);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SecurityItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, commandStack, resourceSet);
    }

    protected CDOResource getResource() {
        CDOResource result = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof CDOEditorInput) {
            CDOEditorInput cdoInput = (CDOEditorInput)input;
            result = cdoInput.getView().getResource(cdoInput.getResourcePath());
        }
        return result;
    }

    protected CDOView getView() {
        return this.view;
    }

    protected AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public IActionBars getActionBars() {
        return ((CDOSecurityFormActionBarContributor)this.getEditorSite().getActionBarContributor()).getActionBars();
    }

    public void setFocus() {
        super.setFocus();
        IFormPage page = this.getActivePageInstance();
        if (page != null && page instanceof CDOSecurityPage) {
            page.setFocus();
        }
    }
}

