/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOAllRevisionsProvider;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStoreReader;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStoreWriter;
import org.eclipse.emf.cdo.server.internal.lissome.db.Index;
import org.eclipse.emf.cdo.server.internal.lissome.file.Journal;
import org.eclipse.emf.cdo.server.internal.lissome.file.Vob;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.Optimizer;
import org.eclipse.emf.cdo.server.lissome.ILissomeStore;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LissomeStore
extends Store
implements ILissomeStore,
CDOAllRevisionsProvider,
IDBConnectionProvider,
InternalStore.NoRawAccess,
InternalStore.NoLargeObjects,
InternalStore.NoQueryXRefs,
InternalStore.NoChangeSets,
InternalStore.NoDurableLocking {
    public static final String TYPE = "lissome";
    public static final String PERSISTENT_PROPERTIES_EXTENSION = "properties";
    private static final String PROP_REPOSITORY_CREATED = "org.eclipse.emf.cdo.server.lissome.repositoryCreated";
    private static final String PROP_REPOSITORY_STOPPED = "org.eclipse.emf.cdo.server.lissome.repositoryStopped";
    private static final String PROP_LAST_CDOID = "org.eclipse.emf.cdo.server.lissome.lastCDOID";
    private static final String PROP_LAST_BRANCHID = "org.eclipse.emf.cdo.server.lissome.lastBranchID";
    private static final String PROP_LAST_METAID = "org.eclipse.emf.cdo.server.lissome.lastMetaID";
    private static final String PROP_LAST_COMMITTIME = "org.eclipse.emf.cdo.server.lissome.lastCommitTime";
    private static final String PROP_GRACEFULLY_SHUT_DOWN = "org.eclipse.emf.cdo.server.lissome.gracefullyShutDown";
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool readerPool = new StoreAccessorPool((IStore)this, null);
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool writerPool = new StoreAccessorPool((IStore)this, null);
    private Optimizer optimizer = this.createOptimizer();
    private Vob vob;
    private Index index;
    private Map<String, String> properties;
    private Properties persistentProperties = new Properties();
    private File folder;
    private Journal journal;
    private boolean firstStart;
    private long creationTime;
    private long lastCDOID;
    private int lastMetaID;
    private Map<Integer, Object> metaObjects = new HashMap<Integer, Object>();
    private Map<Object, Integer> metaIDs = new HashMap<Object, Integer>();

    public LissomeStore() {
        super(TYPE, null, LissomeStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.DELTA}), LissomeStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.AUDITING}), LissomeStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.BRANCHING}));
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<IStore.ChangeFormat> getSupportedChangeFormats() {
        return LissomeStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.DELTA});
    }

    public File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }

    public File getLogFile() {
        return this.journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPersistentProperties(Set<String> names) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Properties properties2 = this.persistentProperties;
        synchronized (properties2) {
            for (String name : names) {
                String value = this.persistentProperties.getProperty(name);
                if (value == null) continue;
                properties.put(name, value);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistentProperties(Map<String, String> properties) {
        Properties properties2 = this.persistentProperties;
        synchronized (properties2) {
            this.persistentProperties.putAll(properties);
            this.savePersistentProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersistentProperties(Set<String> names) {
        Properties properties = this.persistentProperties;
        synchronized (properties) {
            for (String name : names) {
                this.persistentProperties.remove(name);
            }
            this.savePersistentProperties();
        }
    }

    protected void loadPersistentProperties(File file) {
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                this.persistentProperties.load(fis);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fis);
            throw throwable;
        }
        IOUtil.close((Closeable)fis);
    }

    protected void savePersistentProperties() {
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(this.getPersistentPropertiesFile());
                this.persistentProperties.store(stream, "Lissome Persistent Properties");
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(stream);
            throw throwable;
        }
        IOUtil.close((Closeable)stream);
    }

    protected File getPersistentPropertiesFile() {
        return new File(this.folder, String.valueOf(this.getRepository().getName()) + "." + PERSISTENT_PROPERTIES_EXTENSION);
    }

    public CDOID createObjectID(String val) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isLocal(CDOID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LissomeStoreReader getReader(ISession session) {
        return (LissomeStoreReader)super.getReader(session);
    }

    @Override
    public LissomeStoreWriter getWriter(ITransaction transaction) {
        return (LissomeStoreWriter)super.getWriter(transaction);
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return this.readerPool;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return this.writerPool;
    }

    protected LissomeStoreReader createReader(ISession session) {
        return new LissomeStoreReader(this, session);
    }

    protected LissomeStoreWriter createWriter(ITransaction transaction) {
        return new LissomeStoreWriter(this, transaction);
    }

    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        final HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        LissomeStoreReader accessor = this.getReader(null);
        StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
        try {
            accessor.handleRevisions(null, null, 0L, true, (CDORevisionHandler)new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

                public boolean handleRevision(CDORevision revision) {
                    CDOBranch branch = revision.getBranch();
                    ArrayList<CDORevision> list = (ArrayList<CDORevision>)result.get(branch);
                    if (list == null) {
                        list = new ArrayList<CDORevision>();
                        result.put(branch, list);
                    }
                    list.add(revision);
                    return true;
                }
            }));
        }
        finally {
            StoreThreadLocal.release();
        }
        return result;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_REPOSITORY_CREATED, Long.toString(creationTime));
        this.setPersistentProperties(map);
    }

    public boolean isFirstStart() {
        return this.firstStart;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkNull(this.folder, "folder");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        CDOCommonRepository.IDGenerationLocation idGenerationLocation = this.getRepository().getIDGenerationLocation();
        if (idGenerationLocation == CDOCommonRepository.IDGenerationLocation.CLIENT) {
            this.setObjectIDTypes(Collections.singleton(CDOID.ObjectType.UUID));
        } else {
            this.setObjectIDTypes(LongIDStore.OBJECT_ID_TYPES);
        }
        this.vob = this.createVob();
        this.index = this.createIndex();
        this.journal = this.createJournal();
        this.optimizer.activate();
        File persistentPropertiesFile = this.getPersistentPropertiesFile();
        boolean bl = this.firstStart = !persistentPropertiesFile.exists() || persistentPropertiesFile.length() == 0L;
        if (this.firstStart) {
            this.firstStart();
        } else {
            this.loadPersistentProperties(persistentPropertiesFile);
            this.reStart();
        }
    }

    protected void doDeactivate() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_GRACEFULLY_SHUT_DOWN, Boolean.TRUE.toString());
        map.put(PROP_REPOSITORY_STOPPED, Long.toString(this.getRepository().getTimeStamp()));
        if (this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            map.put(PROP_LAST_CDOID, Long.toString(this.getLastCDOID()));
        }
        map.put(PROP_LAST_BRANCHID, Integer.toString(this.getLastBranchID()));
        map.put(PROP_LAST_METAID, Integer.toString(this.getLastMetaID()));
        map.put(PROP_LAST_COMMITTIME, Long.toString(this.getLastCommitTime()));
        this.setPersistentProperties(map);
        if (this.readerPool != null) {
            this.readerPool.dispose();
        }
        if (this.writerPool != null) {
            this.writerPool.dispose();
        }
        this.optimizer.deactivate();
        super.doDeactivate();
    }

    protected void firstStart() {
        long timeStamp = this.getRepository().getTimeStamp();
        this.setCreationTime(timeStamp);
        this.journal.firstStart();
        this.index.createTables();
    }

    protected void reStart() throws IOException {
        HashSet<String> names = new HashSet<String>();
        names.add(PROP_REPOSITORY_CREATED);
        names.add(PROP_GRACEFULLY_SHUT_DOWN);
        Map<String, String> map = this.getPersistentProperties(names);
        this.creationTime = Long.valueOf(map.get(PROP_REPOSITORY_CREATED));
        if (map.containsKey(PROP_GRACEFULLY_SHUT_DOWN)) {
            boolean generatingIDs;
            names.clear();
            boolean bl = generatingIDs = this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
            if (generatingIDs) {
                names.add(PROP_LAST_CDOID);
            }
            names.add(PROP_LAST_BRANCHID);
            names.add(PROP_LAST_METAID);
            names.add(PROP_LAST_COMMITTIME);
            map = this.getPersistentProperties(names);
            if (generatingIDs) {
                this.setLastCDOID(Long.valueOf(map.get(PROP_LAST_CDOID)));
            }
            this.setLastBranchID(Integer.valueOf(map.get(PROP_LAST_BRANCHID)));
            this.setLastMetaID(Integer.valueOf(map.get(PROP_LAST_METAID)));
            this.setLastCommitTime(Long.valueOf(map.get(PROP_LAST_COMMITTIME)));
        } else {
            this.repairAfterCrash();
        }
        this.removePersistentProperties(Collections.singleton(PROP_GRACEFULLY_SHUT_DOWN));
        this.journal.reStart();
    }

    protected void repairAfterCrash() {
        throw new UnsupportedOperationException();
    }

    public Journal getJournal() {
        return this.journal;
    }

    protected Journal createJournal() throws FileNotFoundException {
        return new Journal(this);
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    protected Optimizer createOptimizer() {
        return new Optimizer(this, true);
    }

    public Vob getVob() {
        return this.vob;
    }

    protected Vob createVob() throws IOException {
        return new Vob(this);
    }

    public Index getIndex() {
        return this.index;
    }

    protected Index createIndex() {
        return new Index(this);
    }

    public long getLastCDOID() {
        return this.lastCDOID;
    }

    public void setLastCDOID(long lastCDOID) {
        this.lastCDOID = lastCDOID;
    }

    public CDOID getNextCDOID() {
        return CDOIDUtil.createLong((long)(++this.lastCDOID));
    }

    public int getLastMetaID() {
        return this.lastMetaID;
    }

    public void setLastMetaID(int lastMetaID) {
        this.lastMetaID = lastMetaID;
    }

    public int mapMetaObject(Object metaObject) {
        int id = ++this.lastMetaID;
        this.mapMetaObject(metaObject, id);
        return id;
    }

    public void mapMetaObject(Object metaObject, int id) {
        this.metaObjects.put(id, metaObject);
        this.metaIDs.put(metaObject, id);
    }

    public int getMetaID(Object metaObject) {
        return this.metaIDs.get(metaObject);
    }

    public Object getMetaObject(int metaID) {
        return this.metaObjects.get(metaID);
    }

    public Connection getConnection() throws DBException {
        return this.index.getConnection();
    }
}

