/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.ICustomizationManagerProvider2;
import org.eclipse.emf.facet.custom.ui.internal.action.ShortcutCustomAction;
import org.eclipse.emf.facet.efacet.ui.LoadFacetSetShortcutsMenuUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;

public final class LoadCustomShortcutsMenuUtils {
    private LoadCustomShortcutsMenuUtils() {
    }

    public static IContributionItem[] getCustomItemsFromCurrentPart() {
        ICustomizationManagerProvider2 customMgrPrv = (ICustomizationManagerProvider2)LoadFacetSetShortcutsMenuUtils.getProviderFromCurrentPart(ICustomizationManagerProvider2.class);
        return LoadCustomShortcutsMenuUtils.getCustomItems(customMgrPrv);
    }

    public static IContributionItem[] getCustomItemsFromCurrentEditor() {
        ICustomizationManagerProvider2 customMgrPrv = (ICustomizationManagerProvider2)LoadFacetSetShortcutsMenuUtils.getProviderFromCurrentEditor(ICustomizationManagerProvider2.class);
        return LoadCustomShortcutsMenuUtils.getCustomItems(customMgrPrv);
    }

    private static IContributionItem[] getCustomItems(ICustomizationManagerProvider2 customMgrPrv) {
        ArrayList<ActionContributionItem> menuList = new ArrayList<ActionContributionItem>();
        if (customMgrPrv != null) {
            List<ICustomizationManagerProvider2.ICustomShortcut> shortcuts = customMgrPrv.getCustomShortcuts();
            ICustomizationManager customManager = customMgrPrv.getCustomizationManager();
            for (ICustomizationManagerProvider2.ICustomShortcut shortcut : shortcuts) {
                ActionContributionItem action = LoadCustomShortcutsMenuUtils.createCustomMenuItem(shortcut, customManager);
                menuList.add(action);
            }
        }
        return menuList.toArray(new IContributionItem[menuList.size()]);
    }

    private static ActionContributionItem createCustomMenuItem(ICustomizationManagerProvider2.ICustomShortcut shortcut, ICustomizationManager customManager) {
        Customization custom = shortcut.getCustom();
        String customId = custom.getName();
        ShortcutCustomAction action = new ShortcutCustomAction(customId, shortcut.getLabel(), shortcut.getIcon(), customManager);
        List activeCustoms = customManager.getManagedCustomizations();
        return LoadFacetSetShortcutsMenuUtils.createMenuItem((String)customId, (List)activeCustoms, (Action)action);
    }
}

