/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.presentable;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.TableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetsUtils;

public class PresentableCommandFactory {
    private final Table table;
    private final BasicCommandFactory basicCmdFactory;
    private final TableCommandFactory tableCmdFactory;

    public PresentableCommandFactory(Table table, BasicCommandFactory basicCmdFactory, TableCommandFactory cmdFactory) {
        this.table = table;
        this.basicCmdFactory = basicCmdFactory;
        this.tableCmdFactory = cmdFactory;
    }

    public Command createSetCanBePresentedInTheTableCommand(ETypedElement presentableQuery, boolean removeNonConform) {
        Command command;
        CompoundCommand compoundCommand = new CompoundCommand();
        Command setCommand = this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_CanBePresentedInTheTable(), presentableQuery);
        compoundCommand.append(setCommand);
        if (removeNonConform && (command = this.createRemoveNonConformingElementsCommand(presentableQuery)) != null) {
            compoundCommand.append(command);
        }
        compoundCommand.setLabel(Messages.NatTableWidget_setPresentabilityQuery);
        return compoundCommand;
    }

    private Command createRemoveNonConformingElementsCommand(ETypedElement presentableQuery) {
        ArrayList<Row> rowsToRemove = new ArrayList<Row>();
        for (Row row : this.table.getRows()) {
            EObject element = row.getElement();
            if (this.acceptsElement(element, presentableQuery)) continue;
            rowsToRemove.add(row);
        }
        return this.tableCmdFactory.createRemoveRowsCommand(rowsToRemove);
    }

    public boolean acceptsElement(Object element, ETypedElement presentableQuery) {
        boolean result = false;
        if (presentableQuery == null) {
            result = true;
        } else if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            IFacetManager facetManager = FacetsUtils.getFacetManager((EObject)this.table);
            try {
                result = (Boolean)facetManager.getOrInvoke(eObject, presentableQuery, Boolean.class);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)("Error executing presentability query: " + presentableQuery.getName()), (Plugin)Activator.getDefault());
                result = false;
            }
        }
        return result;
    }
}

