/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gef.common.attributes.IAttributeCopier;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.rect.Rect;
import org.eclipse.gef.dot.internal.ui.Dot2ZestAttributesConverter;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.GraphCopier;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.zest.fx.ZestProperties;

public class Dot2ZestGraphCopier
extends GraphCopier {
    public Dot2ZestGraphCopier() {
        this(new Dot2ZestAttributesConverter());
    }

    public Dot2ZestGraphCopier(Dot2ZestAttributesConverter dot2ZestAttributesConverter) {
        super((IAttributeCopier)dot2ZestAttributesConverter);
    }

    public Dot2ZestAttributesConverter getAttributeCopier() {
        return (Dot2ZestAttributesConverter)super.getAttributeCopier();
    }

    public Graph copy(Graph graph) {
        Graph copiedGraph = super.copy(graph);
        ArrayList<Node> replacementNodes = new ArrayList<Node>();
        for (Node node : copiedGraph.getNodes()) {
            if (node.getNestedGraph() == null) {
                replacementNodes.add(node);
                continue;
            }
            Node dotNode = null;
            for (Node n : this.getInputToOutputNodeMap().keySet()) {
                if (this.getInputToOutputNodeMap().get(n) != node) continue;
                dotNode = n;
                break;
            }
            if (DotAttributes.isCluster(dotNode) && !this.getAttributeCopier().options().emulateLayout) {
                String dotLabel;
                replacementNodes.add(0, node);
                ZestProperties.setShape((Node)node, (javafx.scene.Node)new GeometryNode((IGeometry)new Rectangle()));
                Rect bb = DotAttributes.getBbParsed((Graph)dotNode.getNestedGraph());
                Point zestPosition = null;
                Dimension zestSize = null;
                if (bb != null) {
                    zestPosition = new Point(bb.getLlx(), bb.getUry());
                    zestSize = new Dimension(bb.getUrx() - bb.getLlx(), bb.getLly() - bb.getUry());
                    ZestProperties.setPosition((Node)node, (Point)zestPosition);
                    ZestProperties.setSize((Node)node, (Dimension)zestSize);
                }
                if ("\\G".equals(dotLabel = DotAttributes.getLabel((Graph)dotNode.getNestedGraph()))) {
                    dotLabel = DotAttributes._getName((Graph)dotNode.getNestedGraph());
                }
                if (dotLabel != null) {
                    ZestProperties.setExternalLabel((Node)node, (String)dotLabel);
                    if (zestPosition != null && zestSize != null) {
                        double xOffset = 0.5 * (zestSize.width - Dot2ZestAttributesConverter.computeZestLabelSize((String)dotLabel).width);
                        double yOffset = 4.0;
                        ZestProperties.setExternalLabelPosition((Node)node, (Point)zestPosition.getTranslated(xOffset, yOffset));
                    }
                }
            }
            Graph subgraph = node.getNestedGraph();
            for (Node n : subgraph.getNodes()) {
                Edge edgeCopy;
                for (Edge e : node.getIncomingEdges()) {
                    edgeCopy = this.copyEdge(e);
                    edgeCopy.setTarget(n);
                    copiedGraph.getEdges().add((Object)edgeCopy);
                }
                for (Edge e : node.getOutgoingEdges()) {
                    edgeCopy = this.copyEdge(e);
                    edgeCopy.setSource(n);
                    copiedGraph.getEdges().add((Object)edgeCopy);
                }
            }
            replacementNodes.addAll((Collection<Node>)subgraph.getNodes());
            copiedGraph.getEdges().addAll((Collection)subgraph.getEdges());
            node.setNestedGraph(null);
        }
        copiedGraph.getNodes().setAll(replacementNodes);
        return copiedGraph;
    }
}

