/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.outline;

import com.google.inject.Injector;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhs;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.gef.dot.internal.ui.language.outline.DotHtmlLabelOutlineTreeProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.IOutlineTreeStructureProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DotOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    private Injector injector;
    private int attributeValueStartOffset;

    protected boolean _isLeaf(NodeStmt node) {
        return node.getAttrLists().isEmpty();
    }

    protected boolean _isLeaf(EdgeRhs edge) {
        return true;
    }

    protected boolean _isLeaf(Attribute attribute) {
        return attribute == null || attribute.getValue() == null || attribute.getValue().getType() != ID.Type.HTML_STRING;
    }

    protected void _createChildren(IOutlineNode parent, AttrStmt stmt) {
        if (stmt.getAttrLists().size() > 0) {
            EList attributes = ((AttrList)stmt.getAttrLists().get(0)).getAttributes();
            for (Attribute attribute : attributes) {
                this.createNode(parent, (EObject)attribute);
            }
        }
    }

    protected void _createChildren(IOutlineNode parent, Attribute attribute) {
        if (attribute.getValue().getType() == ID.Type.HTML_STRING) {
            String htmlLabelValue = attribute.getValue().toValue();
            this.injector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
            IOutlineTreeStructureProvider outlineTreeStructureProvider = (IOutlineTreeStructureProvider)this.injector.getInstance(IOutlineTreeStructureProvider.class);
            IXtextDocument xtextDocument = null;
            try {
                xtextDocument = DotEditorUtils.getDocument(this.injector, htmlLabelValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (xtextDocument != null && outlineTreeStructureProvider instanceof DotHtmlLabelOutlineTreeProvider) {
                DotHtmlLabelOutlineTreeProvider dotHtmlLabelOutlineTreeProvider = (DotHtmlLabelOutlineTreeProvider)outlineTreeStructureProvider;
                dotHtmlLabelOutlineTreeProvider.setXtextDocument(xtextDocument);
                this.attributeValueStartOffset = this.getAttributeValueStartOffset(attribute);
                dotHtmlLabelOutlineTreeProvider.setOffset(this.attributeValueStartOffset);
                HtmlLabel htmlLabel = this.getModel(xtextDocument);
                outlineTreeStructureProvider.createChildren(parent, (EObject)htmlLabel);
            }
        }
    }

    protected void _createNode(IOutlineNode parent, HtmlContent htmlContent) {
        if (htmlContent.getText() != null && !htmlContent.getText().trim().isEmpty()) {
            super._createNode(parent, (EObject)htmlContent);
        } else if (htmlContent.getTag() != null) {
            super._createNode(parent, (EObject)htmlContent.getTag());
        }
    }

    protected EObjectNode createEObjectNode(IOutlineNode parentNode, EObject modelElement, Image image, Object text, boolean isLeaf) {
        if (EcoreUtil2.getContainerOfType((EObject)modelElement, HtmlLabel.class) != null) {
            EObjectNode eObjectNode = new EObjectNode(modelElement, parentNode, image, text, isLeaf);
            ICompositeNode parserNode = NodeModelUtils.getNode((EObject)modelElement);
            if (parserNode != null) {
                ITextRegion parserNodeTextRegion = parserNode.getTextRegion();
                TextRegion newTextRegion = new TextRegion(parserNodeTextRegion.getOffset() + this.attributeValueStartOffset, parserNodeTextRegion.getLength());
                eObjectNode.setTextRegion((ITextRegion)newTextRegion);
            }
            if (this.isLocalElement(parentNode, modelElement)) {
                ITextRegion significantTextRegion = this.locationInFileProvider.getSignificantTextRegion(modelElement);
                TextRegion shortTextRegion = new TextRegion(significantTextRegion.getOffset() + this.attributeValueStartOffset, significantTextRegion.getLength());
                eObjectNode.setShortTextRegion((ITextRegion)shortTextRegion);
            }
            return eObjectNode;
        }
        return super.createEObjectNode(parentNode, modelElement, image, text, isLeaf);
    }

    private HtmlLabel getModel(IXtextDocument xtextDocument) {
        HtmlLabel model = (HtmlLabel)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<HtmlLabel, XtextResource>(){

            public HtmlLabel exec(XtextResource res) throws Exception {
                return res.getContents().size() > 0 ? (HtmlLabel)res.getContents().get(0) : null;
            }
        });
        return model;
    }

    private int getAttributeValueStartOffset(Attribute attribute) {
        ID attributeValue = attribute.getValue();
        List nodes = NodeModelUtils.findNodesForFeature((EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE);
        if (nodes.size() != 1) {
            System.err.println("Exact 1 node is expected for the attribute value: " + attributeValue + ", but got " + nodes.size());
            return 0;
        }
        INode node = (INode)nodes.get(0);
        int attributeValueStartOffset = node.getOffset();
        if (attributeValue.getType() == ID.Type.HTML_STRING || attributeValue.getType() == ID.Type.QUOTED_STRING) {
            ++attributeValueStartOffset;
        }
        return attributeValueStartOffset;
    }
}

