/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandFactory;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.lfs.Lfs;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.Protocol;
import org.eclipse.jgit.lfs.internal.LfsConnectionFactory;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.http.HttpConnection;

public class SmudgeFilter
extends FilterCommand {
    private static final int MAX_COPY_BYTES = 0x10000000;
    public static final FilterCommandFactory FACTORY = new FilterCommandFactory(){

        public FilterCommand create(Repository db, InputStream in, OutputStream out) throws IOException {
            return new SmudgeFilter(db, in, out);
        }
    };

    static void register() {
        FilterCommandRegistry.register((String)"jgit://builtin/lfs/smudge", (FilterCommandFactory)FACTORY);
    }

    public SmudgeFilter(Repository db, InputStream in, OutputStream out) throws IOException {
        super(in, out);
        try {
            Lfs lfs = new Lfs(db);
            LfsPointer res = LfsPointer.parseLfsPointer(in);
            if (res != null) {
                AnyLongObjectId oid = res.getOid();
                Path mediaFile = lfs.getMediaFile(oid);
                if (!Files.exists(mediaFile, new LinkOption[0])) {
                    SmudgeFilter.downloadLfsResource(lfs, db, res);
                }
                this.in = Files.newInputStream(mediaFile, new OpenOption[0]);
            }
        }
        finally {
            in.close();
        }
    }

    public static Collection<Path> downloadLfsResource(Lfs lfs, Repository db, LfsPointer ... res) throws IOException {
        ArrayList<Path> downloadedPaths = new ArrayList<Path>();
        HashMap<String, LfsPointer> oidStr2ptr = new HashMap<String, LfsPointer>();
        Object object = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            LfsPointer p = object[n2];
            oidStr2ptr.put(p.getOid().name(), p);
            ++n2;
        }
        HttpConnection lfsServerConn = LfsConnectionFactory.getLfsConnection(db, "POST", "download");
        Gson gson = Protocol.gson();
        lfsServerConn.getOutputStream().write(gson.toJson((Object)LfsConnectionFactory.toRequest("download", res)).getBytes(StandardCharsets.UTF_8));
        int responseCode = lfsServerConn.getResponseCode();
        if (responseCode != 200) {
            throw new IOException(MessageFormat.format(LfsText.get().serverFailure, lfsServerConn.getURL(), responseCode));
        }
        object = null;
        Object var9_11 = null;
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(lfsServerConn.getInputStream(), StandardCharsets.UTF_8));){
            Protocol.Response resp = (Protocol.Response)gson.fromJson(reader, Protocol.Response.class);
            for (Protocol.ObjectInfo o : resp.objects) {
                LfsPointer ptr;
                if (o.error != null) {
                    throw new IOException(MessageFormat.format(LfsText.get().protocolError, o.error.code, o.error.message));
                }
                if (o.actions == null || (ptr = (LfsPointer)oidStr2ptr.get(o.oid)) == null) continue;
                if (ptr.getSize() != o.size) {
                    throw new IOException(MessageFormat.format(LfsText.get().inconsistentContentLength, lfsServerConn.getURL(), ptr.getSize(), o.size));
                }
                Protocol.Action downloadAction = o.actions.get("download");
                if (downloadAction == null || downloadAction.href == null) continue;
                HttpConnection contentServerConn = LfsConnectionFactory.getLfsContentConnection(db, downloadAction, "GET");
                responseCode = contentServerConn.getResponseCode();
                if (responseCode != 200) {
                    throw new IOException(MessageFormat.format(LfsText.get().serverFailure, contentServerConn.getURL(), responseCode));
                }
                Path path = lfs.getMediaFile(ptr.getOid());
                Path parent = path.getParent();
                if (parent != null) {
                    parent.toFile().mkdirs();
                }
                Throwable throwable = null;
                Object var20_24 = null;
                try (InputStream contentIn = contentServerConn.getInputStream();){
                    long bytesCopied = Files.copy(contentIn, path, new CopyOption[0]);
                    if (bytesCopied != o.size) {
                        throw new IOException(MessageFormat.format(LfsText.get().wrongAmoutOfDataReceived, contentServerConn.getURL(), bytesCopied, o.size));
                    }
                    downloadedPaths.add(path);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        return downloadedPaths;
    }

    public int run() throws IOException {
        try {
            int totalRead = 0;
            int length = 0;
            if (this.in != null) {
                byte[] buf = new byte[8192];
                while ((length = this.in.read(buf)) != -1) {
                    this.out.write(buf, 0, length);
                    if ((totalRead += length) < 0x10000000) continue;
                    return totalRead;
                }
            }
            if (totalRead == 0 && length == -1) {
                this.in.close();
                this.out.close();
                return length;
            }
            return totalRead;
        }
        catch (IOException e) {
            this.in.close();
            this.out.close();
            throw e;
        }
    }
}

