/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ReflogCommand;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;

@Command(common=true, usage="usage_manageReflogInformation")
class Reflog
extends TextBuiltin {
    @Argument(metaVar="metaVar_ref")
    private String ref;

    Reflog() {
    }

    @Override
    protected void run() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Git git = new Git(this.db);){
            ReflogCommand cmd = git.reflog();
            if (this.ref != null) {
                cmd.setRef(this.ref);
            }
            Collection entries = cmd.call();
            int i = 0;
            for (ReflogEntry entry : entries) {
                this.outw.println(this.toString(entry, i++));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String toString(ReflogEntry entry, int i) {
        StringBuilder s = new StringBuilder();
        s.append(entry.getNewId().abbreviate(7).name());
        s.append(" ");
        s.append(this.ref == null ? "HEAD" : Repository.shortenRefName((String)this.ref));
        s.append("@{" + i + "}:");
        s.append(" ");
        s.append(entry.getComment());
        return s.toString();
    }
}

