/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.libval;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jpt.common.core.internal.libval.LibraryValidatorTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.common.eclipselink.core.internal.libval.EclipseLinkLibraryValidatorTools;
import org.eclipse.jpt.jaxb.core.internal.libprov.JaxbUserLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.eclipselink.core.JptJaxbEclipseLinkCoreMessages;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.plugin.JptJaxbEclipseLinkCorePlugin;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ELJaxbUserLibraryValidator
implements LibraryValidator {
    private static final HashMap<String, VersionRange> PLATFORM_VERSION_RANGES = ELJaxbUserLibraryValidator.buildPlatformVersionRanges();
    private static final ArrayList<String> XJC_CLASS_NAMES = ELJaxbUserLibraryValidator.buildXjcClassNames();

    public IStatus validate(JptLibraryProviderInstallOperationConfig config) {
        return this.validate((JaxbUserLibraryProviderInstallOperationConfig)config);
    }

    private IStatus validate(JaxbUserLibraryProviderInstallOperationConfig config) {
        String platformID = config.getJaxbPlatformConfig().getId();
        VersionRange versionRange = PLATFORM_VERSION_RANGES.get(platformID);
        IStatus status = EclipseLinkLibraryValidatorTools.validateEclipseLinkVersion((UserLibraryProviderInstallOperationConfig)config, (VersionRange)versionRange);
        if (!status.isOK()) {
            return status;
        }
        status = LibraryValidatorTools.validateClasses((UserLibraryProviderInstallOperationConfig)config, XJC_CLASS_NAMES);
        return status.isOK() ? status : JptJaxbEclipseLinkCorePlugin.instance().buildWarningStatus(JptJaxbEclipseLinkCoreMessages.EL_JAXB_USER_LIBRARY_VALIDATOR__NO_XJC_CLASSES);
    }

    private static HashMap<String, VersionRange> buildPlatformVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("eclipselink_2_1", new VersionRange("[2.1, 3.0)"));
        versionRanges.put("eclipselink_2_2", new VersionRange("[2.2, 3.0)"));
        versionRanges.put("eclipselink_2_3", new VersionRange("[2.3, 3.0)"));
        versionRanges.put("eclipselink_2_4", new VersionRange("[2.4, 3.0)"));
        versionRanges.put("eclipselink_2_5", new VersionRange("[2.5, 3.0)"));
        return versionRanges;
    }

    private static ArrayList<String> buildXjcClassNames() {
        ArrayList<String> xjcClassNames = new ArrayList<String>();
        xjcClassNames.add("com.sun.tools.xjc.XJCFacade");
        xjcClassNames.add("com.sun.xml.bind.Util");
        return xjcClassNames;
    }
}

