/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.logging.internal.Level;
import org.eclipse.jwt.we.misc.views.ViewItemWrapper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.views.internal.AnalyseEcore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewEcoreManager {
    private Logger logger = Logger.getLogger(ViewEcoreManager.class);
    private static ViewEcoreManager myinstance = null;
    public static final String VIEWEXTENSION = "view";
    private static String pathtoecorefile = "";
    private List<ViewItemWrapper> items = new ArrayList<ViewItemWrapper>();
    private Hashtable<String, List<ViewItemWrapper>> attributes = new Hashtable();

    private ViewEcoreManager() {
    }

    public static ViewEcoreManager getInstance() {
        if (myinstance == null) {
            myinstance = new ViewEcoreManager();
        }
        return myinstance;
    }

    public void setName(String name) {
        Views.getInstance().getSelectedView().setInternalID(name);
    }

    public String getName() {
        return Views.getInstance().getSelectedView().getInternalName();
    }

    public void setPath(String uri) {
        pathtoecorefile = uri;
    }

    public void setDisplay(ViewItemWrapper viw, boolean value) {
        Views.getInstance().setDisplay(viw, value);
    }

    public void reset() {
        Views.getInstance().reset();
        this.items.clear();
        this.attributes.clear();
        try {
            AnalyseEcore ec = new AnalyseEcore(pathtoecorefile);
            List packages = ec.getPackagesList();
            int i = 0;
            while (i < packages.size()) {
                this.analysePackage((EObject)packages.get(i), null);
                ++i;
            }
            Collections.sort(this.items);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, ex.toString());
        }
    }

    private void analysePackage(EObject obj, ViewItemWrapper viw) {
        EList contents = obj.eContents();
        ViewItemWrapper lastview = null;
        if (obj instanceof EPackage || obj instanceof EClass) {
            int i = 0;
            while (i < contents.size()) {
                EObject newobj = null;
                try {
                    newobj = (EObject)contents.get(i);
                }
                catch (Exception exception) {}
                if (newobj instanceof EPackage) {
                    this.analysePackage(newobj, viw);
                } else if (newobj instanceof EClass) {
                    lastview = new ViewItemWrapper(newobj, true, true);
                    Views.getInstance().addViewItemWrapper(lastview, null);
                    this.items.add(lastview);
                    EList elementcontents = newobj.eContents();
                    int i2 = 0;
                    while (i2 < elementcontents.size()) {
                        this.analysePackage((EObject)elementcontents.get(i2), lastview);
                        ++i2;
                    }
                }
                ++i;
            }
        } else if (obj instanceof EAttribute) {
            this.makeLookup(viw, obj);
        } else if (obj instanceof EReference) {
            this.makeLookup(viw, obj);
        }
    }

    private void makeLookup(ViewItemWrapper parentview, EObject obj) {
        List<ViewItemWrapper> val = this.attributes.get(parentview.toString());
        if (val == null) {
            val = new ArrayList<ViewItemWrapper>();
            this.attributes.put(parentview.toString(), (ArrayList)val);
        }
        ViewItemWrapper viw = new ViewItemWrapper(obj, true, true);
        ((ArrayList)val).add(viw);
        Views.getInstance().addViewItemWrapper(viw, parentview);
    }

    public List<ViewItemWrapper> getItemsList() {
        return this.items;
    }

    public List<ViewItemWrapper> getAttributesList(ViewItemWrapper obj) {
        List<ViewItemWrapper> val = this.attributes.get(obj.toString());
        if (val == null) {
            return null;
        }
        return val;
    }

    public void savetoFile(File f) {
        Views.getInstance().saveCurrentView(f);
    }

    public void openFile(File f) {
        this.reset();
        Views.getInstance().loadViewFromFile(f);
        Hashtable<String, ViewItemWrapper> currentview = Views.getInstance().getSelectedView().getViewData();
        this.adjustList(this.items, currentview);
        Enumeration<List<ViewItemWrapper>> elements = this.attributes.elements();
        while (elements.hasMoreElements()) {
            this.adjustList(elements.nextElement(), currentview);
        }
    }

    private void adjustList(List<ViewItemWrapper> elements, Hashtable<String, ViewItemWrapper> elementlist) {
        int i = 0;
        while (i < elements.size()) {
            ViewItemWrapper viw = elements.get(i);
            ViewItemWrapper obj = elementlist.get(viw.toString());
            if (obj != null) {
                elements.set(i, obj);
            } else {
                elementlist.put(viw.toString(), viw);
            }
            ++i;
        }
    }
}

