/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CommandMarkerResolution
extends WorkbenchMarkerResolution
implements IMarkerResolution {
    private @NonNull Command command;

    public CommandMarkerResolution(@NonNull Command command) {
        this.command = command;
    }

    public String getLabel() {
        return this.command.getTitle();
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        String languageServerId = marker.getAttribute("languageServerId", null);
        CommandMarkerResolution.executeCommand(this.command, resource, languageServerId);
    }

    static void executeCommand(Command command, IResource resource, String languageServerId) {
        if (command == null) {
            return;
        }
        if (languageServerId != null) {
            LanguageServersRegistry.LanguageServerDefinition languageServerDefinition = LanguageServersRegistry.getInstance().getDefinition(languageServerId);
            if (resource.getType() == 1 && languageServerDefinition != null) {
                IFile file = (IFile)resource;
                try {
                    CompletableFuture<LanguageServer> languageServerFuture = LanguageServiceAccessor.getInitializedLanguageServer(file, languageServerDefinition, serverCapabilities -> {
                        ExecuteCommandOptions provider = serverCapabilities.getExecuteCommandProvider();
                        return provider != null && provider.getCommands().contains(command.getCommand());
                    });
                    if (languageServerFuture != null) {
                        languageServerFuture.thenAccept(server -> {
                            ExecuteCommandParams params = new ExecuteCommandParams();
                            params.setCommand(command.getCommand());
                            params.setArguments(command.getArguments());
                            server.getWorkspaceService().executeCommand(params);
                        });
                        return;
                    }
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        if (command.getArguments() != null) {
            WorkspaceEdit edit = LSPEclipseUtils.createWorkspaceEdit(command.getArguments(), resource);
            LSPEclipseUtils.applyWorkspaceEdit(edit);
        }
    }

    public String getDescription() {
        return this.command.getTitle();
    }

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }
}

