/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.ui.properties.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xwt.XWT;

public class AbstractView
extends Composite {
    public AbstractView(Composite parent, int style) {
        super(parent, style);
    }

    protected EditingDomain getEditingDomain(EObject owner) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)owner);
    }

    protected void performAddEvent(String featureName) {
        EClassifier eType;
        EObject eObj;
        EStructuralFeature sf;
        Object dataContext = XWT.getDataContext((Object)((Object)this));
        if (dataContext instanceof EObject && (sf = (eObj = (EObject)dataContext).eClass().getEStructuralFeature(featureName)) != null && sf.isMany() && sf.isChangeable() && (eType = sf.getEType()) instanceof EClass && !((EClass)eType).isAbstract() && !((EClass)eType).isInterface()) {
            EObject newObject = eType.getEPackage().getEFactoryInstance().create((EClass)eType);
            boolean hasResource = true;
            if (!((EReference)sf).isContainment()) {
                Collection<?> choiceOfValues = this.getChoiceOfValues(eObj, eType);
                FeatureEditorDialog dialog = new FeatureEditorDialog(this.getDisplay().getActiveShell(), (ILabelProvider)new LabelProvider(), (Object)eObj, eType, new ArrayList(), Display.getAppName(), new ArrayList(choiceOfValues), false, true, true);
                dialog.open();
                this.doAdd(eObj, sf, dialog.getResult());
            } else if (hasResource) {
                this.doAdd(eObj, sf, (EList)Collections.singletonList(newObject));
            }
        }
    }

    private Collection<?> getChoiceOfValues(EObject eObj, EClassifier type) {
        return ItemPropertyDescriptor.getReachableObjectsOfType((EObject)eObj, (EClassifier)type);
    }

    protected boolean doAddResource(Resource resource, EObject newObject) {
        return false;
    }

    protected boolean doAdd(EObject owner, EStructuralFeature feature, EList<?> newChild) {
        if (owner == null || feature == null || newChild == null) {
            return false;
        }
        EditingDomain editingDomain = this.getEditingDomain(owner);
        if (editingDomain != null) {
            Command command = AddCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, newChild);
            if (command != null && command.canExecute()) {
                CommandStack commandStack = editingDomain.getCommandStack();
                if (commandStack != null) {
                    commandStack.execute(command);
                } else {
                    command.execute();
                }
                return true;
            }
        } else {
            EList ownerList = AddCommand.getOwnerList((EObject)owner, (EStructuralFeature)feature);
            if (ownerList != null) {
                return ownerList.add(newChild);
            }
        }
        return false;
    }

    protected void performRemoveEvent(String featureName) {
        EObject eObj;
        EStructuralFeature sf;
        Viewer viewer = (Viewer)XWT.findElementByName((Object)((Object)this), (String)(String.valueOf(featureName) + "Viewer"));
        if (viewer == null) {
            return;
        }
        ISelection selection = viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element == null) {
            return;
        }
        Object dataContext = XWT.getDataContext((Object)((Object)this));
        if (dataContext instanceof EObject && (sf = (eObj = (EObject)dataContext).eClass().getEStructuralFeature(featureName)) != null && sf.isMany() && sf.isChangeable()) {
            this.doRemove(eObj, sf, element);
        }
    }

    protected boolean doRemove(EObject owner, EStructuralFeature feature, Object element) {
        if (owner == null || feature == null || element == null) {
            return false;
        }
        EditingDomain domain = this.getEditingDomain(owner);
        if (domain != null) {
            Command command = RemoveCommand.create((EditingDomain)domain, (Object)owner, (Object)feature, (Object)element);
            if (command != null && command.canExecute()) {
                CommandStack commandStack = domain.getCommandStack();
                if (commandStack != null) {
                    commandStack.execute(command);
                } else {
                    command.execute();
                }
                return true;
            }
        } else {
            EList ownerList = RemoveCommand.getOwnerList((EObject)owner, (EStructuralFeature)feature);
            if (ownerList != null) {
                return ownerList.remove(element);
            }
        }
        return false;
    }

    protected void performMoveUpEvent(String featureName) {
        Viewer viewer = (Viewer)XWT.findElementByName((Object)((Object)this), (String)(String.valueOf(featureName) + "Viewer"));
        if (viewer == null) {
            return;
        }
        ISelection selection = viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element == null) {
            return;
        }
        Object dataContext = XWT.getDataContext((Object)((Object)this));
        if (dataContext instanceof EObject) {
            EObject eObj = (EObject)dataContext;
            EStructuralFeature sf = eObj.eClass().getEStructuralFeature(featureName);
            EList ownerList = AbstractOverrideableCommand.getOwnerList((EObject)eObj, (EStructuralFeature)sf);
            if (ownerList == null || !ownerList.contains(element)) {
                return;
            }
            int index = ownerList.indexOf(element);
            if (index >= 1) {
                this.doMove(eObj, sf, element, index - 1);
            }
        }
    }

    protected boolean doMove(EObject owner, EStructuralFeature feature, Object value, int index) {
        if (owner == null || feature == null || value == null) {
            return false;
        }
        EditingDomain domain = this.getEditingDomain(owner);
        if (domain != null) {
            Command command = MoveCommand.create((EditingDomain)domain, (Object)owner, (Object)feature, (Object)value, (int)index);
            if (command != null && command.canExecute()) {
                CommandStack commandStack = domain.getCommandStack();
                if (commandStack != null) {
                    commandStack.execute(command);
                } else {
                    command.execute();
                }
                return true;
            }
        } else {
            EList ownerList = AbstractOverrideableCommand.getOwnerList((EObject)owner, (EStructuralFeature)feature);
            if (ownerList != null && index >= 0 && index < ownerList.size()) {
                ownerList.move(index, value);
                return true;
            }
        }
        return false;
    }

    protected void performMoveDownEvent(String featureName) {
        Viewer viewer = (Viewer)XWT.findElementByName((Object)((Object)this), (String)(String.valueOf(featureName) + "Viewer"));
        if (viewer == null) {
            return;
        }
        ISelection selection = viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element == null) {
            return;
        }
        Object dataContext = XWT.getDataContext((Object)((Object)this));
        if (dataContext instanceof EObject) {
            EObject eObj = (EObject)dataContext;
            EStructuralFeature sf = eObj.eClass().getEStructuralFeature(featureName);
            EList ownerList = AbstractOverrideableCommand.getOwnerList((EObject)eObj, (EStructuralFeature)sf);
            if (ownerList == null || !ownerList.contains(element)) {
                return;
            }
            int index = ownerList.indexOf(element);
            if (index < ownerList.size() - 1) {
                this.doMove(eObj, sf, element, index + 1);
            }
        }
    }
}

