/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.junit.annotation.AnnotationUtils;
import org.eclipse.reddeer.junit.annotation.RequirementRestriction;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.requirement.RequirementHelper;
import org.eclipse.reddeer.junit.requirement.ConfigurableRequirement;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.requirement.configuration.MissingRequirementConfiguration;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;
import org.eclipse.reddeer.junit.requirement.matcher.RequirementMatcher;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class SuiteConfiguration {
    private Class<?> suiteClass;
    private Map<RequirementConfigurationSet, List<Class<?>>> configurationSetSuites = new HashMap();

    public SuiteConfiguration(Class<?> clazz) throws InitializationError {
        this.suiteClass = clazz;
        this.createTestSuites(clazz);
    }

    public Map<RequirementConfigurationSet, List<Class<?>>> getConfigurationSetsSuites() {
        return this.configurationSetSuites;
    }

    private void createTestSuites(Class<?> suiteClass) throws InitializationError {
        if (suiteClass == null) {
            throw new InitializationError("Suite class given is null");
        }
        List<Class<?>> testClasses = this.getTestClasses(suiteClass);
        for (Class<?> clazz : testClasses) {
            List<Requirement<?>> requirements = RequirementHelper.getRequirements(clazz);
            ArrayList requirementConfigurationsLists = new ArrayList();
            boolean shouldHaveConfig = false;
            Collection<RequirementMatcher> matchers = this.getRequirementRestrictions(clazz);
            this.checkMatchersAreValid(matchers);
            for (Requirement<?> requirement : requirements) {
                if (!ConfigurableRequirement.class.isAssignableFrom(requirement.getClass())) continue;
                shouldHaveConfig = true;
                requirementConfigurationsLists.add(RequirementHelper.getRequirementConfigurations((ConfigurableRequirement)requirement, matchers));
            }
            if (shouldHaveConfig && ((List)requirementConfigurationsLists.get(0)).isEmpty()) {
                HashSet<RequirementConfiguration> hashSet = new HashSet<RequirementConfiguration>();
                hashSet.add(new MissingRequirementConfiguration());
                this.updateMap(new RequirementConfigurationSet(hashSet), clazz);
                continue;
            }
            if (requirementConfigurationsLists.isEmpty()) {
                this.updateMap(new RequirementConfigurationSet(), clazz);
                continue;
            }
            for (List list : SuiteConfiguration.getCartesianProduct(requirementConfigurationsLists)) {
                HashSet<RequirementConfiguration> configSet = new HashSet<RequirementConfiguration>();
                configSet.addAll(list);
                this.updateMap(new RequirementConfigurationSet(configSet), clazz);
            }
        }
    }

    private Collection<RequirementMatcher> getRequirementRestrictions(Class<?> clazz) {
        Object obj = AnnotationUtils.invokeStaticMethodWithAnnotation(clazz, RequirementRestriction.class, Collection.class, RequirementMatcher.class);
        if (obj instanceof RequirementMatcher) {
            return Collections.singletonList((RequirementMatcher)((Object)obj));
        }
        return (Collection)obj;
    }

    private void checkMatchersAreValid(Collection<RequirementMatcher> matchers) {
        if (matchers != null) {
            matchers.stream().collect(Collectors.groupingBy(RequirementMatcher::getConfigurationClass)).forEach((confClass, withSameConfClass) -> {
                if (withSameConfClass.size() > 1) {
                    throw new RedDeerException("More than one matcher is defined for the '" + confClass + "' requirement.");
                }
            });
        }
    }

    private void updateMap(RequirementConfigurationSet requirementConfigurationSet, Class<?> clazz) {
        if (this.configurationSetSuites.containsKey(requirementConfigurationSet)) {
            List<Class<?>> classes = this.configurationSetSuites.get(requirementConfigurationSet);
            ArrayList updatedList = new ArrayList();
            updatedList.addAll(classes);
            updatedList.add(clazz);
            this.configurationSetSuites.put(requirementConfigurationSet, updatedList);
        } else {
            this.configurationSetSuites.put(requirementConfigurationSet, Arrays.asList(clazz));
        }
    }

    private static <T> List<List<T>> getCartesianProduct(List<List<T>> lists) {
        ArrayList<List<T>> resultLists = new ArrayList<List<T>>();
        if (lists.size() == 0) {
            resultLists.add(new ArrayList());
            return resultLists;
        }
        List<T> firstList = lists.get(0);
        List<List<T>> remainingLists = SuiteConfiguration.getCartesianProduct(lists.subList(1, lists.size()));
        for (T listElement : firstList) {
            for (List<T> remainingList : remainingLists) {
                ArrayList<T> resultList = new ArrayList<T>();
                resultList.add(listElement);
                resultList.addAll(remainingList);
                resultLists.add(resultList);
            }
        }
        return resultLists;
    }

    private List<Class<?>> getTestClasses(Class<?> suiteClass) {
        ArrayList classes = new ArrayList();
        Suite.SuiteClasses suiteAnnontation = suiteClass.getAnnotation(Suite.SuiteClasses.class);
        if (suiteAnnontation != null) {
            Class[] classArray = suiteAnnontation.value();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                if (clazz.getAnnotation(Suite.SuiteClasses.class) != null) {
                    classes.addAll(this.getTestClasses(clazz));
                } else {
                    classes.add(clazz);
                }
                ++n2;
            }
        } else {
            classes.add(this.suiteClass);
        }
        return classes;
    }
}

