/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SetMessageRangeOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SetVerticalRangeOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.ShiftDirectSubExecutionsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.VerticalSpaceExpansion;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ShiftDescendantMessagesOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.ISEComplexMoveCommandBuilder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceInteractionFeedBackBuilder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractNodeEventResizeSelectionValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.ISEComplexMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.RangeGuide;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SpecificBorderItemSelectionEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.ext.draw2d.figure.HorizontalGuide;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.swt.graphics.Color;

public class ExecutionSelectionEditPolicy
extends SpecificBorderItemSelectionEditPolicy {
    protected static final Color EXECUTION_FEEDBACK_COLOR = ColorConstants.lightGray;
    protected Collection<Figure> guides = new ArrayList<Figure>();

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        this.cancelHorizontalDelta(request);
        Object solution = IdentityCommand.INSTANCE;
        ExecutionEditPart hostPart = (ExecutionEditPart)this.getHost();
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (hostPart.getSelected() == 2 && requestQuery.isMove()) {
            ISEComplexMoveValidator validator = ISEComplexMoveValidator.getOrCreateValidator(request, requestQuery, hostPart.getISequenceEvent());
            solution = validator != null && validator.isValid() ? this.buildMoveCommand(hostPart, request, validator) : UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)solution);
    }

    private ICommand buildMoveCommand(ExecutionEditPart hostPart, ChangeBoundsRequest request, ISEComplexMoveValidator validator) {
        TransactionalEditingDomain editingDomain = hostPart.getEditingDomain();
        RequestQuery requestQuery = new RequestQuery((Request)request);
        ISEComplexMoveCommandBuilder builder = new ISEComplexMoveCommandBuilder(editingDomain, Messages.ExecutionSelectionEditPolicy_moveCompositeCommand, requestQuery, validator);
        return this.postProcessCommand(builder.buildCommand(), hostPart, requestQuery);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        AbstractNodeEventResizeSelectionValidator validator;
        org.eclipse.gef.commands.UnexecutableCommand result = org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        ExecutionEditPart hostPart = (ExecutionEditPart)this.getHost();
        AbstractNodeEvent host = (AbstractNodeEvent)hostPart.getISequenceEvent();
        Command resizeParentToTopCmd = null;
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (requestQuery.isResizeFromTop() && request.getSizeDelta().height() > 0) {
            ISequenceEvent parentEvent = host.getParentEvent();
            EditPart parentEventEditPart = (EditPart)hostPart.getViewer().getEditPartRegistry().get(parentEvent.getNotationView());
            if (hostPart != null && parentEventEditPart != null) {
                Rectangle executionFinalBounds = requestQuery.getFinalBounds(hostPart);
                Range executionFinalRange = RangeHelper.verticalRange((Rectangle)executionFinalBounds);
                if (parentEvent.getValidSubEventsRange().getLowerBound() >= executionFinalRange.getLowerBound()) {
                    ChangeBoundsRequest parentRequest = new ChangeBoundsRequest(request.getType());
                    int yDelta = parentEvent.getValidSubEventsRange().getLowerBound() - executionFinalRange.getLowerBound();
                    parentRequest.setMoveDelta((Point)new PrecisionPoint(request.getMoveDelta().x(), -yDelta));
                    parentRequest.setSizeDelta(new Dimension(request.getSizeDelta().width(), yDelta));
                    parentRequest.setEditParts(parentEventEditPart);
                    parentRequest.setResizeDirection(request.getResizeDirection());
                    parentRequest.setLocation(request.getLocation());
                    resizeParentToTopCmd = parentEventEditPart.getCommand((Request)parentRequest);
                }
            }
        }
        if ((validator = AbstractNodeEventResizeSelectionValidator.getOrCreateValidator(request, host)).isValid()) {
            ICommand solution = this.buildResizeCommand(request, hostPart, validator);
            if (solution == null) {
                solution = IdentityCommand.INSTANCE;
            }
            if (resizeParentToTopCmd == null) {
                result = new ICommandProxy(solution);
            } else if (resizeParentToTopCmd.canExecute()) {
                CompoundCommand cc = new CompoundCommand(solution.getLabel());
                cc.add(resizeParentToTopCmd);
                cc.add((Command)new ICommandProxy(solution));
                result = cc;
            }
        }
        return result;
    }

    private ICommand buildResizeCommand(ChangeBoundsRequest request, ExecutionEditPart hostPart, AbstractNodeEventResizeSelectionValidator validator) {
        TransactionalEditingDomain editingDomain = hostPart.getEditingDomain();
        ICommand solution = null;
        AbstractNodeEvent self = (AbstractNodeEvent)hostPart.getISequenceEvent();
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (requestQuery.isMultiSelectionOperation()) {
            validator.setExpansionZone(null);
        }
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(editingDomain, Messages.ExecutionSelectionEditPolicy_resizeCompositeCommand);
        if (this.needVerticalSpaceExpansion(validator, request)) {
            SequenceDiagramEditPart diagram = EditPartsHelper.getSequenceDiagramPart((IGraphicalEditPart)hostPart);
            List<AbstractNodeEvent> eventToIgnore = Collections.singletonList(self);
            ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new VerticalSpaceExpansion(diagram.getSequenceDiagram(), validator.getExpansionZone(), Integer.valueOf(0), eventToIgnore)));
        }
        if (validator.getFinalHierarchicalParent().equals(self.getHierarchicalParentEvent())) {
            Command cmd = DiagramBorderNodeEditPartOperation.getResizeBorderItemCommand((IGraphicalEditPart)((ExecutionEditPart)this.getHost()), (ChangeBoundsRequest)request, (boolean)false);
            ctc.add((IUndoableOperation)new CommandProxy(cmd));
            ctc.setLabel(cmd.getLabel());
            if (self instanceof Execution) {
                this.addChildrenAdjustmentCommands((Execution)self, ctc, editingDomain, request, validator);
            }
            solution = this.postProcessCommand(ctc, hostPart, requestQuery);
        }
        return solution;
    }

    protected ICommand postProcessCommand(CompositeTransactionalCommand ctc, ExecutionEditPart selfEditPart, RequestQuery requestQuery) {
        AbstractNodeEvent self = (AbstractNodeEvent)selfEditPart.getISequenceEvent();
        SequenceEditPartsOperations.addRefreshGraphicalOrderingCommand(ctc, (IGraphicalEditPart)selfEditPart);
        SequenceEditPartsOperations.addRefreshSemanticOrderingCommand(ctc, (IGraphicalEditPart)selfEditPart);
        List linkedMessages = self.getLinkedMessages();
        if (!linkedMessages.isEmpty() && !((Message)linkedMessages.get(0)).isLogicallyInstantaneous()) {
            SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(ctc, (ISequenceEvent)linkedMessages.get(0));
        }
        if (requestQuery.isMultiSelectionOperation()) {
            SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(ctc, (ISequenceEvent)self, requestQuery.getISequenceEvents());
        } else {
            SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(ctc, (ISequenceEvent)self);
        }
        if (linkedMessages.size() >= 2 && !((Message)linkedMessages.get(1)).isLogicallyInstantaneous()) {
            SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(ctc, (ISequenceEvent)linkedMessages.get(1));
        }
        return ctc;
    }

    private boolean needVerticalSpaceExpansion(AbstractNodeEventResizeSelectionValidator validator, ChangeBoundsRequest request) {
        return validator.getExpansionZone() != null && !new RequestQuery((Request)request).isExecutionMovedIndirectly();
    }

    private Collection<ISequenceEvent> getSequenceEventsUpperToInsertionTime(SequenceDiagram sequenceDiagram, int lowerBound) {
        ArrayList<ISequenceEvent> result = new ArrayList<ISequenceEvent>();
        Set allDelimitedSequenceEvents = sequenceDiagram.getAllAbstractNodeEvents();
        for (ISequenceEvent sequenceEvent : allDelimitedSequenceEvents) {
            if (sequenceEvent.getVerticalRange().getLowerBound() <= lowerBound) continue;
            result.add(sequenceEvent);
        }
        return result;
    }

    protected Integer getVMove(ChangeBoundsRequest cbr) {
        Rectangle logicalDelta = new RequestQuery((Request)cbr).getLogicalDelta();
        return logicalDelta.y;
    }

    private void addChildrenAdjustmentCommands(Execution exec, CompositeTransactionalCommand cc, TransactionalEditingDomain editingDomain, ChangeBoundsRequest cbr, AbstractNodeEventResizeSelectionValidator validator) {
        RequestQuery rq = new RequestQuery((Request)cbr);
        Rectangle logicalDelta = rq.getLogicalDelta();
        int moveDelta = logicalDelta.y;
        int sizeDelta = logicalDelta.height;
        if (rq.isResizeFromTop()) {
            cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new ShiftDirectSubExecutionsOperation((ISequenceEvent)exec, sizeDelta)));
            cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new ShiftDescendantMessagesOperation((ISequenceEvent)exec, moveDelta, true, false, true)));
            this.addCompoundEventsMoveCommands(exec, cc, editingDomain, true, moveDelta, cbr, validator);
            this.addCompoundEventsMoveCommands(exec, cc, editingDomain, false, 0, cbr, validator);
        } else if (rq.isResizeFromBottom()) {
            cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new ShiftDescendantMessagesOperation((ISequenceEvent)exec, sizeDelta, true, false, false)));
            this.addCompoundEventsMoveCommands(exec, cc, editingDomain, true, 0, cbr, validator);
            this.addCompoundEventsMoveCommands(exec, cc, editingDomain, false, sizeDelta, cbr, validator);
        }
    }

    private void addCompoundEventsMoveCommands(Execution self, CompositeTransactionalCommand cc, TransactionalEditingDomain editingDomain, final boolean top, int height, ChangeBoundsRequest request, AbstractNodeEventResizeSelectionValidator validator) {
        List findEnds = EventEndHelper.findEndsFromSemanticOrdering((ISequenceEvent)self);
        RequestQuery rq = new RequestQuery((Request)request);
        Range oldRange = self.getVerticalRange();
        int movedBound = top ? oldRange.getLowerBound() : oldRange.getUpperBound();
        final EObject sem = (EObject)self.getSemanticTargetElement().get();
        Predicate<SingleEventEnd> toMove = new Predicate<SingleEventEnd>(){

            public boolean apply(SingleEventEnd input) {
                return !input.getSemanticEvent().equals(sem);
            }
        };
        Predicate<EventEnd> moved = new Predicate<EventEnd>(){

            public boolean apply(EventEnd input) {
                return EventEndHelper.getSingleEventEnd((EventEnd)input, (EObject)sem).isStart() == top;
            }
        };
        SequenceDiagram sequenceDiagram = self.getDiagram();
        for (CompoundEventEnd cee : Iterables.filter((Iterable)Iterables.filter((Iterable)findEnds, (Predicate)moved), CompoundEventEnd.class)) {
            for (SingleEventEnd see : Iterables.filter((Iterable)Lists.newArrayList((Iterable)cee.getEventEnds()), (Predicate)toMove)) {
                ISequenceEvent ise = EventEndHelper.findISequenceEvent((SingleEventEnd)see, (SequenceDiagram)sequenceDiagram);
                if (ise == null) continue;
                Range seeRange = ise.getVerticalRange();
                int lDelta = 0;
                int uDelta = 0;
                if (seeRange.getLowerBound() == movedBound && this.doNotMoveSourceOfReturnMessageOfReflexiveSyncCall(self, ise, rq)) {
                    lDelta = height;
                    if (new ISequenceEventQuery(ise).isReflectiveMessage() && this.getSelection((ISequenceElement)ise) == 0) {
                        uDelta = height;
                    }
                }
                if (seeRange.getUpperBound() == movedBound && this.doNotMoveTargetOfStartMessageOfReflexiveSyncCall(self, ise, rq)) {
                    uDelta = height;
                    if (new ISequenceEventQuery(ise).isReflectiveMessage() && this.getSelection((ISequenceElement)ise) == 0) {
                        lDelta = height;
                    }
                }
                if (seeRange.getLowerBound() + lDelta <= seeRange.getUpperBound() + uDelta) {
                    Range newRange = new Range(seeRange.getLowerBound() + lDelta, seeRange.getUpperBound() + uDelta);
                    if (ise instanceof Message && !this.hasBothEndMoving((Message)ise)) {
                        Message msg = (Message)ise;
                        this.addMessageReconnectionCommand(self, cc, editingDomain, msg, newRange, request, validator);
                        continue;
                    }
                    cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new SetVerticalRangeOperation(ise, newRange)));
                    continue;
                }
                cc.compose((IUndoableOperation)UnexecutableCommand.INSTANCE);
            }
        }
    }

    private int getSelection(ISequenceElement ise) {
        Map editPartRegistry = this.getHost().getViewer().getEditPartRegistry();
        Object object = editPartRegistry.get(ise.getNotationView());
        if (object instanceof EditPart) {
            return ((EditPart)object).getSelected();
        }
        return Integer.MIN_VALUE;
    }

    private void addMessageReconnectionCommand(Execution self, CompositeTransactionalCommand cc, TransactionalEditingDomain editingDomain, Message message, Range newRange, ChangeBoundsRequest request, AbstractNodeEventResizeSelectionValidator validator) {
        Option tgtLifeline;
        Option srcLifeline;
        Set<Execution> executionsInMove = new RequestQuery((Request)request).getExecutions();
        boolean invalidCommand = false;
        Predicate<EventEnd> filterCompoundEventEnd = new Predicate<EventEnd>(){

            public boolean apply(EventEnd input) {
                return input instanceof CompoundEventEnd;
            }
        };
        SetMessageRangeOperation smrc = new SetMessageRangeOperation((Edge)message.getNotationView(), newRange);
        Lifeline selfLifeline = (Lifeline)self.getLifeline().get();
        Rectangle logicalDelta = new RequestQuery((Request)request).getLogicalDelta();
        Rectangle bounds = self.getProperLogicalBounds().getCopy();
        bounds.translate(logicalDelta.getLocation());
        bounds.resize(logicalDelta.getSize());
        Range thisFinalRange = RangeHelper.verticalRange((Rectangle)bounds);
        ArrayList<Object> toIgnore = new ArrayList<Object>();
        boolean isReplyMessage = message.getKind() == Message.Kind.REPLY;
        boolean isReflective = message.isReflective();
        ISequenceNode sourceElement = message.getSourceElement();
        ISequenceNode targetElement = message.getTargetElement();
        if (!isReplyMessage && isReflective && Iterables.any((Iterable)EventEndHelper.findEndsFromSemanticOrdering((ISequenceEvent)message), (Predicate)filterCompoundEventEnd) && targetElement == self) {
            toIgnore.add(self);
        }
        if (this.needVerticalSpaceExpansion(validator, request)) {
            Collection<ISequenceEvent> sequenceEventsUpperToInsertionTime = this.getSequenceEventsUpperToInsertionTime(self.getDiagram(), validator.getExpansionZone().getLowerBound());
            sequenceEventsUpperToInsertionTime.removeAll(executionsInMove);
            toIgnore.addAll(sequenceEventsUpperToInsertionTime);
        }
        if ((srcLifeline = message.getSourceLifeline()).some()) {
            EventFinder srcFinder = new EventFinder((Lifeline)srcLifeline.get());
            srcFinder.setReconnection(true);
            srcFinder.setEventsToIgnore(Predicates.in(toIgnore));
            srcFinder.setExpansionZone(validator.getExpansionZone());
            ISequenceEvent finalSrc = srcLifeline.get() == selfLifeline && sourceElement == self ? self : srcFinder.findMostSpecificEvent(newRange);
            Range finalSrcRange = srcLifeline.get() == selfLifeline && sourceElement == self ? thisFinalRange : finalSrc.getVerticalRange();
            smrc.setSource(finalSrc.getNotationView(), new Rectangle(0, finalSrcRange.getLowerBound(), 0, finalSrcRange.width()));
        } else {
            Range finalSrcRange = RangeHelper.verticalRange((Rectangle)sourceElement.getProperLogicalBounds());
            smrc.setSource(sourceElement.getNotationView(), new Rectangle(0, finalSrcRange.getLowerBound(), 0, finalSrcRange.width()));
        }
        toIgnore.clear();
        if (isReplyMessage && isReflective && Iterables.any((Iterable)EventEndHelper.findEndsFromSemanticOrdering((ISequenceEvent)message), (Predicate)filterCompoundEventEnd) && sourceElement == self) {
            toIgnore.add(self);
        }
        if (this.needVerticalSpaceExpansion(validator, request)) {
            Collection<ISequenceEvent> sequenceEventsUpperToInsertionTime = this.getSequenceEventsUpperToInsertionTime(self.getDiagram(), validator.getExpansionZone().getLowerBound());
            sequenceEventsUpperToInsertionTime.removeAll(executionsInMove);
            toIgnore.addAll(sequenceEventsUpperToInsertionTime);
        }
        if ((tgtLifeline = message.getTargetLifeline()).some()) {
            ISequenceEvent finalTgt;
            EventFinder tgtFinder = new EventFinder((Lifeline)tgtLifeline.get());
            tgtFinder.setReconnection(true);
            tgtFinder.setEventsToIgnore(Predicates.in(toIgnore));
            tgtFinder.setExpansionZone(validator.getExpansionZone());
            Object object = finalTgt = tgtLifeline.get() == selfLifeline && targetElement == self ? self : tgtFinder.findMostSpecificEvent(newRange);
            if (finalTgt == null) {
                invalidCommand = true;
            } else {
                Range finalTgtRange = tgtLifeline.get() == selfLifeline && targetElement == self ? thisFinalRange : finalTgt.getVerticalRange();
                smrc.setTarget(finalTgt.getNotationView(), new Rectangle(0, finalTgtRange.getLowerBound(), 0, finalTgtRange.width()));
            }
        } else {
            Range finalTgtRange = RangeHelper.verticalRange((Rectangle)targetElement.getProperLogicalBounds());
            smrc.setTarget(targetElement.getNotationView(), new Rectangle(0, finalTgtRange.getLowerBound(), 0, finalTgtRange.width()));
        }
        if (invalidCommand) {
            cc.compose((IUndoableOperation)UnexecutableCommand.INSTANCE);
        } else {
            cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)smrc));
        }
    }

    private boolean hasBothEndMoving(Message smep) {
        Set<AbstractNodeEvent> movingExecutionEditPart = this.getMovingExecutions();
        return movingExecutionEditPart.contains(smep.getSourceElement()) && movingExecutionEditPart.contains(smep.getTargetElement());
    }

    private Set<AbstractNodeEvent> getMovingExecutions() {
        EditPartViewer viewer = this.getHost().getViewer();
        HashSet<AbstractNodeEvent> movingExecutions = new HashSet<AbstractNodeEvent>();
        for (ExecutionEditPart eep : Iterables.filter((Iterable)viewer.getSelectedEditParts(), ExecutionEditPart.class)) {
            AbstractNodeEvent exec = (AbstractNodeEvent)eep.getISequenceEvent();
            movingExecutions.add(exec);
            if (!(exec instanceof Execution)) continue;
            movingExecutions.addAll(((Execution)exec).findLinkedExecutions(true));
        }
        ArrayList subExecutions = new ArrayList();
        for (Execution eep : Iterables.filter(movingExecutions, Execution.class)) {
            subExecutions.addAll(new ISequenceEventQuery((ISequenceEvent)eep).getAllExecutions());
        }
        movingExecutions.addAll(subExecutions);
        return movingExecutions;
    }

    private boolean doNotMoveSourceOfReturnMessageOfReflexiveSyncCall(Execution self, ISequenceEvent ise, RequestQuery rq) {
        return !this.isMovedReflexiveMessage(ise, rq) || !self.equals((Object)((Message)ise).getSourceElement()) || this.getSelection((ISequenceElement)((Message)ise).getSourceElement()) != 0 || this.getSelection((ISequenceElement)ise) != 0;
    }

    private boolean doNotMoveTargetOfStartMessageOfReflexiveSyncCall(Execution self, ISequenceEvent ise, RequestQuery rq) {
        return !this.isMovedReflexiveMessage(ise, rq) || !self.equals((Object)((Message)ise).getTargetElement()) || this.getSelection((ISequenceElement)((Message)ise).getTargetElement()) != 0 || this.getSelection((ISequenceElement)ise) != 0;
    }

    private boolean isMovedReflexiveMessage(ISequenceEvent ise, RequestQuery rq) {
        return rq.isResize() && new ISequenceEventQuery(ise).isReflectiveMessage();
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.eraseChangeBoundsFeedback(request);
        super.showChangeBoundsFeedback(request);
        ExecutionEditPart hostPart = (ExecutionEditPart)this.getHost();
        AbstractNodeEvent host = (AbstractNodeEvent)hostPart.getISequenceEvent();
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (hostPart.getSelected() == 2 && requestQuery.isMove()) {
            ISEComplexMoveValidator validator = ISEComplexMoveValidator.getOrCreateValidator(request, requestQuery, (ISequenceEvent)host);
            if (validator != null) {
                SequenceInteractionFeedBackBuilder feedBackBuilder = new SequenceInteractionFeedBackBuilder(validator, this.getFeedbackLayer(), (IGraphicalEditPart)hostPart);
                for (Figure fig : feedBackBuilder.buildFeedBack()) {
                    this.addFeedback((IFigure)fig);
                    this.guides.add(fig);
                }
            }
        } else if (requestQuery.isResize()) {
            AbstractNodeEventResizeSelectionValidator validator = AbstractNodeEventResizeSelectionValidator.getOrCreateValidator(request, host);
            validator.validate();
            this.showResizeFeedBack(request);
            this.feedBack(validator);
        }
    }

    protected void feedBack(AbstractNodeEventResizeSelectionValidator validator) {
        Rectangle bounds;
        IFigure feedbackLayer = this.getFeedbackLayer();
        for (Integer conflict : validator.getInvalidPositions()) {
            Point conflictingPosition = new Point(0, conflict.intValue());
            conflictingPosition.performScale(GraphicalHelper.getZoom((EditPart)this.getHost()));
            bounds = feedbackLayer.getBounds().getCopy();
            bounds.y = conflictingPosition.y;
            bounds.height = 1;
            HorizontalGuide conflictGuide = new HorizontalGuide(ColorConstants.red, conflictingPosition.y);
            conflictGuide.setBounds(bounds);
            this.addFeedback((IFigure)conflictGuide);
            this.guides.add((Figure)conflictGuide);
        }
        Range expansionZone = validator.getExpansionZone();
        if (expansionZone != null && !expansionZone.isEmpty() && expansionZone.width() != 0) {
            Rectangle screenRange = new Rectangle(0, expansionZone.getLowerBound(), 0, expansionZone.width());
            screenRange.performScale(GraphicalHelper.getZoom((EditPart)this.getHost()));
            Range expand = RangeHelper.verticalRange((Rectangle)screenRange);
            bounds = feedbackLayer.getBounds().getCopy();
            bounds.height = expand.width();
            bounds.y = expand.getLowerBound();
            RangeGuide expansion = new RangeGuide(validator.isValid() ? ColorConstants.blue : ColorConstants.red, expand, true);
            expansion.setBounds(bounds);
            this.addFeedback((IFigure)expansion);
            this.guides.add(expansion);
        }
    }

    protected void showResizeFeedBack(ChangeBoundsRequest request) {
        Rectangle oldBounds = this.getHostAbsoluteBounds().getCopy();
        Rectangle newBounds = request.getTransformedRectangle(oldBounds).getCopy();
        Rectangle execBounds = newBounds.getCopy();
        FreeformViewport viewport = FigureUtilities.getFreeformViewport((IFigure)this.getHostFigure());
        if (viewport != null) {
            oldBounds.translate(viewport.getViewLocation());
            newBounds.translate(viewport.getViewLocation());
        }
        if (this.getHost() instanceof ExecutionEditPart && newBounds.height > 0) {
            ISequenceEvent iSequenceEvent = ((ISequenceEventEditPart)this.getHost()).getISequenceEvent();
            GraphicalHelper.screen2logical((Rectangle)newBounds, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            GraphicalHelper.screen2logical((Rectangle)oldBounds, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            Range oldRange = RangeHelper.verticalRange((Rectangle)oldBounds);
            Range execRange = RangeHelper.verticalRange((Rectangle)newBounds);
            Range fullFinalRange = RangeHelper.verticalRange((Rectangle)newBounds);
            List delimitingMessages = EventEndHelper.getCompoundEvents((ISequenceEvent)iSequenceEvent);
            if (delimitingMessages.size() > 0) {
                ISequenceEvent callMessage = (ISequenceEvent)delimitingMessages.get(0);
                Range callMsgRange = callMessage.getVerticalRange();
                fullFinalRange = request.isConstrainedMove() ? new Range(oldRange.getLowerBound() - callMsgRange.width(), fullFinalRange.getUpperBound()) : new Range(fullFinalRange.getLowerBound() - callMsgRange.width(), fullFinalRange.getUpperBound());
            }
            if (delimitingMessages.size() > 1) {
                ISequenceEvent returnMessage = (ISequenceEvent)delimitingMessages.get(1);
                Range returnMsgRange = returnMessage.getVerticalRange();
                fullFinalRange = request.isConstrainedResize() ? new Range(fullFinalRange.getLowerBound(), oldRange.getUpperBound() + returnMsgRange.width()) : new Range(fullFinalRange.getLowerBound(), fullFinalRange.getUpperBound() + returnMsgRange.width());
            }
            newBounds = new Rectangle(0, fullFinalRange.getLowerBound(), 0, fullFinalRange.width());
            execBounds = new Rectangle(0, execRange.getLowerBound(), 0, execRange.width());
            if (iSequenceEvent.isLogicallyInstantaneous() && delimitingMessages.isEmpty()) {
                execBounds.y = execBounds.getCenter().y;
                execBounds.height = 1;
                newBounds = execBounds.getCopy();
            }
            GraphicalHelper.logical2screen((Rectangle)newBounds, (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            GraphicalHelper.logical2screen((Rectangle)execBounds, (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()));
        }
        Point topLocation = new Point(1, newBounds.getTop().y);
        Point bottomLocation = new Point(1, newBounds.getBottom().y);
        Rectangle bounds = this.getFeedbackLayer().getBounds().getCopy();
        execBounds.height = Math.max(execBounds.height, 0);
        RangeGuide execGuide = new RangeGuide(EXECUTION_FEEDBACK_COLOR, RangeHelper.verticalRange((Rectangle)execBounds), false);
        bounds.height = execBounds.height + 1;
        bounds.y = execBounds.y;
        execGuide.setBounds(bounds);
        this.addFeedback((IFigure)execGuide);
        this.guides.add(execGuide);
        if (execBounds.y != topLocation.y) {
            HorizontalGuide topGuide = new HorizontalGuide(EXECUTION_FEEDBACK_COLOR, topLocation.y);
            bounds.height = 1;
            bounds.y = topLocation.y;
            topGuide.setBounds(bounds);
            this.addFeedback((IFigure)topGuide);
            this.guides.add((Figure)topGuide);
        }
        if (execBounds.bottom() != bottomLocation.y) {
            bounds = this.getFeedbackLayer().getBounds().getCopy();
            HorizontalGuide bottomGuide = new HorizontalGuide(EXECUTION_FEEDBACK_COLOR, bottomLocation.y);
            bounds.height = 1;
            bounds.y = bottomLocation.y;
            bottomGuide.setBounds(bounds);
            this.addFeedback((IFigure)bottomGuide);
            this.guides.add((Figure)bottomGuide);
        }
    }

    private Rectangle getHostAbsoluteBounds() {
        Rectangle bounds = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().getParent().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    private void removeFeedBackOnGuides() {
        if (this.guides != null && !this.guides.isEmpty()) {
            for (Figure hGuide : this.guides) {
                this.removeFeedback((IFigure)hGuide);
            }
            this.guides.clear();
        }
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.removeFeedBackOnGuides();
        super.eraseChangeBoundsFeedback(request);
    }

    protected void cancelHorizontalDelta(ChangeBoundsRequest request) {
        Dimension sizeDelta;
        if (request == null) {
            return;
        }
        Point moveDelta = request.getMoveDelta();
        if (moveDelta != null) {
            request.setMoveDelta(new Point(0, moveDelta.y));
        }
        if ((sizeDelta = request.getSizeDelta()) != null) {
            request.setSizeDelta(new Dimension(0, sizeDelta.height));
        }
    }
}

