/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceDiagramQuery;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.DefaultMessageCreationValidator;
import org.eclipse.sirius.ext.base.Option;

public class CreateMessageCreationValidator
extends DefaultMessageCreationValidator {
    @Override
    public boolean isValid(CreateConnectionRequest request) {
        boolean valid = super.isValid(request);
        valid = valid && !this.sequenceElementSource.equals(this.sequenceElementTarget);
        valid = valid && !((Lifeline)this.sequenceElementTarget.getLifeline().get()).isExplicitlyCreated();
        valid = valid && this.checkNotEventAtLowerTimeInSameLifeline();
        return valid;
    }

    private boolean checkNotEventAtLowerTimeInSameLifeline() {
        boolean valid = true;
        SequenceDiagram sequenceDiagram = this.sequenceElementSource.getDiagram();
        SequenceDiagramQuery sequenceDiagramQuery = new SequenceDiagramQuery(sequenceDiagram);
        for (ISequenceEvent sequenceEvent : Iterables.filter((Iterable)sequenceDiagramQuery.getAllSequenceEventsLowerThan(this.firstClickLocation.y), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Lifeline.class)))) {
            if (!this.isSequenceEventOfLifeline(sequenceEvent, (Option<Lifeline>)this.sequenceElementTarget.getLifeline()) && !this.isMessageTargeting(sequenceEvent, (Option<Lifeline>)this.sequenceElementTarget.getLifeline()) && !this.isCreateMessageFor(sequenceEvent, ((Lifeline)this.sequenceElementTarget.getLifeline().get()).getInstanceRole())) continue;
            valid = false;
            break;
        }
        return valid;
    }
}

