/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public abstract class ExtendBinaryTransitiveClosure
implements ISearchOperation,
IPatternMatcherOperation {
    private final int seedPosition;
    private final int targetPosition;
    private final CallInformation information;
    private final boolean reflexive;

    protected ExtendBinaryTransitiveClosure(CallInformation information, int seedPosition, int targetPosition, boolean reflexive) {
        this.information = information;
        this.seedPosition = seedPosition;
        this.targetPosition = targetPosition;
        this.reflexive = reflexive;
    }

    protected abstract Object[] calculateCallFrame(Object var1);

    protected abstract Object getTarget(Tuple var1);

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.targetPosition);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        String c = this.information.toString(variableMapping);
        int p = c.indexOf(40);
        return "extend    find " + c.substring(0, p) + "+" + c.substring(p);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.seedPosition, this.targetPosition);
    }

    @Override
    public CallInformation getCallInformation() {
        return this.information;
    }

    public static class Backward
    extends ExtendBinaryTransitiveClosure {
        private Object[] seedFrame = new Object[2];

        public Backward(CallInformation information, int sourcePosition, int targetPosition, boolean reflexive) {
            super(information, targetPosition, sourcePosition, reflexive);
        }

        @Override
        protected Object[] calculateCallFrame(Object seed) {
            this.seedFrame[0] = null;
            this.seedFrame[1] = seed;
            return this.seedFrame;
        }

        @Override
        protected Object getTarget(Tuple frame) {
            return frame.get(0);
        }
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Object> {
        public Executor(int position) {
            super(position);
        }

        @Override
        public Iterator<?> getIterator(MatchingFrame frame, ISearchContext context) {
            IQueryResultProvider matcher = context.getMatcher(ExtendBinaryTransitiveClosure.this.information.getCallWithAdornment());
            LinkedList<Object> seedsToEvaluate = new LinkedList<Object>();
            Object seedValue = frame.get(ExtendBinaryTransitiveClosure.this.seedPosition);
            seedsToEvaluate.add(seedValue);
            HashSet seedsEvaluated = new HashSet();
            HashSet<Object> targetsFound = new HashSet<Object>();
            if (ExtendBinaryTransitiveClosure.this.reflexive) {
                targetsFound.add(seedValue);
            }
            while (!seedsToEvaluate.isEmpty()) {
                Object currentValue = seedsToEvaluate.poll();
                seedsEvaluated.add(currentValue);
                Object[] mappedFrame = ExtendBinaryTransitiveClosure.this.calculateCallFrame(currentValue);
                matcher.getAllMatches(mappedFrame).forEach(match -> {
                    Object foundTarget = ExtendBinaryTransitiveClosure.this.getTarget((Tuple)match);
                    targetsFound.add(foundTarget);
                    if (!seedsEvaluated.contains(foundTarget)) {
                        seedsToEvaluate.add(foundTarget);
                    }
                });
            }
            return targetsFound.iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return ExtendBinaryTransitiveClosure.this;
        }
    }

    public static class Forward
    extends ExtendBinaryTransitiveClosure {
        private Object[] seedFrame = new Object[2];

        public Forward(CallInformation information, int sourcePosition, int targetPosition, boolean reflexive) {
            super(information, sourcePosition, targetPosition, reflexive);
        }

        @Override
        protected Object[] calculateCallFrame(Object seed) {
            this.seedFrame[0] = seed;
            this.seedFrame[1] = null;
            return this.seedFrame;
        }

        @Override
        protected Object getTarget(Tuple frame) {
            return frame.get(1);
        }
    }
}

