/**
 * Copyright (c) 2010-2017, Grill Balázs, IncQueryLabs
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Grill Balázs - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core.internal;

import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.testing.core.PatternBasedMatchSetModelProvider;
import org.eclipse.viatra.query.testing.core.api.IPatternExecutionAnalyzer;
import org.eclipse.viatra.query.testing.core.api.JavaObjectAccess;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * This implementation adds support to call analyzers
 * 
 * @since 1.6
 */
@SuppressWarnings("all")
public class AnalyzedPatternBasedMatchSetModelProvider extends PatternBasedMatchSetModelProvider {
  private final Iterable<? extends IPatternExecutionAnalyzer> analyzers;
  
  public AnalyzedPatternBasedMatchSetModelProvider(final QueryEvaluationHint hint, final Map<String, JavaObjectAccess> accessmap, final Iterable<? extends IPatternExecutionAnalyzer> analyzers) {
    super(hint, accessmap);
    this.analyzers = analyzers;
  }
  
  @Override
  protected ViatraQueryEngineOptions getEngineOptions() {
    ViatraQueryEngineOptions _xblockexpression = null;
    {
      final ViatraQueryEngineOptions superOptions = super.getEngineOptions();
      final Function2<QueryEvaluationHint, IPatternExecutionAnalyzer, QueryEvaluationHint> _function = (QueryEvaluationHint r, IPatternExecutionAnalyzer t) -> {
        return t.configure(r);
      };
      final QueryEvaluationHint updatedHint = IterableExtensions.fold(this.analyzers, superOptions.getEngineDefaultHints(), _function);
      _xblockexpression = ViatraQueryEngineOptions.copyOptions(superOptions).withDefaultHint(updatedHint).build();
    }
    return _xblockexpression;
  }
  
  @Override
  protected <Match extends IPatternMatch> ViatraQueryMatcher<Match> createMatcher(final EMFScope scope, final IQuerySpecification<? extends ViatraQueryMatcher<Match>> querySpecification, final QueryEvaluationHint hint) {
    final ViatraQueryMatcher<Match> matcher = super.<Match>createMatcher(scope, querySpecification, hint);
    final Consumer<IPatternExecutionAnalyzer> _function = (IPatternExecutionAnalyzer it) -> {
      it.processMatcher(matcher);
    };
    this.analyzers.forEach(_function);
    return matcher;
  }
}
