/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.wizards.actions.OpenTypeWizardAction;

public class NewDesignerTypeDropDownAction
extends Action
implements IWorkbenchWindowPulldownDelegate,
IActionDelegate2 {
    private Menu m_menu;

    public void dispose() {
        if (this.m_menu != null) {
            this.m_menu.dispose();
            this.m_menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        this.m_menu = null;
        if (this.m_menu == null) {
            this.m_menu = new Menu(parent);
            NewDesignerTypeDropDownAction.createCategoryItems(this.m_menu, "org.eclipse.wb");
            NewDesignerTypeDropDownAction.disposeExtraSeparators(this.m_menu);
        }
        return this.m_menu;
    }

    private static void createCategoryItems(Menu parent, String parentCategoryId) {
        for (IConfigurationElement wizard : NewDesignerTypeDropDownAction.getWizardWizards(parentCategoryId)) {
            if (!NewDesignerTypeDropDownAction.isWizardVisibleInMenu(wizard)) continue;
            OpenTypeWizardAction action = new OpenTypeWizardAction(wizard);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }
        for (IConfigurationElement category : NewDesignerTypeDropDownAction.getWizardCategories(parentCategoryId)) {
            Menu categoryMenu;
            boolean isInline = "true".equals(category.getAttribute("wbp-menu-inline"));
            if (isInline) {
                NewDesignerTypeDropDownAction.addSeparator(parent);
                categoryMenu = parent;
            } else {
                MenuItem categoryItem = new MenuItem(parent, 64);
                categoryItem.setText(NewDesignerTypeDropDownAction.getCategoryName(category));
                categoryMenu = new Menu(categoryItem);
                categoryItem.setMenu(categoryMenu);
            }
            NewDesignerTypeDropDownAction.createCategoryItems(categoryMenu, String.valueOf(parentCategoryId) + "/" + category.getAttribute("id"));
            if (!isInline) continue;
            NewDesignerTypeDropDownAction.addSeparator(parent);
        }
    }

    private static void addSeparator(Menu parent) {
        new MenuItem(parent, 2);
    }

    private static void disposeExtraSeparators(Menu menu) {
        MenuItem lastItem;
        MenuItem firstItem;
        if (menu == null) {
            return;
        }
        boolean separator = false;
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (NewDesignerTypeDropDownAction.isSeparator(item)) {
                if (separator) {
                    item.dispose();
                }
                separator = true;
            } else {
                separator = false;
                NewDesignerTypeDropDownAction.disposeExtraSeparators(item.getMenu());
            }
            ++n2;
        }
        MenuItem[] items = menu.getItems();
        if (items.length != 0 && NewDesignerTypeDropDownAction.isSeparator(firstItem = items[0])) {
            firstItem.dispose();
        }
        if ((items = menu.getItems()).length != 0 && NewDesignerTypeDropDownAction.isSeparator(lastItem = items[items.length - 1])) {
            lastItem.dispose();
        }
    }

    private static boolean isSeparator(MenuItem item) {
        return (item.getStyle() & 2) != 0;
    }

    private static String getCategoryName(IConfigurationElement category) {
        String attribute = category.getAttribute("wbp-menu-name");
        if (attribute != null) {
            return attribute;
        }
        return category.getAttribute("name");
    }

    private static boolean isWizardVisibleInMenu(IConfigurationElement wizard) {
        String visible = wizard.getAttribute("wbp-menu-visible");
        return visible != null ? "true".equals(visible) : true;
    }

    private static Iterable<IConfigurationElement> getWizardWizards(String parentCategoryId) {
        return NewDesignerTypeDropDownAction.getWizardElements("wizard", "category", parentCategoryId);
    }

    private static Iterable<IConfigurationElement> getWizardCategories(String parentCategoryId) {
        return NewDesignerTypeDropDownAction.getWizardElements("category", "parentCategory", parentCategoryId);
    }

    private static Iterable<IConfigurationElement> getWizardElements(String elementName, final String attributeName, final String parentCategoryId) {
        List allCategories = ExternalFactoriesHelper.getElements((String)"org.eclipse.ui.newWizards", (String)elementName);
        return Iterables.filter((Iterable)allCategories, (Predicate)new Predicate<IConfigurationElement>(){

            public boolean apply(IConfigurationElement t) {
                return parentCategoryId.equals(t.getAttribute(attributeName));
            }
        });
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        ToolItem toolItem;
        Listener[] listeners;
        Widget widget = event.widget;
        if (widget instanceof ToolItem && (listeners = (toolItem = (ToolItem)widget).getListeners(13)).length > 0) {
            Listener listener = listeners[0];
            Event e = new Event();
            e.type = 13;
            e.widget = toolItem;
            e.detail = 4;
            e.x = toolItem.getBounds().x;
            e.y = toolItem.getBounds().height;
            listener.handleEvent(e);
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

