/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model.ui;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.DimensionsDialog;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.RowEditDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RowsDialog
extends DimensionsDialog<MigRowInfo> {
    public RowsDialog(Shell parentShell, MigLayoutInfo layout) {
        super(parentShell, layout, layout.getRows());
    }

    @Override
    protected String getDialogTitle() {
        return ModelMessages.RowsDialog_dialogTitle;
    }

    @Override
    protected String getDialogMessage() {
        return ModelMessages.RowsDialog_dialogMessage;
    }

    @Override
    protected String getViewerTitle() {
        return ModelMessages.RowsDialog_viewerTitle;
    }

    @Override
    protected void moveDimensionsUp(Iterable<MigRowInfo> dimensions) throws Exception {
        for (MigRowInfo row : dimensions) {
            int index = row.getIndex();
            this.m_layout.moveRow(index, index - 1);
        }
    }

    @Override
    protected void moveDimensionsDown(Iterable<MigRowInfo> dimensions) throws Exception {
        for (MigRowInfo row : dimensions) {
            int index = row.getIndex();
            this.m_layout.moveRow(index, index + 2);
        }
    }

    @Override
    protected boolean editSelectedDimension(MigRowInfo row) {
        return new RowEditDialog(this.getShell(), this.m_layout, row).open() == 0;
    }

    @Override
    protected MigRowInfo createNewDimension(int targetIndex) throws Exception {
        MigRowInfo row = new MigRowInfo(this.m_layout);
        this.m_layout.insertRow(targetIndex);
        return row;
    }
}

