/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.bindings;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfoVisitor;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IASTObjectInfo2;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.BindingContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.LabelUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.SeparatorUiContentProvider;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JListBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.ObjectPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.BindingNameUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ChooseClassAndPropertiesConfiguration;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ConverterUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.DetailBindingUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ValidatorUiContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DetailBindingInfo
extends BindingInfo {
    private final JListBindingInfo m_binding;
    private PropertyInfo m_detailProperty;

    public DetailBindingInfo(ObserveInfo target, ObserveInfo targetProperty, PropertyInfo targetAstProperty, ObserveInfo model, ObserveInfo modelProperty, PropertyInfo modelAstProperty, JListBindingInfo binding) {
        super(target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty);
        this.m_binding = binding;
    }

    @Override
    public IGenericType getModelPropertyType() {
        if (this.m_detailProperty != null) {
            return this.m_detailProperty.getValueType();
        }
        return super.getModelPropertyType();
    }

    @Override
    public IGenericType getTargetPropertyType() {
        return ClassGenericType.OBJECT_CLASS;
    }

    public PropertyInfo getDetailProperty() {
        return this.m_detailProperty;
    }

    public void setDetailProperty(PropertyInfo detailProperty) {
        Assert.isNotNull((Object)((Object)detailProperty));
        this.m_detailProperty = detailProperty;
    }

    public JListBindingInfo getJListBinding() {
        return this.m_binding;
    }

    @Override
    public boolean delete(List<BindingInfo> bindings) throws Exception {
        this.m_detailProperty = new ObjectPropertyInfo(this.m_binding.getInputElementType());
        this.m_converter = null;
        this.m_validator = null;
        return false;
    }

    public boolean isVirtual() {
        return this.m_converter == null && this.m_validator == null && this.m_detailProperty instanceof ObjectPropertyInfo;
    }

    public String getVariableIdentifier() throws Exception {
        if (this.isVirtual()) {
            return String.valueOf(this.m_binding.getVariableIdentifier()) + ".getDetailBinding()";
        }
        String variable = super.getVariableIdentifier();
        if (variable == null) {
            return String.valueOf(this.m_binding.getVariableIdentifier()) + ".setDetailBinding()";
        }
        return variable;
    }

    @Override
    public void createContentProviders(List<BindingInfo> bindings, List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        listener.setTitle(Messages.DetailBindingInfo_listenerTitle);
        listener.setMessage(Messages.DetailBindingInfo_listenerMessage);
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.DetailBindingInfo_component, this.m_target.getPresentation().getTextForBinding()));
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.DetailBindingInfo_model, this.getModelPresentationText(false)));
        providers.add((IUiContentProvider)new DetailBindingUiContentProvider(DetailBindingInfo.createConfiguration(), this));
        providers.add((IUiContentProvider)new SeparatorUiContentProvider());
        providers.add((IUiContentProvider)new ConverterUiContentProvider(this.createConverterConfiguration(), this));
        providers.add((IUiContentProvider)new ValidatorUiContentProvider(this.createValidatorConfiguration(), this));
        providers.add((IUiContentProvider)new BindingNameUiContentProvider(this));
        providers.add((IUiContentProvider)new BindingContentProvider((IASTObjectInfo2)this, provider.getJavaInfoRoot()));
    }

    private static ChooseClassAndPropertiesConfiguration createConfiguration() {
        ChooseClassAndPropertiesConfiguration configuration = new ChooseClassAndPropertiesConfiguration();
        configuration.setDialogFieldLabel(Messages.DetailBindingInfo_chooseLabel);
        configuration.setValueScope("beans");
        configuration.setChooseInterfaces(true);
        configuration.setEmptyClassErrorMessage(Messages.DetailBindingInfo_chooseError);
        configuration.setErrorMessagePrefix(Messages.DetailBindingInfo_chooseErrorPrefix);
        configuration.setPropertiesLabel(Messages.DetailBindingInfo_choosePropertiesLabel);
        configuration.setPropertiesErrorMessage(Messages.DetailBindingInfo_choosePropertiesError);
        return configuration;
    }

    public boolean addSourceCodeSeparator() {
        return false;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    public void addSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
    }

    public void addDetailSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        boolean localVariable;
        if (this.isVirtual()) {
            return;
        }
        generationSupport.addSourceCode((AstObjectInfo)this.m_detailProperty, lines);
        boolean bl = localVariable = !this.isField();
        if (localVariable && this.m_converter == null && this.m_validator == null) {
            this.setVariableIdentifier(null);
            lines.add(String.valueOf(this.m_binding.getVariableIdentifier()) + ".setDetailBinding(" + this.m_detailProperty.getVariableIdentifier() + this.getCreateMethodHeaderEnd() + ";");
        } else {
            if (super.getVariableIdentifier() == null) {
                this.setVariableIdentifier(generationSupport.generateLocalName(new String[]{"JListDetail"}));
            }
            if (localVariable) {
                lines.add(String.valueOf(this.m_binding.getTypeSourceCode(generationSupport)) + ".DetailBinding ");
            }
            lines.add(String.valueOf(super.getVariableIdentifier()) + " = " + this.m_binding.getVariableIdentifier() + ".setDetailBinding(" + this.m_detailProperty.getVariableIdentifier() + this.getCreateMethodHeaderEnd() + ";");
            this.addFinishSourceCode(lines, generationSupport, false);
        }
    }

    public void setVariableIdentifier(JavaInfo javaInfoRoot, String variable, boolean field) {
        boolean useGenerics = CoreUtils.useGenerics((IJavaProject)javaInfoRoot.getEditor().getJavaProject());
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(useGenerics);
        String type = String.valueOf(this.m_binding.getTypeSourceCode(generationSupport)) + ".DetailBinding";
        this.setVariableIdentifier(javaInfoRoot, type, variable, field);
    }

    @Override
    public String getTargetPresentationText(boolean full) throws Exception {
        return String.valueOf(this.m_target.getPresentation().getTextForBinding()) + ".detail";
    }

    @Override
    public String getModelPresentationText(boolean full) throws Exception {
        if (this.m_detailProperty != null) {
            return this.m_detailProperty.getPresentationText(this.m_model, this.m_modelProperty, full);
        }
        return super.getModelPresentationText(full);
    }

    @Override
    public void accept(AstObjectInfoVisitor visitor) throws Exception {
        super.accept(visitor);
        if (this.m_detailProperty != null) {
            this.m_detailProperty.accept(visitor);
        }
    }
}

