/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.bindings;

import com.google.common.collect.Lists;
import java.util.List;
import javax.swing.JTable;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.parser.IModelSupport;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.TabContainerConfiguration;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.bindings.AutoBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ColumnBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ColumnBindingModelSupport;
import org.eclipse.wb.internal.swing.databinding.model.bindings.UpdateStrategyInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.ObjectPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.EditableUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.IEditableProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.JTableColumnContainerUiContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JTableBindingInfo
extends AutoBindingInfo
implements IEditableProvider {
    private static final String SET_EDITABLE = "org.jdesktop.swingbinding.JTableBinding.setEditable(boolean)";
    private static final String ADD_COLUMN_BINDING_1 = "org.jdesktop.swingbinding.JTableBinding.addColumnBinding(org.jdesktop.beansbinding.Property)";
    private static final String ADD_COLUMN_BINDING_2 = "org.jdesktop.swingbinding.JTableBinding.addColumnBinding(org.jdesktop.beansbinding.Property,java.lang.String)";
    private static final String ADD_COLUMN_BINDING_3 = "org.jdesktop.swingbinding.JTableBinding.addColumnBinding(int,org.jdesktop.beansbinding.Property)";
    private static final String ADD_COLUMN_BINDING_4 = "org.jdesktop.swingbinding.JTableBinding.addColumnBinding(int,org.jdesktop.beansbinding.Property,java.lang.String)";
    private static final IGenericType JTABLE_CLASS = new ClassGenericType(JTable.class, null, null);
    private boolean m_editable = true;
    private List<ColumnBindingInfo> m_columns = Lists.newArrayList();

    public JTableBindingInfo(UpdateStrategyInfo strategyInfo, ObserveInfo target, ObserveInfo targetProperty, PropertyInfo targetAstProperty, ObserveInfo model, ObserveInfo modelProperty, PropertyInfo modelAstProperty) {
        super(strategyInfo, target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty);
    }

    @Override
    public boolean isEditable() {
        return this.m_editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public List<ColumnBindingInfo> getColumns() {
        return this.m_columns;
    }

    public void setColumns(List<ColumnBindingInfo> columns, List<BindingInfo> bindings) throws Exception {
        int index = bindings.indexOf(this);
        if (index == -1) {
            this.m_columns = columns;
        } else {
            bindings.removeAll(this.m_columns);
            for (ColumnBindingInfo column : this.m_columns) {
                column.postDelete();
            }
            this.m_columns = columns;
            if (!this.m_columns.isEmpty()) {
                bindings.addAll(index + 1, this.m_columns);
            }
        }
        for (ColumnBindingInfo column : this.m_columns) {
            column.create(bindings);
        }
    }

    public IGenericType getInputElementType() {
        if (JTableBindingInfo.isJTableBinding(this.m_target, this.m_targetProperty)) {
            return this.m_modelProperty.getObjectType().getSubType(0);
        }
        return this.m_targetProperty.getObjectType().getSubType(0);
    }

    public String getTypeSourceCode(CodeGenerationSupport generationSupport) {
        IGenericType type1;
        IGenericType type0;
        if (!generationSupport.useGenerics()) {
            return "org.jdesktop.swingbinding.JTableBinding";
        }
        if (JTableBindingInfo.isJTableBinding(this.m_target, this.m_targetProperty)) {
            if (this.m_modelAstProperty instanceof ObjectPropertyInfo) {
                type0 = this.m_model.getObjectType().getSubType(0);
                type1 = this.m_model.getObjectType();
            } else {
                type0 = this.m_modelProperty.getObjectType().getSubType(0);
                type1 = this.m_model.getObjectType();
            }
        } else if (this.m_targetAstProperty instanceof ObjectPropertyInfo) {
            type0 = this.m_target.getObjectType().getSubType(0);
            type1 = this.m_target.getObjectType();
        } else {
            type0 = this.m_targetProperty.getObjectType().getSubType(0);
            type1 = this.m_target.getObjectType();
        }
        return "org.jdesktop.swingbinding.JTableBinding" + GenericUtils.getTypesSource(type0, type1, JTABLE_CLASS);
    }

    @Override
    public AstObjectInfo parseExpression(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver, IDatabindingsProvider provider) throws Exception {
        if (ADD_COLUMN_BINDING_1.equals(signature) || ADD_COLUMN_BINDING_2.equals(signature)) {
            this.createColumnBinding(editor, signature, invocation, arguments, -1, arguments[0], resolver);
            return null;
        }
        if (ADD_COLUMN_BINDING_3.equals(signature) || ADD_COLUMN_BINDING_4.equals(signature)) {
            int column = (Integer)CoreUtils.evaluate(Integer.class, (AstEditor)editor, (Expression)arguments[0]);
            this.createColumnBinding(editor, signature, invocation, arguments, column, arguments[1], resolver);
            return null;
        }
        if (SET_EDITABLE.equals(signature)) {
            this.m_editable = (Boolean)CoreUtils.evaluate(Boolean.class, (AstEditor)editor, (Expression)arguments[0]);
            return null;
        }
        return super.parseExpression(editor, signature, invocation, arguments, resolver, provider);
    }

    private void createColumnBinding(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, int column, Expression propertyExpression, IModelResolver resolver) throws Exception {
        ColumnBindingInfo binding = this.createColumnBinding(column);
        binding.setDetailProperty((PropertyInfo)resolver.getModel(propertyExpression));
        if (signature.endsWith(",java.lang.String)")) {
            String name = (String)CoreUtils.evaluate(String.class, (AstEditor)editor, (Expression)arguments[arguments.length - 1]);
            binding.setName(StringEscapeUtils.unescapeJava((String)name));
        }
        this.m_columns.add(binding);
        resolver.addModelSupport((IModelSupport)new ColumnBindingModelSupport(binding, invocation));
    }

    private ColumnBindingInfo createColumnBinding(int column) {
        ColumnBindingInfo binding = JTableBindingInfo.isJTableBinding(this.m_target, this.m_targetProperty) ? new ColumnBindingInfo(this.m_target, this.m_targetProperty, this.m_targetAstProperty, this.m_model, this.m_modelProperty, this.m_modelAstProperty, this) : new ColumnBindingInfo(this.m_model, this.m_modelProperty, this.m_modelAstProperty, this.m_target, this.m_targetProperty, this.m_targetAstProperty, this);
        binding.setColumn(column);
        return binding;
    }

    public ColumnBindingInfo createNewColumnBinding(int column) {
        ColumnBindingInfo binding = this.createColumnBinding(column);
        binding.setDetailProperty(new ObjectPropertyInfo(this.getInputElementType()));
        binding.setColumnName(Messages.JTableBindingInfo_newColumn);
        return binding;
    }

    @Override
    public void create(List<BindingInfo> bindings) throws Exception {
        super.create(bindings);
        if (!this.m_columns.isEmpty()) {
            int index = bindings.indexOf(this) + 1;
            bindings.addAll(index, this.m_columns);
        }
        this.preCreate();
    }

    @Override
    public boolean delete(List<BindingInfo> bindings) throws Exception {
        for (ColumnBindingInfo column : this.m_columns) {
            column.postDelete();
        }
        bindings.removeAll(this.m_columns);
        return true;
    }

    @Override
    public void preCreate() throws Exception {
        BeanPropertyObserveInfo selectedElement = this.getSelectedElementProperty();
        selectedElement.setHostedType(this.getInputElementType());
    }

    @Override
    public void postDelete() throws Exception {
        super.postDelete();
        BeanPropertyObserveInfo selectedElement = this.getSelectedElementProperty();
        selectedElement.setHostedType(ClassGenericType.OBJECT_CLASS);
    }

    @Override
    public void move(List<BindingInfo> bindings) {
        if (!this.m_columns.isEmpty()) {
            bindings.removeAll(this.m_columns);
            int index = bindings.indexOf(this) + 1;
            bindings.addAll(index, this.m_columns);
        }
    }

    private BeanPropertyObserveInfo getSelectedElementProperty() throws Exception {
        return BeanSupport.getProperty(this, JTableBindingInfo.isJTableBinding(this.m_target, this.m_targetProperty), "selectedElement");
    }

    @Override
    public void createContentProviders(List<BindingInfo> bindings, List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        super.createContentProviders(bindings, providers, listener, provider);
        providers.add((IUiContentProvider)new EditableUiContentProvider(this));
        providers.add((IUiContentProvider)new JTableColumnContainerUiContentProvider(this.createTabConfiguration(), this, bindings, provider));
    }

    private TabContainerConfiguration createTabConfiguration() {
        TabContainerConfiguration configuration = new TabContainerConfiguration();
        configuration.setUseAddButton(true);
        configuration.setUseRemoveButton(true);
        configuration.setUseUpDownButtons(true);
        configuration.setCreateEmptyPage(Messages.JTableBindingInfo_tabTitle, Messages.JTableBindingInfo_tabMessage);
        return configuration;
    }

    @Override
    public void addSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        if (JTableBindingInfo.isJTableBinding(this.m_target, this.m_targetProperty)) {
            this.addSourceCode(this.m_target, this.m_model, this.m_modelProperty, this.m_modelAstProperty, lines, generationSupport);
        } else {
            this.addSourceCode(this.m_model, this.m_target, this.m_targetProperty, this.m_targetAstProperty, lines, generationSupport);
        }
    }

    private void addSourceCode(ObserveInfo widget, ObserveInfo model, ObserveInfo modelProperty, PropertyInfo modelAstProperty, List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        boolean localVariable;
        if (this.getVariableIdentifier() == null) {
            this.setVariableIdentifier(generationSupport.generateLocalName(new String[]{"JTableBinding"}));
        }
        StringBuffer line = new StringBuffer();
        boolean bl = localVariable = !this.isField();
        if (localVariable) {
            line.append("org.jdesktop.swingbinding.JTableBinding");
        }
        if (modelAstProperty instanceof ObjectPropertyInfo) {
            if (localVariable) {
                if (generationSupport.useGenerics()) {
                    line.append(GenericUtils.getTypesSource(model.getObjectType().getSubType(0), model.getObjectType(), JTABLE_CLASS));
                }
                line.append(" ");
            }
            line.append(this.getVariableIdentifier());
            line.append(" = org.jdesktop.swingbinding.SwingBindings.createJTableBinding(");
            line.append(this.m_strategyInfo.getStrategySourceCode());
            line.append(", ");
            line.append(model.getReference());
            line.append(", ");
            line.append(widget.getReference());
        } else {
            generationSupport.addSourceCode((AstObjectInfo)modelAstProperty, lines);
            if (localVariable) {
                if (generationSupport.useGenerics()) {
                    line.append(GenericUtils.getTypesSource(modelProperty.getObjectType().getSubType(0), model.getObjectType(), JTABLE_CLASS));
                }
                line.append(" ");
            }
            line.append(this.getVariableIdentifier());
            line.append(" = org.jdesktop.swingbinding.SwingBindings.createJTableBinding(");
            line.append(this.m_strategyInfo.getStrategySourceCode());
            line.append(", ");
            line.append(model.getReference());
            line.append(", ");
            line.append(modelAstProperty.getVariableIdentifier());
            line.append(", ");
            line.append(widget.getReference());
        }
        line.append(this.getCreateMethodHeaderEnd());
        line.append(";");
        lines.add(line.toString());
        for (ColumnBindingInfo column : this.m_columns) {
            lines.add("//");
            column.addColumnSourceCode(lines, generationSupport);
        }
        if (!this.m_columns.isEmpty()) {
            lines.add("//");
        }
        if (!this.m_editable) {
            lines.add(String.valueOf(this.getVariableIdentifier()) + ".setEditable(false);");
        }
        this.addFinishSourceCode(lines, generationSupport, true);
    }

    @Override
    public void setVariableIdentifier(JavaInfo javaInfoRoot, String variable, boolean field) {
        String type = "org.jdesktop.swingbinding.JTableBinding";
        if (CoreUtils.useGenerics((IJavaProject)javaInfoRoot.getEditor().getJavaProject())) {
            type = JTableBindingInfo.isJTableBinding(this.m_target, this.m_targetProperty) ? String.valueOf(type) + JTableBindingInfo.getTypeSource(this.m_model, this.m_modelProperty, this.m_modelAstProperty, JTABLE_CLASS) : String.valueOf(type) + JTableBindingInfo.getTypeSource(this.m_target, this.m_targetProperty, this.m_targetAstProperty, JTABLE_CLASS);
        }
        this.setVariableIdentifier(javaInfoRoot, type, variable, field);
    }

    private static boolean isJTableBinding(ObserveInfo observe, ObserveInfo propertyObserve) {
        return observe.getCreationType() == ObserveCreationType.JTableBinding && propertyObserve.getCreationType() == ObserveCreationType.SelfProperty;
    }
}

