/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.providers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.swing.databinding.Activator;
import org.eclipse.wb.internal.swing.databinding.model.bindings.AutoBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ColumnBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.DetailBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JComboBoxBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JListBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JTableBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.VirtualBindingInfo;

public final class BindingLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Image AUTO_BINDING_IMAGE = Activator.getImage("autobinding2.png");
    private static final Image JLIST_BINDING_IMAGE = Activator.getImage("JList.gif");
    private static final Image JLIST_DETAIL_BINDING_IMAGE = Activator.getImage("JListDetail2.png");
    private static final Image JCOMBO_BOX_BINDING_IMAGE = Activator.getImage("JComboBox.gif");
    private static final Image JTABLE_BINDING_IMAGE = Activator.getImage("JTable.gif");
    private static final Image JTABLE_COLUMN_BINDING_IMAGE = Activator.getImage("JTableColumnBinding.png");
    public static final BindingLabelProvider INSTANCE = new BindingLabelProvider();

    public String getColumnText(final Object element, final int column) {
        return (String)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<String>(){

            public String runObject() throws Exception {
                BindingInfo binding = (BindingInfo)((Object)element);
                switch (column) {
                    case 1: {
                        return binding.getTargetPresentationText(true);
                    }
                    case 2: {
                        return binding.getModelPresentationText(true);
                    }
                    case 3: {
                        if (binding instanceof AutoBindingInfo) {
                            AutoBindingInfo autoBinding = (AutoBindingInfo)binding;
                            return autoBinding.getStrategyInfo().getStrategyValue();
                        }
                        return null;
                    }
                    case 4: {
                        String variable = binding.getVariableIdentifier();
                        if (variable == null) break;
                        String name = binding.getName();
                        if (StringUtils.isEmpty((String)name)) {
                            return variable;
                        }
                        return String.valueOf(variable) + " - " + name;
                    }
                }
                return null;
            }
        }, (Object)"<exception, see log>");
    }

    public Image getColumnImage(Object element, int column) {
        if (column == 0) {
            if (element instanceof JListBindingInfo) {
                return JLIST_BINDING_IMAGE;
            }
            if (element instanceof DetailBindingInfo) {
                return JLIST_DETAIL_BINDING_IMAGE;
            }
            if (element instanceof JComboBoxBindingInfo) {
                return JCOMBO_BOX_BINDING_IMAGE;
            }
            if (element instanceof JTableBindingInfo) {
                return JTABLE_BINDING_IMAGE;
            }
            if (element instanceof ColumnBindingInfo) {
                return JTABLE_COLUMN_BINDING_IMAGE;
            }
            if (element instanceof AutoBindingInfo) {
                return AUTO_BINDING_IMAGE;
            }
            if (element instanceof VirtualBindingInfo) {
                VirtualBindingInfo binding = (VirtualBindingInfo)((Object)element);
                switch (binding.getSwingType()) {
                    case JListBinding: {
                        return JLIST_BINDING_IMAGE;
                    }
                    case JTableBinding: {
                        return JTABLE_BINDING_IMAGE;
                    }
                    case JComboBoxBinding: {
                        return JCOMBO_BOX_BINDING_IMAGE;
                    }
                }
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof VirtualBindingInfo) {
            return Display.getCurrent().getSystemColor(16);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

