/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.support.AbstractSupport;
import org.eclipse.wb.internal.swt.support.DisplaySupport;
import org.eclipse.wb.internal.swt.support.ToolkitSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontSupport
extends AbstractSupport {
    public static Class<?> getFontClass() {
        return FontSupport.loadClass("org.eclipse.swt.graphics.Font");
    }

    public static Object createFont(String name, int size, Object style) throws Exception {
        Constructor constructor = ReflectionUtils.getConstructorBySignature(FontSupport.getFontClass(), (String)"<init>(org.eclipse.swt.graphics.Device,java.lang.String,int,int)");
        return constructor.newInstance(null, name, size, style);
    }

    public static Object getCopy(Object font) throws Exception {
        Object fontDataArray = ReflectionUtils.invokeMethod2((Object)font, (String)"getFontData");
        return ReflectionUtils.getConstructorBySignature(FontSupport.getFontClass(), (String)"<init>(org.eclipse.swt.graphics.Device,org.eclipse.swt.graphics.FontData[])").newInstance(DisplaySupport.getCurrent(), fontDataArray);
    }

    public static boolean isDisposed(Object font) throws Exception {
        return (Boolean)ReflectionUtils.invokeMethod((Object)font, (String)"isDisposed()", (Object[])new Object[0]);
    }

    public static void dispose(Object font) throws Exception {
        if (!FontSupport.isDisposed(font)) {
            ReflectionUtils.invokeMethod((Object)font, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    public static String[] getFontFamilies() throws Exception {
        TreeSet families = Sets.newTreeSet();
        Collections.addAll(families, ToolkitSupport.getFontFamilies(false));
        Collections.addAll(families, ToolkitSupport.getFontFamilies(true));
        families.add(FontSupport.getFontName(FontSupport.getFontData(DisplaySupport.getSystemFont())));
        Object[] sortFamilies = families.toArray(new String[families.size()]);
        Arrays.sort(sortFamilies);
        return sortFamilies;
    }

    public static Object getFontData(Object font) throws Exception {
        Object fontData = ReflectionUtils.invokeMethod((Object)font, (String)"getFontData()", (Object[])new Object[0]);
        return Array.get(fontData, 0);
    }

    public static String getFontName(Object fontData) throws Exception {
        return (String)ReflectionUtils.invokeMethod((Object)fontData, (String)"getName()", (Object[])new Object[0]);
    }

    public static int getFontSize(Object fontData) throws Exception {
        return (Integer)ReflectionUtils.invokeMethod((Object)fontData, (String)"getHeight()", (Object[])new Object[0]);
    }

    public static int getFontStyle(Object fontData) throws Exception {
        return (Integer)ReflectionUtils.invokeMethod((Object)fontData, (String)"getStyle()", (Object[])new Object[0]);
    }

    public static String getFontStyleSource(Object fontData) throws Exception {
        boolean italic;
        int style = FontSupport.getFontStyle(fontData);
        boolean bold = (style & 1) != 0;
        boolean bl = italic = (style & 2) != 0;
        if (bold && italic) {
            return "org.eclipse.swt.SWT.BOLD | org.eclipse.swt.SWT.ITALIC";
        }
        if (bold) {
            return "org.eclipse.swt.SWT.BOLD";
        }
        if (italic) {
            return "org.eclipse.swt.SWT.ITALIC";
        }
        return "org.eclipse.swt.SWT.NORMAL";
    }

    public static String getFontStyleText(Object fontData) throws Exception {
        boolean italic;
        int style = FontSupport.getFontStyle(fontData);
        boolean bold = (style & 1) != 0;
        boolean bl = italic = (style & 2) != 0;
        if (bold && italic) {
            return "BOLD ITALIC";
        }
        if (bold) {
            return "BOLD";
        }
        if (italic) {
            return "ITALIC";
        }
        return "";
    }
}

