/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CallType implements Enumerator
{
    CALLSERVICE(0, "CALLSERVICE", "CALLSERVICE"),
    CALLORAPPLY(1, "CALLORAPPLY", "CALLORAPPLY"),
    COLLECTIONCALL(2, "COLLECTIONCALL", "COLLECTIONCALL");

    public static final int CALLSERVICE_VALUE = 0;
    public static final int CALLORAPPLY_VALUE = 1;
    public static final int COLLECTIONCALL_VALUE = 2;
    private static final CallType[] VALUES_ARRAY;
    public static final List<CallType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CallType[]{CALLSERVICE, CALLORAPPLY, COLLECTIONCALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CallType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CallType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CallType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CallType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CallType get(int value) {
        switch (value) {
            case 0: {
                return CALLSERVICE;
            }
            case 1: {
                return CALLORAPPLY;
            }
            case 2: {
                return COLLECTIONCALL;
            }
        }
        return null;
    }

    private CallType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

