/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;

public class Selector {
    public static final String ALL = "*";

    public INode selectNode(INode context, Object ... segments) {
        List<INode> nodes = this.selectNodes(context, segments);
        return nodes.size() > 0 ? nodes.get(0) : null;
    }

    public INode selectParent(INode context, IFilter<INode> filter) {
        if (context == null) {
            return context;
        }
        do {
            if (!filter.select(context)) continue;
            return context;
        } while ((context = context.parentNode()) != null);
        return context;
    }

    public List<INode> selectNodes(INode context, Object ... segments) {
        List<INode> list = new ArrayList<INode>();
        Object[] objectArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (context == null) break;
            if (obj instanceof IFilter) {
                IFilter filter = (IFilter)obj;
                ArrayList<INode> newList = new ArrayList<INode>();
                for (INode node : list) {
                    if (!filter.select(node)) continue;
                    newList.add(node);
                }
                list = newList;
                context = list.size() > 0 ? list.get(0) : null;
            } else if (obj instanceof String) {
                list = this.selectNodesByName(context, (String)obj);
                context = list.size() > 0 ? list.get(0) : null;
            } else if (obj instanceof QName) {
                list = this.selectNodesByName(context, (QName)obj);
                context = list.size() > 0 ? list.get(0) : null;
            } else if (obj instanceof Number) {
                int n3 = ((Number)obj).intValue() - 1;
                list.clear();
                try {
                    context = list.get(n3);
                    if (context != null) {
                        list.add(context);
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                    context = null;
                }
            } else {
                list.clear();
                context = null;
            }
            ++n2;
        }
        return list;
    }

    List<INode> selectNodesByName(INode context, QName s) {
        ArrayList<INode> list = new ArrayList<INode>();
        if (s.getLocalPart().equals("..")) {
            INode parent = context.parentNode();
            if (parent != null) {
                list.add(parent);
            }
        } else {
            List<INode> children = context.children();
            if (s.equals(ALL)) {
                list.addAll(children);
            } else {
                for (INode n : children) {
                    if (!s.equals(n.nodeName())) continue;
                    list.add(n);
                }
            }
        }
        return list;
    }

    List<INode> selectNodesByName(INode context, String s) {
        ArrayList<INode> list = new ArrayList<INode>();
        if (s.equals("..")) {
            INode parent = context.parentNode();
            if (parent != null) {
                list.add(parent);
            }
        } else {
            List<INode> children = context.children();
            if (s.equals(ALL)) {
                list.addAll(children);
            } else {
                for (INode n : children) {
                    if (!s.equals(n.nodeName().getLocalPart())) continue;
                    list.add(n);
                }
            }
        }
        return list;
    }
}

