/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.rules.CValidator;

public class ConditionValidator
extends CValidator {
    public static final IFilter<INode> PARENTS = new NodeNameFilter(ND_WHILE, ND_IF, ND_ELSEIF, ND_WHILE, ND_REPEAT_UNTIL);
    Validator fExprValidator;
    protected String fExpressionLanguage;

    @Override
    protected void start() {
        super.start();
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the expression language for support in the BPEL model", date="10/2/2006", sa=4, errors="BPELC__UNSUPPORTED_XML_LANG")
    public void rule_CheckExpressionLanguageSupport_20() {
        this.fExpressionLanguage = this.getLanguage(this.mNode, AT_EXPRESSIONLANGUAGE);
        if (!this.mModelQuery.hasSupport(1, this.fExpressionLanguage)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__UNSUPPORTED_XML_LANG", AT_EXPRESSIONLANGUAGE, this.fExpressionLanguage);
            this.disableRules(20, 1000);
            return;
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the actual expression using the expression language validator.", date="10/2/2006", sa=0, order=100, warnings="BPELC__NO_EXPRESSION_VALIDATOR")
    public void checkExpression() {
        if (this.fExprValidator == null) {
            this.fExprValidator = this.createExpressionValidator(new QName(this.fExpressionLanguage, this.mNode.nodeName().getLocalPart()));
            if (this.fExprValidator == null) {
                return;
            }
            this.attach(this.fExprValidator);
        }
    }
}

