/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeLabelProvider;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class DriverListLabelProvider
extends DriverTreeLabelProvider
implements ITableLabelProvider {
    @Override
    public String getText(Object element) {
        if (element instanceof IPropertySet) {
            return ((IPropertySet)element).getName();
        }
        return super.getText(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IPropertySet) {
            IPropertySet pset = (IPropertySet)element;
            DriverInstance di = new DriverInstance(pset);
            String vendor = di.getNamedPropertyByID("org.eclipse.datatools.connectivity.db.vendor");
            String version = di.getNamedPropertyByID("org.eclipse.datatools.connectivity.db.version");
            DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(vendor, version);
            String versionDisplay = null;
            String vendorDisplay = null;
            if (dbDef != null) {
                versionDisplay = dbDef.getVersionDisplayString();
                vendorDisplay = dbDef.getProductDisplayString();
            }
            if (columnIndex == 0) {
                return di.getName();
            }
            if (columnIndex == 1) {
                if (vendorDisplay != null && vendorDisplay.trim().length() > 0) {
                    return vendorDisplay;
                }
            } else if (columnIndex == 2 && versionDisplay != null && versionDisplay.trim().length() > 0) {
                return versionDisplay;
            }
        }
        return null;
    }
}

