/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IDLTKLanguageToolkitExtension;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ArchiveFolder;
import org.eclipse.dltk.internal.core.BuiltinScriptFolder;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.index.lucene.SearchMatch;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;

public class SearchMatchHandler {
    private Map<String, IProjectFragment> fProjectFragmentCache = new HashMap<String, IProjectFragment>();
    private Map<String, ISourceModule> fSourceModuleCache = new HashMap<String, ISourceModule>();
    private ISearchRequestor fSearchRequestor;
    private IDLTKSearchScope fScope;

    public SearchMatchHandler(IDLTKSearchScope scope, ISearchRequestor searchRequestor) {
        this.fScope = scope;
        this.fSearchRequestor = searchRequestor;
    }

    public void handle(SearchMatch match, boolean isReference) {
        String name;
        String containerPath = match.container;
        IDLTKLanguageToolkit toolkit = ((DLTKSearchScope)this.fScope).getLanguageToolkit();
        if (toolkit instanceof IDLTKLanguageToolkitExtension && ((IDLTKLanguageToolkitExtension)toolkit).isArchiveFileName(containerPath)) {
            containerPath = String.valueOf(containerPath) + "|";
        }
        if (containerPath.length() != 0 && containerPath.charAt(containerPath.length() - 1) != '/') {
            containerPath = String.valueOf(containerPath) + '/';
        }
        String filePath = match.path;
        String resourcePath = String.valueOf(containerPath) + filePath;
        IProjectFragment projectFragment = this.fProjectFragmentCache.get(containerPath);
        if (projectFragment == null) {
            projectFragment = ((DLTKSearchScope)this.fScope).projectFragment(resourcePath);
            if (projectFragment == null) {
                projectFragment = ((DLTKSearchScope)this.fScope).projectFragment(containerPath);
            }
            this.fProjectFragmentCache.put(containerPath, projectFragment);
        }
        if (projectFragment == null) {
            return;
        }
        if (!this.fScope.encloses(resourcePath)) {
            return;
        }
        ISourceModule sourceModule = this.fSourceModuleCache.get(resourcePath);
        if (sourceModule == null) {
            ArchiveFolder scriptFolder;
            FilePathHandler filePathHandler;
            if (projectFragment.isArchive()) {
                filePathHandler = new FilePathHandler(filePath);
                scriptFolder = new ArchiveFolder((ProjectFragment)projectFragment, filePathHandler.getFolderPath());
                sourceModule = scriptFolder.getSourceModule(filePathHandler.getFileName());
            } else if (projectFragment.isExternal()) {
                filePathHandler = new FilePathHandler(filePath);
                scriptFolder = new ExternalScriptFolder((ProjectFragment)projectFragment, filePathHandler.getFolderPath());
                sourceModule = scriptFolder.getSourceModule(filePathHandler.getFileName());
            } else if (projectFragment.isBuiltin()) {
                filePathHandler = new FilePathHandler(filePath);
                scriptFolder = new BuiltinScriptFolder((ProjectFragment)projectFragment, filePathHandler.getFolderPath());
                sourceModule = scriptFolder.getSourceModule(filePathHandler.getFileName());
            } else {
                IProject project = projectFragment.getScriptProject().getProject();
                sourceModule = DLTKCore.createSourceModuleFrom((IFile)project.getFile(filePath));
            }
            this.fSourceModuleCache.put(resourcePath, sourceModule);
        }
        if ((name = match.elementName) == null) {
            return;
        }
        ModelManager modelManager = ModelManager.getModelManager();
        name = modelManager.intern(name);
        this.fSearchRequestor.match(match.elementType, match.flags, match.offset, match.length, match.nameOffset, match.nameLength, name, match.metadata, match.doc, match.qualifier, match.parent, sourceModule, isReference);
    }

    private static class FilePathHandler {
        private IPath fFolderPath = Path.EMPTY;
        private String fFileName;

        public FilePathHandler(String filePath) {
            this.fFileName = filePath;
            int i = filePath.lastIndexOf(47);
            if (i == -1) {
                i = filePath.lastIndexOf(92);
            }
            if (i != -1) {
                this.fFolderPath = new Path(filePath.substring(0, i));
                this.fFileName = filePath.substring(i + 1);
            }
        }

        public IPath getFolderPath() {
            return this.fFolderPath;
        }

        public String getFileName() {
            return this.fFileName;
        }
    }
}

