/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.tools.emf.ui.common.CommandToStringConverter;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.AbstractPickList;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.KeyBindingCommandSelectionDialog;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MKeySequence;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class KeyBindingEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    private final List<Action> actions = new ArrayList<Action>();
    private final IEMFEditListProperty KEY_BINDING__PARAMETERS = EMFEditProperties.list((EditingDomain)this.getEditingDomain(), (EStructuralFeature)CommandsPackageImpl.Literals.KEY_BINDING__PARAMETERS);
    @Inject
    private IModelResource resource;

    @Inject
    public KeyBindingEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.KeyBindingEditor_AddParameter, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Parameter")){

            public void run() {
                KeyBindingEditor.this.handleAddParameter();
            }
        });
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.KeyBinding");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.KeyBindingEditor_Label;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.KeyBindingEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, (IObservableValue)this.getMaster(), false);
                this.createForm(this.composite, this.context, (IObservableValue)this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, (IObservableValue)this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.layout(true, true);
        }
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, IObservableValue master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, master, context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.KeyBindingEditor_Sequence);
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        Binding binding = context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)CommandsPackageImpl.Literals.KEY_SEQUENCE__KEY_SEQUENCE).observeDetail((IObservableValue)this.getMaster()), new UpdateValueStrategy().setBeforeSetValidator((IValidator)new BindingValidator()), new UpdateValueStrategy());
        Util.addDecoration((Control)t, binding);
        l = new Label(parent, 0);
        l.setText(this.Messages.KeyBindingEditor_Command);
        l.setLayoutData((Object)new GridData());
        t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        t.setLayoutData((Object)new GridData(768));
        t.setEditable(false);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)CommandsPackageImpl.Literals.KEY_BINDING__COMMAND).observeDetail((IObservableValue)this.getMaster()), new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new CommandToStringConverter(this.Messages)));
        final Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyBindingCommandSelectionDialog dialog = new KeyBindingCommandSelectionDialog(b.getShell(), (MKeyBinding)KeyBindingEditor.this.getMaster().getValue(), KeyBindingEditor.this.resource, KeyBindingEditor.this.Messages);
                dialog.open();
            }
        });
        E4PickList pickList = new E4PickList(parent, 0, Arrays.asList(AbstractPickList.PickListFeatures.NO_PICKER), (AbstractComponentEditor)this, (EStructuralFeature)CommandsPackageImpl.Literals.KEY_BINDING__PARAMETERS){

            @Override
            protected void addPressed() {
                KeyBindingEditor.this.handleAddParameter();
            }

            @Override
            protected List<?> getContainerChildren(Object master) {
                return ((MCommand)master).getParameters();
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(this.Messages.KeyBindingEditor_Parameters);
        TableViewer viewer = pickList.getList();
        viewer.setInput((Object)this.KEY_BINDING__PARAMETERS.observeDetail((IObservableValue)this.getMaster()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        this.createContributedEditorTabs(folder, context, this.getMaster(), MKeyBinding.class);
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList getChildList(Object element) {
        return this.KEY_BINDING__PARAMETERS.observe(element);
    }

    @Override
    public String getDetailLabel(Object element) {
        MKeySequence seq = (MKeySequence)element;
        if (seq.getKeySequence() != null && seq.getKeySequence().trim().length() > 0) {
            return seq.getKeySequence();
        }
        return null;
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{CommandsPackageImpl.Literals.KEY_SEQUENCE__KEY_SEQUENCE})};
    }

    protected void handleAddParameter() {
        MKeyBinding item = (MKeyBinding)this.getMaster().getValue();
        MParameter param = MCommandsFactory.INSTANCE.createParameter();
        this.setElementId(param);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)item, (Object)CommandsPackageImpl.Literals.KEY_BINDING__PARAMETERS, (Object)param);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    class BindingValidator
    implements IValidator {
        BindingValidator() {
        }

        public IStatus validate(Object value) {
            int statusCode;
            int n = statusCode = KeyBindingEditor.this.getEditor().isLiveModel() ? 4 : 2;
            if (value != null && value.toString().trim().length() > 0) {
                try {
                    KeySequence keySequence = KeySequence.getInstance((String)value.toString());
                    if (!keySequence.isComplete()) {
                        return new Status(statusCode, "org.eclipse.e4.tools.emf.ui", ((KeyBindingEditor)KeyBindingEditor.this).Messages.KeyBindingEditor_SequenceNotComplete);
                    }
                    if (keySequence.isEmpty()) {
                        return new Status(statusCode, "org.eclipse.e4.tools.emf.ui", ((KeyBindingEditor)KeyBindingEditor.this).Messages.KeyBindingEditor_SequenceEmpty);
                    }
                    if (!value.toString().toUpperCase().equals(value.toString())) {
                        return new Status(4, "org.eclipse.e4.tools.emf.ui", ((KeyBindingEditor)KeyBindingEditor.this).Messages.KeyBindingEditor_SequenceLowercase);
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    return new Status(statusCode, "org.eclipse.e4.tools.emf.ui", e.getMessage(), (Throwable)e);
                }
            }
            return new Status(statusCode, "org.eclipse.e4.tools.emf.ui", ((KeyBindingEditor)KeyBindingEditor.this).Messages.KeyBindingEditor_SequenceEmpty);
        }
    }
}

