/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class BranchNameValidator {
    public static final String ILLEGAL_CHARS = "/ ";

    public static boolean featureExists(GitFlowRepository repository, String featureName) throws CoreException {
        return BranchNameValidator.branchExists(repository, repository.getConfig().getFullFeatureBranchName(featureName));
    }

    public static boolean hotfixExists(GitFlowRepository repository, String hotfixName) throws CoreException {
        return BranchNameValidator.branchExists(repository, repository.getConfig().getFullHotfixBranchName(hotfixName));
    }

    public static boolean releaseExists(GitFlowRepository repository, String releaseName) throws CoreException {
        return BranchNameValidator.branchExists(repository, repository.getConfig().getFullReleaseBranchName(releaseName));
    }

    private static boolean branchExists(GitFlowRepository repository, String fullBranchName) throws CoreException {
        List branches;
        try {
            branches = Git.wrap((Repository)repository.getRepository()).branchList().call();
        }
        catch (GitAPIException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
        for (Ref ref : branches) {
            if (!fullBranchName.equals(ref.getTarget().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBranchNameValid(String name) {
        return Repository.isValidRefName((String)("refs/heads/" + name));
    }
}

