/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.text.Text;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.common.attributes.IAttributeCopier;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowType;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.colorlist.ColorList;
import org.eclipse.gef.dot.internal.language.colorlist.WC;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.escstring.EscString;
import org.eclipse.gef.dot.internal.language.escstring.JustifiedText;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.point.Point;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedShape;
import org.eclipse.gef.dot.internal.language.shape.Shape;
import org.eclipse.gef.dot.internal.language.splines.Splines;
import org.eclipse.gef.dot.internal.language.splinetype.Spline;
import org.eclipse.gef.dot.internal.language.splinetype.SplineType;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.style.Style;
import org.eclipse.gef.dot.internal.language.style.StyleItem;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.DotArrowShapeDecorations;
import org.eclipse.gef.dot.internal.ui.DotBSplineInterpolator;
import org.eclipse.gef.dot.internal.ui.DotColorUtil;
import org.eclipse.gef.dot.internal.ui.DotHTMLLabelJavaFxNode;
import org.eclipse.gef.dot.internal.ui.DotNodePart;
import org.eclipse.gef.dot.internal.ui.DotPolygonBasedNodeShapes;
import org.eclipse.gef.dot.internal.ui.DotRecordBasedJavaFxNode;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.nodes.PolylineInterpolator;
import org.eclipse.gef.fx.nodes.StraightRouter;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Ellipse;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef.zest.fx.ZestProperties;

public class Dot2ZestAttributesConverter
implements IAttributeCopier {
    private DotColorUtil colorUtil = new DotColorUtil();
    private Options options;

    public void copy(IAttributeStore source, IAttributeStore target) {
        if (source instanceof org.eclipse.gef.graph.Node && target instanceof org.eclipse.gef.graph.Node) {
            this.convertAttributes((org.eclipse.gef.graph.Node)source, (org.eclipse.gef.graph.Node)target);
        } else if (source instanceof Edge && target instanceof Edge) {
            this.convertAttributes((Edge)source, (Edge)target);
        } else if (source instanceof Graph && target instanceof Graph) {
            this.convertAttributes((Graph)source, (Graph)target);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void convertAttributes(Edge dot, Edge zest) {
        String dotColorScheme;
        String javaFxColor;
        DirType dotDir;
        String dotTailLabel;
        String dotHeadLabel;
        String dotXLabel;
        String dotId = DotAttributes.getId((Edge)dot);
        if (dotId != null) {
            ZestProperties.setCssId((Edge)zest, (String)dotId);
        }
        String edgeLabelCssStyle = this.computeZestEdgeLabelCssStyle(dot);
        String targetSourceLabelCssStyle = this.computeZestTargetSourceLabelCssStyle(dot);
        String dotLabel = DotAttributes.getLabel((Edge)dot);
        if (dotLabel != null) {
            dotLabel = this.decodeEscString(dotLabel, dot);
            dotLabel = this.decodeLineBreak(dotLabel);
            ZestProperties.setLabel((Edge)zest, (String)dotLabel);
            if (edgeLabelCssStyle != null) {
                ZestProperties.setLabelCssStyle((Edge)zest, (String)edgeLabelCssStyle);
            }
        }
        if ((dotXLabel = DotAttributes.getXlabel((Edge)dot)) != null) {
            dotXLabel = this.decodeEscString(dotXLabel, dot);
            dotXLabel = this.decodeLineBreak(dotXLabel);
            ZestProperties.setExternalLabel((Edge)zest, (String)dotXLabel);
            if (edgeLabelCssStyle != null) {
                ZestProperties.setExternalLabelCssStyle((Edge)zest, (String)edgeLabelCssStyle);
            }
        }
        if ((dotHeadLabel = DotAttributes.getHeadlabel((Edge)dot)) != null) {
            dotHeadLabel = this.decodeEscString(dotHeadLabel, dot);
            dotHeadLabel = this.decodeLineBreak(dotHeadLabel);
            ZestProperties.setTargetLabel((Edge)zest, (String)dotHeadLabel);
            if (targetSourceLabelCssStyle != null) {
                ZestProperties.setTargetLabelCssStyle((Edge)zest, (String)targetSourceLabelCssStyle);
            }
        }
        if ((dotTailLabel = DotAttributes.getTaillabel((Edge)dot)) != null) {
            dotTailLabel = this.decodeEscString(dotTailLabel, dot);
            dotTailLabel = this.decodeLineBreak(dotTailLabel);
            ZestProperties.setSourceLabel((Edge)zest, (String)dotTailLabel);
            if (targetSourceLabelCssStyle != null) {
                ZestProperties.setSourceLabelCssStyle((Edge)zest, (String)targetSourceLabelCssStyle);
            }
        }
        String dotStyle = DotAttributes.getStyle((Edge)dot);
        String connectionCssStyle = null;
        if (EdgeStyle.DASHED.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-dash-array: 7 7;";
        } else if (EdgeStyle.DOTTED.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-dash-array: 1 7;";
        } else if (EdgeStyle.BOLD.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-width: 2;";
        } else if (EdgeStyle.INVIS.toString().equals(dotStyle)) {
            ZestProperties.setInvisible((Edge)zest, (Boolean)true);
        }
        if (connectionCssStyle == null) {
            connectionCssStyle = "-fx-stroke-line-cap: butt;";
        }
        if ((dotDir = DotAttributes.getDirParsed((Edge)dot)) == null) {
            dotDir = GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph())) ? DirType.FORWARD : DirType.NONE;
        }
        Color dotColor = null;
        ColorList colorList = DotAttributes.getColorParsed((Edge)dot);
        if (colorList != null && !colorList.getColorValues().isEmpty()) {
            dotColor = ((WC)colorList.getColorValues().get(0)).getColor();
        }
        if ((javaFxColor = this.colorUtil.computeZestColor(dotColorScheme = DotAttributes.getColorscheme((Edge)dot), dotColor)) != null) {
            String zestStroke = "-fx-stroke: " + javaFxColor + ";";
            connectionCssStyle = String.valueOf(connectionCssStyle) + zestStroke;
        }
        ZestProperties.setCurveCssStyle((Edge)zest, (String)connectionCssStyle);
        Color dotFillColor = DotAttributes.getFillcolorParsed((Edge)dot);
        String javaFxFillColor = this.colorUtil.computeZestColor(dotColorScheme, dotFillColor);
        Double arrowSizeParsed = DotAttributes.getArrowsizeParsed((Edge)dot);
        double arrowSize = arrowSizeParsed == null ? 1.0 : arrowSizeParsed;
        String dotArrowHead = DotAttributes.getArrowhead((Edge)dot);
        Node zestEdgeTargetDecoration = null;
        if (dotArrowHead == null || DotAttributes.getArrowheadParsed((Edge)dot).getArrowShapes().isEmpty()) {
            if (GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph().getRootGraph()))) {
                zestEdgeTargetDecoration = DotArrowShapeDecorations.getDefault(arrowSize, true, javaFxColor, javaFxFillColor);
            }
        } else {
            zestEdgeTargetDecoration = this.computeZestDecoration(DotAttributes.getArrowheadParsed((Edge)dot), arrowSize, javaFxColor, javaFxFillColor);
        }
        if (DirType.FORWARD.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
            ZestProperties.setTargetDecoration((Edge)zest, (Node)zestEdgeTargetDecoration);
        }
        String dotArrowTail = DotAttributes.getArrowtail((Edge)dot);
        Node zestEdgeSourceDecoration = null;
        if (dotArrowTail == null || DotAttributes.getArrowtailParsed((Edge)dot).getArrowShapes().isEmpty()) {
            if (GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph().getRootGraph()))) {
                zestEdgeSourceDecoration = DotArrowShapeDecorations.getDefault(arrowSize, true, javaFxColor, javaFxFillColor);
            }
        } else {
            zestEdgeSourceDecoration = this.computeZestDecoration(DotAttributes.getArrowtailParsed((Edge)dot), arrowSize, javaFxColor, javaFxFillColor);
        }
        if (DirType.BACK.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
            ZestProperties.setSourceDecoration((Edge)zest, (Node)zestEdgeSourceDecoration);
        }
        GeometryNode curve = new GeometryNode();
        ZestProperties.setCurve((Edge)zest, (Node)curve);
        if (!this.options().emulateLayout) {
            String dotPos;
            String splines = DotAttributes.getSplines((Graph)dot.getGraph().getRootGraph());
            if (Splines.EMPTY.toString().equals(splines) || Splines.NONE.toString().equals(splines)) {
                ZestProperties.setInvisible((Edge)zest, (Boolean)true);
            }
            if ((dotPos = DotAttributes.getPos((Edge)dot)) != null && !this.options().ignorePositions) {
                List<org.eclipse.gef.geometry.planar.Point> bSplineControlPoints = this.computeZestBSplineControlPoints(dot);
                if (Splines.LINE.toString().equals(splines) || Splines.FALSE.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                } else if (Splines.POLYLINE.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
                } else if (Splines.ORTHO.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new OrthogonalRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, this.computeZestOrthogonalControlPoints(bSplineControlPoints));
                } else if (!Splines.COMPOUND.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new DotBSplineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
                }
            }
            String dotLp = DotAttributes.getLp((Edge)dot);
            if (dotLabel != null && dotLp != null && !this.options().ignorePositions) {
                ZestProperties.setLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getLpParsed((Edge)dot), dotLabel));
            }
            String dotXlp = DotAttributes.getXlp((Edge)dot);
            if (dotXLabel != null && dotXlp != null && !this.options().ignorePositions) {
                ZestProperties.setExternalLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getXlpParsed((Edge)dot), dotXLabel));
            }
            String headLp = DotAttributes.getHeadLp((Edge)dot);
            if (dotHeadLabel != null && headLp != null && !this.options().ignorePositions) {
                ZestProperties.setTargetLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getHeadLpParsed((Edge)dot), dotHeadLabel));
            }
            String tailLp = DotAttributes.getTailLp((Edge)dot);
            if (dotTailLabel != null && tailLp != null && !this.options().ignorePositions) {
                ZestProperties.setSourceLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getTailLpParsed((Edge)dot), dotTailLabel));
            }
        }
    }

    private List<org.eclipse.gef.geometry.planar.Point> computeZestOrthogonalControlPoints(List<org.eclipse.gef.geometry.planar.Point> bSplineControlPoints) {
        ArrayList<org.eclipse.gef.geometry.planar.Point> subList = new ArrayList<org.eclipse.gef.geometry.planar.Point>(bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
        int i = subList.size() - 2;
        while (i > 0) {
            org.eclipse.gef.geometry.planar.Point p = (org.eclipse.gef.geometry.planar.Point)subList.get(i + 1);
            org.eclipse.gef.geometry.planar.Point q = (org.eclipse.gef.geometry.planar.Point)subList.get(i);
            org.eclipse.gef.geometry.planar.Point r = (org.eclipse.gef.geometry.planar.Point)subList.get(i - 1);
            if (p.x == q.x && q.x == r.x || p.y == q.y && q.y == r.y) {
                subList.remove(i);
            }
            --i;
        }
        List<org.eclipse.gef.geometry.planar.Point> subList2 = subList.subList(1, subList.size() - 1);
        return subList2;
    }

    private Node computeZestDecoration(ArrowType arrowType, double arrowSize, String javaFxColor, String javaFxFillColor) {
        return DotArrowShapeDecorations.get(arrowType, arrowSize, javaFxColor, javaFxFillColor);
    }

    private List<org.eclipse.gef.geometry.planar.Point> computeZestBSplineControlPoints(Edge dot) {
        SplineType splineType = DotAttributes.getPosParsed((Edge)dot);
        ArrayList<org.eclipse.gef.geometry.planar.Point> controlPoints = new ArrayList<org.eclipse.gef.geometry.planar.Point>();
        for (Spline spline : splineType.getSplines()) {
            Point startp = spline.getStartp();
            if (startp == null) {
                startp = (Point)spline.getControlPoints().get(0);
            }
            controlPoints.add(new org.eclipse.gef.geometry.planar.Point(startp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * startp.getY()));
            for (Point cp : spline.getControlPoints()) {
                controlPoints.add(new org.eclipse.gef.geometry.planar.Point(cp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * cp.getY()));
            }
            Point endp = spline.getEndp();
            if (endp == null) {
                endp = (Point)spline.getControlPoints().get(spline.getControlPoints().size() - 1);
            }
            controlPoints.add(new org.eclipse.gef.geometry.planar.Point(endp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * endp.getY()));
        }
        return controlPoints;
    }

    private String computeZestEdgeLabelCssStyle(Edge dot) {
        Color dotColor = DotAttributes.getFontcolorParsed((Edge)dot);
        String dotColorScheme = DotAttributes.getColorscheme((Edge)dot);
        String dotFont = DotAttributes.getFontname((Edge)dot);
        Double dotSize = DotAttributes.getFontsizeParsed((Edge)dot);
        return this.computeZestLabelCssStyle(dotColor, dotColorScheme, dotFont, dotSize);
    }

    private String computeZestTargetSourceLabelCssStyle(Edge dot) {
        Double dotSize;
        Color dotColor = DotAttributes.getLabelfontcolorParsed((Edge)dot);
        if (dotColor == null) {
            dotColor = DotAttributes.getFontcolorParsed((Edge)dot);
        }
        String dotColorScheme = DotAttributes.getColorscheme((Edge)dot);
        String dotFont = DotAttributes.getLabelfontname((Edge)dot);
        if (dotFont == null) {
            dotFont = DotAttributes.getFontname((Edge)dot);
        }
        if ((dotSize = DotAttributes.getLabelfontsizeParsed((Edge)dot)) == null) {
            dotSize = DotAttributes.getFontsizeParsed((Edge)dot);
        }
        return this.computeZestLabelCssStyle(dotColor, dotColorScheme, dotFont, dotSize);
    }

    private String computeZestLabelCssStyle(Color dotColor, String dotColorScheme, String dotFont, Double dotSize) {
        String javaFxColor;
        StringBuilder zestStyle = new StringBuilder();
        if (dotColor != null && (javaFxColor = this.colorUtil.computeZestColor(dotColorScheme, dotColor)) != null) {
            zestStyle.append("-fx-fill: ");
            zestStyle.append(javaFxColor);
            zestStyle.append(";");
        }
        if (dotFont != null && dotFont.length() > 0) {
            zestStyle.append("-fx-font-family: \"");
            zestStyle.append(dotFont);
            zestStyle.append("\";");
        }
        if (dotSize != null) {
            zestStyle.append("-fx-font-size: ");
            zestStyle.append(dotSize);
            zestStyle.append(";");
        }
        return zestStyle.length() > 0 ? zestStyle.toString() : null;
    }

    protected void convertAttributes(org.eclipse.gef.graph.Node dot, org.eclipse.gef.graph.Node zest) {
        EscString dotTooltip;
        boolean isRecordBasedShape = false;
        String dotId = DotAttributes.getId((org.eclipse.gef.graph.Node)dot);
        if (dotId != null) {
            ZestProperties.setCssId((org.eclipse.gef.graph.Node)zest, (String)dotId);
        }
        String dotHeight = DotAttributes.getHeight((org.eclipse.gef.graph.Node)dot);
        String dotWidth = DotAttributes.getWidth((org.eclipse.gef.graph.Node)dot);
        double zestWidth = (dotWidth == null ? 0.75 : Double.parseDouble(dotWidth)) * 72.0;
        double zestHeight = (dotHeight == null ? 0.5 : Double.parseDouble(dotHeight)) * 72.0;
        String dotLabel = DotAttributes.getLabel((org.eclipse.gef.graph.Node)dot);
        if (dotLabel == null) {
            dotLabel = "\\N";
        }
        dotLabel = this.decodeEscString(dotLabel, dot);
        boolean isHtmlLabel = DotAttributes.getLabelRaw((org.eclipse.gef.graph.Node)dot) != null ? DotAttributes.getLabelRaw((org.eclipse.gef.graph.Node)dot).getType() == ID.Type.HTML_STRING : false;
        String zestNodeLabelCssStyle = this.computeZestNodeLabelCssStyle(dot);
        if (zestNodeLabelCssStyle != null) {
            ZestProperties.setLabelCssStyle((org.eclipse.gef.graph.Node)zest, (String)zestNodeLabelCssStyle);
        }
        Shape dotShape = DotAttributes.getShapeParsed((org.eclipse.gef.graph.Node)dot);
        StringBuilder zestShapeStyle = this.computeZestStyle(dot, dotShape);
        GeometryNode zestShape = null;
        Node innerShape = null;
        double innerDistance = 0.0;
        if (dotShape == null) {
            zestShape = new GeometryNode((IGeometry)new Ellipse(0.0, 0.0, 0.0, 0.0));
        } else if (dotShape.getShape() instanceof PolygonBasedShape) {
            PolygonBasedNodeShape polygonShape = ((PolygonBasedShape)dotShape.getShape()).getShape();
            zestShape = this.hasStyle(dot, NodeStyle.ROUNDED) ? DotPolygonBasedNodeShapes.getRoundedStyled(polygonShape) : DotPolygonBasedNodeShapes.get(polygonShape);
            innerShape = DotPolygonBasedNodeShapes.getInner(polygonShape);
            innerDistance = DotPolygonBasedNodeShapes.getInnerDistance(polygonShape);
        } else if (dotShape.getShape() instanceof RecordBasedShape && !isHtmlLabel) {
            RecordBasedNodeShape recordBasedShape = ((RecordBasedShape)dotShape.getShape()).getShape();
            zestShapeStyle = new StringBuilder(zestShapeStyle.toString().replaceAll("-fx-fill", "-fx-background-color"));
            if (RecordBasedNodeShape.MRECORD.equals((Object)recordBasedShape)) {
                zestShapeStyle.append("-fx-background-radius:10px;-fx-border-radius:10px;");
            }
            if (!zestShapeStyle.toString().contains("-fx-border-style:")) {
                zestShapeStyle.append("-fx-border-style:solid;");
            }
            StringBuilder recordBasedShapeLineStyle = this.computeRecordBasedShapeLineStyle(dot);
            DotRecordBasedJavaFxNode node = new DotRecordBasedJavaFxNode(dotLabel, DotAttributes.getRankdirParsed((Graph)dot.getGraph()), zestNodeLabelCssStyle, recordBasedShapeLineStyle.toString());
            zestShape = node.getFxElement();
            Bounds bounds = node.getBounds();
            zestWidth = Math.max(zestWidth, bounds.getWidth());
            zestHeight = Math.max(zestHeight, bounds.getHeight());
            isRecordBasedShape = true;
        }
        if (zestShape != null) {
            if (zestShapeStyle.length() > 0) {
                if (innerShape != null) {
                    String style = zestShapeStyle.toString();
                    innerShape.setStyle(style);
                    zestShape.setStyle(style.replaceAll("-fx-fill[^;]+;", ""));
                } else {
                    zestShape.setStyle(zestShapeStyle.toString());
                }
            }
            ZestProperties.setShape((org.eclipse.gef.graph.Node)zest, (Node)zestShape);
            if (innerShape != null) {
                zest.attributesProperty().put((Object)DotNodePart.DOT_PROPERTY_INNER_SHAPE__N, (Object)innerShape);
                zest.attributesProperty().put((Object)DotNodePart.DOT_PROPERTY_INNER_SHAPE_DISTANCE__N, (Object)innerDistance);
            }
        }
        if (this.hasStyle(dot, NodeStyle.INVIS)) {
            ZestProperties.setInvisible((org.eclipse.gef.graph.Node)zest, (Boolean)true);
        }
        if (isHtmlLabel) {
            DotHTMLLabelJavaFxNode htmlNode = new DotHTMLLabelJavaFxNode(dotLabel, DotAttributes.getFontname((org.eclipse.gef.graph.Node)dot), DotAttributes.getFontsize((org.eclipse.gef.graph.Node)dot), DotAttributes.getFontcolor((org.eclipse.gef.graph.Node)dot), DotAttributes.getColorscheme((org.eclipse.gef.graph.Node)dot));
            ZestProperties.setShape((org.eclipse.gef.graph.Node)zest, (Node)htmlNode.getFxElement());
            Bounds htmlNodeBounds = htmlNode.getBounds();
            zestWidth = htmlNodeBounds.getWidth();
            zestHeight = htmlNodeBounds.getHeight();
        } else if (!isRecordBasedShape) {
            dotLabel = this.decodeLineBreak(dotLabel);
            ZestProperties.setLabel((org.eclipse.gef.graph.Node)zest, (String)dotLabel);
        }
        String dotXLabel = DotAttributes.getXlabel((org.eclipse.gef.graph.Node)dot);
        if (dotXLabel != null) {
            dotXLabel = this.decodeEscString(dotXLabel, dot);
            ZestProperties.setExternalLabel((org.eclipse.gef.graph.Node)zest, (String)dotXLabel);
            if (zestNodeLabelCssStyle != null) {
                ZestProperties.setExternalLabelCssStyle((org.eclipse.gef.graph.Node)zest, (String)zestNodeLabelCssStyle);
            }
        }
        if (this.options().emulateLayout && !Boolean.TRUE.equals(DotAttributes.getFixedsizeParsed((org.eclipse.gef.graph.Node)dot)) && !isRecordBasedShape && !isHtmlLabel) {
            Dimension labelSize = Dot2ZestAttributesConverter.computeZestLabelSize(dotLabel);
            ZestProperties.setSize((org.eclipse.gef.graph.Node)zest, (Dimension)Dimension.max((Dimension)new Dimension(zestWidth, zestHeight), (Dimension)labelSize));
        } else {
            ZestProperties.setSize((org.eclipse.gef.graph.Node)zest, (Dimension)new Dimension(zestWidth, zestHeight));
        }
        String dotPos = DotAttributes.getPos((org.eclipse.gef.graph.Node)dot);
        if (dotPos != null && !this.options().ignorePositions) {
            Point dotPosParsed = DotAttributes.getPosParsed((org.eclipse.gef.graph.Node)dot);
            ZestProperties.setPosition((org.eclipse.gef.graph.Node)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestPosition(dotPosParsed, zestWidth, zestHeight));
            ZestProperties.setLayoutIrrelevant((org.eclipse.gef.graph.Node)zest, (Boolean)dotPosParsed.isInputOnly());
        }
        if ((dotTooltip = DotAttributes.getTooltipParsed((org.eclipse.gef.graph.Node)dot)) != null) {
            String stringTooltip = dotTooltip.getLines().stream().map(JustifiedText::getText).collect(Collectors.joining("\n"));
            String zestTooltip = this.decodeEscString(stringTooltip, dot);
            ZestProperties.setTooltip((org.eclipse.gef.graph.Node)zest, (String)zestTooltip);
        }
        String dotXlp = DotAttributes.getXlp((org.eclipse.gef.graph.Node)dot);
        if (dotXLabel != null && dotXlp != null && !this.options().ignorePositions) {
            Point dotXlpParsed = DotAttributes.getXlpParsed((org.eclipse.gef.graph.Node)dot);
            ZestProperties.setExternalLabelPosition((org.eclipse.gef.graph.Node)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(dotXlpParsed, dotXLabel));
        }
    }

    private StringBuilder computeZestStyle(org.eclipse.gef.graph.Node dot, Shape dotShape) {
        Style style;
        StringBuilder zestStyle = new StringBuilder();
        boolean isRecordBasedShape = dotShape != null ? dotShape.getShape() instanceof RecordBasedShape : false;
        Color dotColor = DotAttributes.getColorParsed((org.eclipse.gef.graph.Node)dot);
        String dotColorScheme = DotAttributes.getColorscheme((org.eclipse.gef.graph.Node)dot);
        String javaFxColor = this.colorUtil.computeZestColor(dotColorScheme, dotColor);
        if (isRecordBasedShape) {
            if (javaFxColor != null) {
                zestStyle.append("-fx-border-color: " + javaFxColor + ";");
            }
        } else {
            String stroke;
            String string = stroke = this.isNoneShape(dotShape) ? "none" : javaFxColor;
            if (stroke != null) {
                zestStyle.append("-fx-stroke: " + stroke + ";");
            }
        }
        if ((style = DotAttributes.getStyleParsed((org.eclipse.gef.graph.Node)dot)) != null) {
            for (StyleItem styleItem : style.getStyleItems()) {
                NodeStyle nodeStyle = NodeStyle.get((String)styleItem.getName());
                this.addNodeStyle(zestStyle, nodeStyle, isRecordBasedShape);
            }
        }
        if (this.hasStyle(dot, NodeStyle.FILLED)) {
            Color dotFillColor = null;
            ColorList fillColor = DotAttributes.getFillcolorParsed((org.eclipse.gef.graph.Node)dot);
            dotFillColor = fillColor != null && !fillColor.getColorValues().isEmpty() ? ((WC)fillColor.getColorValues().get(0)).getColor() : (dotColor != null ? dotColor : DotColors.getDefaultNodeFillColor());
            String javaFxFillColor = this.colorUtil.computeZestColor(dotColorScheme, dotFillColor);
            if (javaFxFillColor != null) {
                zestStyle.append("-fx-fill: " + javaFxFillColor + ";");
            }
        }
        return zestStyle;
    }

    private boolean isNoneShape(Shape dotShape) {
        EObject shape;
        if (dotShape != null && (shape = dotShape.getShape()) instanceof PolygonBasedShape) {
            return ((PolygonBasedShape)shape).getShape() == PolygonBasedNodeShape.NONE;
        }
        return false;
    }

    private StringBuilder computeRecordBasedShapeLineStyle(org.eclipse.gef.graph.Node dot) {
        Style style;
        StringBuilder zestStyle = new StringBuilder();
        Color dotColor = DotAttributes.getColorParsed((org.eclipse.gef.graph.Node)dot);
        String dotColorScheme = DotAttributes.getColorscheme((org.eclipse.gef.graph.Node)dot);
        String javaFxColor = this.colorUtil.computeZestColor(dotColorScheme, dotColor);
        if (javaFxColor != null) {
            zestStyle.append("-fx-stroke: " + javaFxColor + ";");
        }
        if ((style = DotAttributes.getStyleParsed((org.eclipse.gef.graph.Node)dot)) != null) {
            for (StyleItem styleItem : style.getStyleItems()) {
                NodeStyle nodeStyle = NodeStyle.get((String)styleItem.getName());
                this.addNodeStyle(zestStyle, nodeStyle, false);
            }
        }
        return zestStyle;
    }

    private org.eclipse.gef.geometry.planar.Point computeZestPosition(Point dotPosition, double widthInPixel, double heightInPixel) {
        return new org.eclipse.gef.geometry.planar.Point(dotPosition.getX() - widthInPixel / 2.0, (double)(this.options().invertYAxis ? -1 : 1) * dotPosition.getY() - heightInPixel / 2.0);
    }

    private org.eclipse.gef.geometry.planar.Point computeZestLabelPosition(Point dotLabelPosition, String labelText) {
        Dimension labelSize = Dot2ZestAttributesConverter.computeZestLabelSize(labelText);
        return this.computeZestPosition(dotLabelPosition, labelSize.getWidth(), labelSize.getHeight());
    }

    static Dimension computeZestLabelSize(String labelText) {
        Bounds layoutBounds = new Text(labelText).getLayoutBounds();
        return new Dimension(layoutBounds.getWidth(), layoutBounds.getHeight());
    }

    private String computeZestNodeLabelCssStyle(org.eclipse.gef.graph.Node dot) {
        Color dotColor = DotAttributes.getFontcolorParsed((org.eclipse.gef.graph.Node)dot);
        String dotColorScheme = DotAttributes.getColorscheme((org.eclipse.gef.graph.Node)dot);
        String dotFont = DotAttributes.getFontname((org.eclipse.gef.graph.Node)dot);
        Double dotSize = DotAttributes.getFontsizeParsed((org.eclipse.gef.graph.Node)dot);
        return this.computeZestLabelCssStyle(dotColor, dotColorScheme, dotFont, dotSize);
    }

    private void addNodeStyle(StringBuilder zestStyle, NodeStyle style, boolean isRecordBasedNode) {
        if (isRecordBasedNode) {
            switch (style) {
                case BOLD: {
                    zestStyle.append("-fx-border-width: 2;");
                    break;
                }
                case DASHED: {
                    zestStyle.append("-fx-border-style:dashed;");
                    break;
                }
                case DIAGONALS: {
                    break;
                }
                case DOTTED: {
                    zestStyle.append("-fx-border-style:dotted;");
                    break;
                }
                case RADIAL: {
                    break;
                }
                case ROUNDED: {
                    break;
                }
                case SOLID: {
                    zestStyle.append("-fx-border-style:solid;");
                    break;
                }
                case STRIPED: {
                    break;
                }
            }
        } else {
            switch (style) {
                case BOLD: {
                    zestStyle.append("-fx-stroke-width:2;");
                    break;
                }
                case DASHED: {
                    zestStyle.append("-fx-stroke-dash-array: 7 7;");
                    break;
                }
                case DIAGONALS: {
                    break;
                }
                case DOTTED: {
                    zestStyle.append("-fx-stroke-dash-array: 1 6;");
                    break;
                }
                case RADIAL: {
                    break;
                }
                case ROUNDED: {
                    break;
                }
                case SOLID: {
                    zestStyle.append("-fx-stroke-width: 1;");
                    break;
                }
                case STRIPED: {
                    break;
                }
            }
        }
    }

    private boolean hasStyle(org.eclipse.gef.graph.Node dot, NodeStyle nodeStyle) {
        Style nodeStyleParsed = DotAttributes.getStyleParsed((org.eclipse.gef.graph.Node)dot);
        if (nodeStyleParsed != null) {
            for (StyleItem styleItem : nodeStyleParsed.getStyleItems()) {
                if (!styleItem.getName().equals(nodeStyle.toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected void convertAttributes(Graph dot, Graph zest) {
        if (this.options().emulateLayout) {
            Rankdir dotRankdir;
            String dotLayout = DotAttributes.getLayout((Graph)dot);
            Object algo = null;
            algo = Layout.CIRCO.toString().equals(dotLayout) || Layout.NEATO.toString().equals(dotLayout) || Layout.TWOPI.toString().equals(dotLayout) ? new RadialLayoutAlgorithm() : (Layout.FDP.toString().equals(dotLayout) || Layout.SFDP.toString().equals(dotLayout) ? new SpringLayoutAlgorithm() : (Layout.OSAGE.toString().equals(dotLayout) ? new GridLayoutAlgorithm() : new TreeLayoutAlgorithm(Rankdir.LR.equals((Object)(dotRankdir = DotAttributes.getRankdirParsed((Graph)dot))) ? 3 : 1)));
            ZestProperties.setLayoutAlgorithm((Graph)zest, (ILayoutAlgorithm)algo);
        }
    }

    private String decodeLineBreak(String text) {
        return text.replaceAll("\\\\n", "\n");
    }

    private String decodeEscString(String escString, Edge edge) {
        org.eclipse.gef.graph.Node tail = edge.getSource();
        org.eclipse.gef.graph.Node head = edge.getTarget();
        Graph graph = edge.getGraph();
        String label = DotAttributes.getLabel((Edge)edge);
        String edgeName = DotAttributes._getName((Edge)edge);
        String tailName = tail != null ? DotAttributes._getName((org.eclipse.gef.graph.Node)tail) : null;
        String headName = head != null ? DotAttributes._getName((org.eclipse.gef.graph.Node)head) : null;
        String graphName = graph != null ? DotAttributes._getName((Graph)graph) : null;
        return escString.replaceAll("\\\\L", (label != null ? label : "").replaceAll("\\\\", "\\\\\\\\")).replaceAll("\\\\E", edgeName != null ? edgeName : "").replaceAll("\\\\T", tailName != null ? tailName : "").replaceAll("\\\\H", headName != null ? headName : "").replaceAll("\\\\G", graphName != null ? graphName : "");
    }

    private String decodeEscString(String escString, org.eclipse.gef.graph.Node node) {
        Graph graph = node.getGraph();
        String label = DotAttributes.getLabel((org.eclipse.gef.graph.Node)node);
        String nodeName = DotAttributes._getName((org.eclipse.gef.graph.Node)node);
        String graphName = graph != null ? DotAttributes._getName((Graph)graph) : null;
        return escString.replaceAll("\\\\L", (label != null ? label : "\\N").replaceAll("\\\\", "\\\\\\\\")).replaceAll("\\\\N", nodeName != null ? Matcher.quoteReplacement(nodeName) : "").replaceAll("\\\\G", graphName != null ? Matcher.quoteReplacement(graphName) : "");
    }

    public Options options() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public static final class Options {
        public boolean emulateLayout = true;
        public boolean ignorePositions = false;
        public boolean invertYAxis = false;
    }
}

