/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.jaxbindex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.internal.resource.AbstractJaxbFileResourceModel;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;

public class JaxbIndexResourceImpl
extends AbstractJaxbFileResourceModel<Vector<String>>
implements JaxbIndexResource {
    public JaxbIndexResourceImpl(IFile file) {
        super(file);
    }

    @Override
    protected Vector<String> buildState() {
        return new Vector<String>();
    }

    @Override
    protected void reload() {
        ((Vector)this.state).clear();
        super.reload();
    }

    @Override
    protected void load(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        while (line != null) {
            ((Vector)this.state).add(line.trim());
            line = reader.readLine();
        }
    }

    @Override
    public Iterable<String> getFullyQualifiedClassNames() {
        return this.packageName == null ? this.getSimpleClassNames() : this.getPrefixedClassNames();
    }

    protected Iterable<String> getSimpleClassNames() {
        return IterableTools.cloneSnapshot((List)((List)this.state));
    }

    protected Iterable<String> getPrefixedClassNames() {
        return new TransformationIterable(this.getSimpleClassNames(), (Transformer)new PrefixTransformer(String.valueOf(this.packageName) + '.'));
    }

    public JptResourceType getResourceType() {
        return RESOURCE_TYPE;
    }

    protected class PrefixTransformer
    extends TransformerAdapter<String, String> {
        protected final String prefix;

        protected PrefixTransformer(String prefix) {
            this.prefix = prefix;
        }

        public String transform(String string) {
            return String.valueOf(this.prefix) + string;
        }
    }
}

