/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.AbstractNodeViewerDropAdapter;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TSEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.swt.dnd.TransferData;

public class TSEditorDropTargetListener
extends AbstractNodeViewerDropAdapter {
    private AbstractTestCaseEditor m_editor;

    public TSEditorDropTargetListener(AbstractTestCaseEditor editor) {
        super((Viewer)editor.getTreeViewer());
        this.m_editor = editor;
        boolean scrollExpand = Plugin.getDefault().getPreferenceStore().getBoolean("TREEAUTOSCROLL_PREF_KEY");
        this.setScrollExpandEnabled(scrollExpand);
    }

    public boolean performDrop(Object data) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        Object target = this.getCurrentTarget();
        int location = this.getCurrentLocation();
        if (target == null) {
            target = this.getFallbackTarget(this.getViewer());
            location = 2;
        }
        if (target instanceof INodePO) {
            INodePO targetGuiNode = (INodePO)target;
            IStructuredSelection toDrop = transfer.getSelection();
            boolean succ = TSEditorDndSupport.performDrop(this.m_editor, toDrop, targetGuiNode, location);
            this.logDrop(toDrop, targetGuiNode, succ);
            return succ;
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        Object targetNode = target;
        if (targetNode == null) {
            targetNode = this.m_editor.getEditorHelper().getEditSupport().getWorkVersion();
        }
        return TSEditorDndSupport.validateDrop(transfer.getSource(), (Viewer)this.m_editor.getTreeViewer(), transfer.getSelection(), targetNode, true);
    }
}

