/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.messagehandling;

import org.eclipse.jubula.tools.internal.i18n.I18n;

public class Message {
    public static final String NO_DETAILS = I18n.getString("Message.noDetails");
    public static final int QUESTION = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    private String[] m_details;
    private Integer m_id;
    private String m_message;
    private int m_severity;

    public Message(Integer id, int severity, String message, String[] details) {
        this.m_id = id;
        this.m_severity = severity;
        this.m_message = message;
        this.m_details = details;
    }

    public String[] getDetails() {
        if (this.m_details == null || this.m_details.length == 0 || this.m_details[0] == null || this.m_details[0].equals("")) {
            return new String[]{NO_DETAILS};
        }
        String[] details = new String[this.m_details.length];
        int i = 0;
        while (i < details.length) {
            details[i] = I18n.getString(this.m_details[i]);
            ++i;
        }
        return details;
    }

    public String getMessage(Object[] params) {
        String message = String.valueOf(this.m_id.toString()) + ": " + I18n.getString(this.m_message, params);
        if (this.m_severity == 0) {
            message = I18n.getString(this.m_message, params);
        }
        return message;
    }

    public int getSeverity() {
        return this.m_severity;
    }

    protected Integer getId() {
        return this.m_id;
    }

    public void setDetails(String[] details) {
        this.m_details = details;
    }
}

