/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.remote.core.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class NetworkUtil {
    private NetworkUtil() {
    }

    public static String findBindedAddress(String hostName, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            InetAddress inetaddr = InetAddress.getByName(hostName);
            subMonitor.worked(2);
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface netInterface = interfaces.nextElement();
                if (!netInterface.isUp() || !inetaddr.isReachable(netInterface, 0, 2000)) continue;
                Enumeration<InetAddress> inetAddresses = netInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress nextElement = inetAddresses.nextElement();
                    if (!nextElement.isSiteLocalAddress()) continue;
                    return nextElement.getHostAddress();
                }
            }
            subMonitor.worked(1);
        }
        catch (UnknownHostException ex) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }
}

