/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.shared.FilteredCheckboxTree;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.BundleException;

public class TargetContentsGroup {
    private CachedCheckboxTreeViewer fTree;
    private MenuManager fMenuManager;
    private Button fSelectButton;
    private Button fDeselectButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Button fSelectRequiredButton;
    private Label fModeLabel;
    private Button fPluginModeButton;
    private Button fFeaureModeButton;
    private Label fShowLabel;
    private Button fShowSourceButton;
    private Button fShowPluginsButton;
    private Label fCountLabel;
    private Label fGroupLabel;
    private Combo fGroupCombo;
    private ComboPart fGroupComboPart;
    private ViewerFilter fSourceFilter;
    private ViewerFilter fPluginFilter;
    private TargetDefinition fTargetDefinition;
    private Map<IPath, List<TargetBundle>> fFileBundleMapping;
    private Set<TargetBundle> fMissing;
    private static final NameVersionDescriptor OTHER_CATEGORY = new NameVersionDescriptor(Messages.TargetContentsGroup_OtherPluginsParent, null);
    private List<TargetBundle> fAllBundles = new ArrayList<TargetBundle>();
    private int fGrouping;
    private static final int GROUP_BY_NONE = 0;
    private static final int GROUP_BY_FILE_LOC = 1;
    private static final int GROUP_BY_CONTAINER = 2;
    private ListenerList<ITargetChangedListener> fChangeListeners = new ListenerList();

    public static TargetContentsGroup createInForm(Composite parent, FormToolkit toolkit) {
        TargetContentsGroup contentTable = new TargetContentsGroup();
        contentTable.createFormContents(parent, toolkit);
        return contentTable;
    }

    public static TargetContentsGroup createInDialog(Composite parent) {
        TargetContentsGroup contentTable = new TargetContentsGroup();
        contentTable.createDialogContents(parent);
        return contentTable;
    }

    protected TargetContentsGroup() {
    }

    public void addTargetChangedListener(ITargetChangedListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    public void contentChanged() {
        for (ITargetChangedListener listener : this.fChangeListeners) {
            listener.contentsChanged((ITargetDefinition)this.fTargetDefinition, this, false, false);
        }
    }

    public void dispose() {
        if (this.fMenuManager != null) {
            this.fMenuManager.dispose();
        }
    }

    protected void createFormContents(Composite parent, FormToolkit toolkit) {
        this.fGrouping = 0;
        Composite comp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setFont(parent.getFont());
        this.createTree(comp, toolkit);
        this.createButtons(comp, toolkit);
        this.fCountLabel = toolkit.createLabel(comp, "");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fCountLabel.setLayoutData((Object)data);
        this.updateButtons();
        this.initializeFilters();
    }

    protected void createDialogContents(Composite parent) {
        this.fGrouping = 0;
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        this.createTree(comp, null);
        this.createButtons(comp, null);
        this.fCountLabel = SWTFactory.createLabel(comp, "", 2);
        this.updateButtons();
        this.initializeFilters();
    }

    private TreeViewer createTree(Composite parent, FormToolkit toolkit) {
        FilteredCheckboxTree tree = new FilteredCheckboxTree(parent, toolkit);
        tree.setLayoutData(new GridData(1808));
        tree.getPatternFilter().setIncludeLeadingWildcard(true);
        tree.getFilterControl().setFont(parent.getFont());
        this.fTree = tree.getCheckboxTreeViewer();
        ((GridData)this.fTree.getControl().getLayoutData()).heightHint = 300;
        this.fTree.getControl().setFont(parent.getFont());
        this.fTree.setUseHashlookup(true);
        this.fTree.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false){

            @Override
            public Image getImage(Object element) {
                ILabelProvider provider;
                if (element instanceof ITargetLocation && (provider = (ILabelProvider)Platform.getAdapterManager().getAdapter(element, ILabelProvider.class)) != null) {
                    return provider.getImage(element);
                }
                return super.getImage(element);
            }

            @Override
            public String getText(Object element) {
                ILabelProvider provider;
                if (element instanceof ITargetLocation && (provider = (ILabelProvider)Platform.getAdapterManager().getAdapter(element, ILabelProvider.class)) != null) {
                    return provider.getText(element);
                }
                return super.getText(element);
            }
        });
        this.fTree.addDoubleClickListener(event -> {
            Object first;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.fTree.setChecked(first, !this.fTree.getChecked(first = selection.getFirstElement()));
            this.handleTreeStateChange();
        });
        this.fTree.addCheckStateListener(event -> this.handleTreeStateChange());
        this.fTree.addSelectionChangedListener(event -> this.updateButtons());
        this.fTree.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (TargetContentsGroup.this.fFeaureModeButton.getSelection()) {
                    if (e1 == OTHER_CATEGORY) {
                        return 1;
                    }
                    if (e2 == OTHER_CATEGORY) {
                        return -1;
                    }
                }
                if (e1 instanceof TargetBundle && !(e2 instanceof TargetBundle)) {
                    return -1;
                }
                if (e2 instanceof TargetBundle && !(e1 instanceof TargetBundle)) {
                    return 1;
                }
                if (e1 instanceof TargetBundle && e2 instanceof TargetBundle) {
                    IStatus status1 = ((TargetBundle)e1).getStatus();
                    IStatus status2 = ((TargetBundle)e2).getStatus();
                    if (!status1.isOK() && status2.isOK()) {
                        return -1;
                    }
                    if (status1.isOK() && !status2.isOK()) {
                        return 1;
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fMenuManager = new MenuManager();
        this.fMenuManager.add((IAction)new Action(Messages.TargetContentsGroup_collapseAll, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL")){

            public void run() {
                TargetContentsGroup.this.fTree.collapseAll();
            }
        });
        Menu contextMenu = this.fMenuManager.createContextMenu((Control)tree);
        tree.setMenu(contextMenu);
        return this.fTree;
    }

    private void handleTreeStateChange() {
        this.saveIncludedBundleState();
        this.contentChanged();
        this.updateButtons();
        Object[] locations = this.fTargetDefinition.getTargetLocations();
        if (locations == null) {
            locations = new ITargetLocation[]{};
        }
        this.fTree.update(locations, new String[]{"org.eclipse.jface.text"});
    }

    private void createButtons(Composite parent, FormToolkit toolkit) {
        Composite buttonComp;
        if (toolkit != null) {
            buttonComp = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttonComp.setLayout((Layout)layout);
            buttonComp.setLayoutData((Object)new GridData(1040));
            this.fSelectButton = toolkit.createButton(buttonComp, Messages.IncludedBundlesTree_0, 8);
            this.fSelectButton.setLayoutData((Object)new GridData(768));
            this.fDeselectButton = toolkit.createButton(buttonComp, Messages.IncludedBundlesTree_1, 8);
            this.fDeselectButton.setLayoutData((Object)new GridData(768));
            Label emptySpace = new Label(buttonComp, 0);
            GridData gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectAllButton = toolkit.createButton(buttonComp, Messages.IncludedBundlesTree_2, 8);
            this.fSelectAllButton.setLayoutData((Object)new GridData(768));
            this.fDeselectAllButton = toolkit.createButton(buttonComp, Messages.IncludedBundlesTree_3, 8);
            this.fDeselectAllButton.setLayoutData((Object)new GridData(768));
            emptySpace = new Label(buttonComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectRequiredButton = toolkit.createButton(buttonComp, Messages.TargetContentsGroup_4, 8);
            this.fSelectRequiredButton.setLayoutData((Object)new GridData(768));
            Composite filterComp = toolkit.createComposite(buttonComp);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            filterComp.setLayout((Layout)layout);
            filterComp.setLayoutData((Object)new GridData(16384, 1024, true, true));
            this.fModeLabel = toolkit.createLabel(filterComp, Messages.TargetContentsGroup_ManageUsing);
            this.fPluginModeButton = toolkit.createButton(filterComp, Messages.TargetContentsGroup_PluginMode, 16);
            this.fPluginModeButton.setSelection(true);
            this.fFeaureModeButton = toolkit.createButton(filterComp, Messages.TargetContentsGroup_FeatureMode, 16);
            this.fFeaureModeButton.setSelection(true);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fShowLabel = toolkit.createLabel(filterComp, Messages.BundleContainerTable_9);
            this.fShowPluginsButton = toolkit.createButton(filterComp, Messages.BundleContainerTable_14, 32);
            this.fShowPluginsButton.setSelection(true);
            this.fShowSourceButton = toolkit.createButton(filterComp, Messages.BundleContainerTable_15, 32);
            this.fShowSourceButton.setSelection(true);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fGroupLabel = toolkit.createLabel(filterComp, Messages.TargetContentsGroup_0);
            this.fGroupComboPart = new ComboPart();
            this.fGroupComboPart.createControl(filterComp, toolkit, 2060);
            gd = new GridData(768);
            gd.horizontalIndent = 10;
            this.fGroupComboPart.getControl().setLayoutData((Object)gd);
            this.fGroupComboPart.setItems(new String[]{Messages.TargetContentsGroup_1, Messages.TargetContentsGroup_2, Messages.TargetContentsGroup_3});
            this.fGroupComboPart.setVisibleItemCount(30);
            this.fGroupComboPart.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleGroupChange()));
            this.fGroupComboPart.select(0);
        } else {
            buttonComp = SWTFactory.createComposite(parent, 1, 1, 1040, 0, 0);
            this.fSelectButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_0, null);
            this.fDeselectButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_1, null);
            Label emptySpace = new Label(buttonComp, 0);
            GridData gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_2, null);
            this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, Messages.IncludedBundlesTree_3, null);
            emptySpace = new Label(buttonComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fSelectRequiredButton = SWTFactory.createPushButton(buttonComp, Messages.TargetContentsGroup_4, null);
            Composite filterComp = SWTFactory.createComposite(buttonComp, 1, 1, 0, 0, 0);
            filterComp.setLayoutData((Object)new GridData(16384, 1024, true, true));
            this.fModeLabel = SWTFactory.createLabel(filterComp, Messages.TargetContentsGroup_ManageUsing, 1);
            this.fPluginModeButton = SWTFactory.createRadioButton(filterComp, Messages.TargetContentsGroup_PluginMode);
            this.fFeaureModeButton = SWTFactory.createRadioButton(filterComp, Messages.TargetContentsGroup_FeatureMode);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fShowLabel = SWTFactory.createLabel(filterComp, Messages.BundleContainerTable_9, 1);
            this.fShowPluginsButton = SWTFactory.createCheckButton(filterComp, Messages.BundleContainerTable_14, null, true, 1);
            this.fShowSourceButton = SWTFactory.createCheckButton(filterComp, Messages.BundleContainerTable_15, null, true, 1);
            emptySpace = new Label(filterComp, 0);
            gd = new GridData(2);
            gd.heightHint = 5;
            gd.widthHint = 5;
            emptySpace.setLayoutData((Object)gd);
            this.fGroupLabel = SWTFactory.createLabel(filterComp, Messages.TargetContentsGroup_0, 1);
            this.fGroupCombo = SWTFactory.createCombo(filterComp, 8, 1, new String[]{Messages.TargetContentsGroup_1, Messages.TargetContentsGroup_2, Messages.TargetContentsGroup_3});
            gd = new GridData(768);
            gd.horizontalIndent = 10;
            this.fGroupCombo.setLayoutData((Object)gd);
            this.fGroupCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleGroupChange()));
            this.fGroupCombo.select(0);
        }
        this.fSelectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.fTree.getSelection().isEmpty()) {
                Object[] selected;
                Object[] objectArray = selected = this.fTree.getStructuredSelection().toArray();
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedObject = objectArray[n2];
                    this.fTree.setChecked(selectedObject, true);
                    ++n2;
                }
                this.handleTreeStateChange();
            }
        }));
        this.fDeselectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.fTree.getSelection().isEmpty()) {
                Object[] selected;
                Object[] objectArray = selected = this.fTree.getStructuredSelection().toArray();
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedObject = objectArray[n2];
                    this.fTree.setChecked(selectedObject, false);
                    ++n2;
                }
                this.handleTreeStateChange();
            }
        }));
        this.fSelectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fTree.setAllChecked(true);
            this.handleTreeStateChange();
        }));
        this.fDeselectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fTree.setAllChecked(false);
            this.handleTreeStateChange();
        }));
        this.fSelectRequiredButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Object[] allChecked = this.fTree.getCheckedLeafElements();
            ArrayList<Object> required = new ArrayList<Object>();
            if (this.fFeaureModeButton.getSelection()) {
                required.addAll(this.getRequiredFeatures(this.fTargetDefinition.getAllFeatures(), allChecked));
            } else {
                required.addAll(this.getRequiredPlugins(this.fAllBundles, allChecked));
            }
            for (Object e2 : required) {
                this.fTree.setChecked(e2, true);
            }
            this.handleTreeStateChange();
        }));
        this.fPluginModeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fTargetDefinition.setUIMode(0);
            this.contentChanged();
            this.fTargetDefinition.setIncluded(null);
            this.fGroupLabel.setEnabled(true);
            if (this.fGroupCombo != null) {
                this.fGroupCombo.setEnabled(true);
            } else {
                this.fGroupComboPart.getControl().setEnabled(true);
            }
            this.fTree.getControl().setRedraw(false);
            this.fTree.refresh(false);
            this.fTree.expandAll();
            this.updateCheckState();
            this.updateButtons();
            this.fTree.getControl().setRedraw(true);
        }));
        this.fPluginModeButton.setSelection(true);
        GridData gd = new GridData();
        gd.horizontalIndent = 10;
        this.fPluginModeButton.setLayoutData((Object)gd);
        this.fFeaureModeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fTargetDefinition.setUIMode(1);
            this.contentChanged();
            this.fTargetDefinition.setIncluded(null);
            this.fGroupLabel.setEnabled(false);
            if (this.fGroupCombo != null) {
                this.fGroupCombo.setEnabled(false);
            } else {
                this.fGroupComboPart.getControl().setEnabled(false);
            }
            this.fTree.getControl().setRedraw(false);
            this.fTree.refresh(false);
            this.fTree.expandAll();
            this.updateCheckState();
            this.updateButtons();
            this.fTree.getControl().setRedraw(true);
        }));
        this.fFeaureModeButton.setSelection(false);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fFeaureModeButton.setLayoutData((Object)gd);
        this.fShowPluginsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.fShowPluginsButton.getSelection()) {
                this.fTree.addFilter(this.fPluginFilter);
            } else {
                this.fTree.removeFilter(this.fPluginFilter);
                this.fTree.expandAll();
                this.updateCheckState();
            }
            this.updateButtons();
        }));
        this.fShowPluginsButton.setSelection(true);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fShowPluginsButton.setLayoutData((Object)gd);
        this.fShowSourceButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!this.fShowSourceButton.getSelection()) {
                this.fTree.addFilter(this.fSourceFilter);
            } else {
                this.fTree.removeFilter(this.fSourceFilter);
                this.fTree.expandAll();
                this.updateCheckState();
            }
            this.updateButtons();
        }));
        this.fShowSourceButton.setSelection(true);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.fShowSourceButton.setLayoutData((Object)gd);
    }

    private void initializeFilters() {
        this.fSourceFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof TargetBundle) || !((TargetBundle)element).isSourceBundle();
            }
        };
        this.fPluginFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof TargetBundle) || ((TargetBundle)element).isSourceBundle();
            }
        };
    }

    private IPath getParentPath(TargetBundle bundle) {
        URI location = bundle.getBundleInfo().getLocation();
        if (location == null) {
            return new Path(Messages.TargetContentsGroup_8);
        }
        Path path = new Path(URIUtil.toUnencodedString((URI)location));
        path = path.removeLastSegments(1);
        return path;
    }

    protected Map<?, ?> loadManifest(File bundleLocation) throws IOException {
        ZipFile jarFile = null;
        InputStream manifestStream = null;
        String extension = new Path(bundleLocation.getName()).getFileExtension();
        try {
            if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    manifestStream = new FileInputStream(file);
                }
            }
            if (manifestStream == null) {
                return null;
            }
            Map map = ManifestElement.parseBundleManifest((InputStream)manifestStream, new Hashtable(10));
            return map;
        }
        catch (BundleException e) {
            PDEPlugin.log(e);
        }
        finally {
            try {
                if (manifestStream != null) {
                    manifestStream.close();
                }
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
        }
        return null;
    }

    private List<TargetBundle> getRequiredPlugins(Collection<TargetBundle> allBundles, Object[] checkedBundles) {
        HashSet dependencies = new HashSet();
        IRunnableWithProgress op = monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.TargetContentsGroup_5, (int)150);
            ArrayList<URI> allLocations = new ArrayList<URI>(allBundles.size());
            for (TargetBundle bundle1 : allBundles) {
                URI location = bundle1.getBundleInfo().getLocation();
                if (location == null) continue;
                allLocations.add(location);
            }
            if (subMonitor.isCanceled()) {
                return;
            }
            subMonitor.worked(20);
            PDEState state = new PDEState(allLocations.toArray(new URI[allLocations.size()]), true, false, (IProgressMonitor)subMonitor.split(50));
            if (subMonitor.isCanceled()) {
                return;
            }
            IPluginModelBase[] models = state.getTargetModels();
            ArrayList<IPluginModelBase> checkedModels = new ArrayList<IPluginModelBase>(checkedBundles.length);
            Object[] objectArray2 = checkedBundles;
            int n = checkedBundles.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedBundle = objectArray2[n2];
                if (checkedBundle instanceof TargetBundle) {
                    BundleInfo bundle2 = ((TargetBundle)checkedBundle).getBundleInfo();
                    IPluginModelBase[] iPluginModelBaseArray = models;
                    int n3 = models.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginModelBase model = iPluginModelBaseArray[n4];
                        if (model.getBundleDescription().getSymbolicName().equals(bundle2.getSymbolicName()) && model.getBundleDescription().getVersion().toString().equals(bundle2.getVersion())) {
                            checkedModels.add(model);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            subMonitor.worked(20);
            if (subMonitor.isCanceled()) {
                return;
            }
            NameVersionDescriptor[] implicitDependencies = this.fTargetDefinition.getImplicitDependencies();
            ArrayList<String> implicitIDs = new ArrayList<String>();
            if (implicitDependencies != null) {
                NameVersionDescriptor[] nameVersionDescriptorArray = implicitDependencies;
                int n5 = implicitDependencies.length;
                int n6 = 0;
                while (n6 < n5) {
                    NameVersionDescriptor dependency = nameVersionDescriptorArray[n6];
                    implicitIDs.add(dependency.getId());
                    ++n6;
                }
            }
            subMonitor.worked(10);
            dependencies.addAll(DependencyManager.getDependencies((Object[])checkedModels.toArray(), (String[])implicitIDs.toArray(new String[implicitIDs.size()]), (State)state.getState(), null));
            subMonitor.worked(50);
        };
        try {
            new ProgressMonitorDialog(this.fTree.getControl().getShell()).run(true, true, op);
            HashSet<String> checkedNames = new HashSet<String>(checkedBundles.length);
            Object[] objectArray = checkedBundles;
            int n = checkedBundles.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedBundle = objectArray[n2];
                if (checkedBundle instanceof TargetBundle) {
                    checkedNames.add(((TargetBundle)checkedBundle).getBundleInfo().getSymbolicName());
                }
                ++n2;
            }
            ArrayList<TargetBundle> toCheck = new ArrayList<TargetBundle>();
            for (TargetBundle bundle : this.fAllBundles) {
                if (bundle.isSourceBundle()) {
                    String name = bundle.getSourceTarget().getSymbolicName();
                    if (name == null || !dependencies.contains(name) && !checkedNames.contains(name)) continue;
                    toCheck.add(bundle);
                    continue;
                }
                if (!dependencies.contains(bundle.getBundleInfo().getSymbolicName())) continue;
                toCheck.add(bundle);
            }
            return toCheck;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return Collections.emptyList();
    }

    private Set<TargetFeature> getRequiredFeatures(TargetFeature[] allFeatures, Object[] checkedFeatures) {
        HashSet<TargetFeature> required = new HashSet<TargetFeature>();
        Object[] objectArray = checkedFeatures;
        int n = checkedFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedFeature = objectArray[n2];
            if (checkedFeature instanceof TargetFeature) {
                this.getFeatureDependencies((TargetFeature)checkedFeature, allFeatures, required);
            }
            ++n2;
        }
        return required;
    }

    private void getFeatureDependencies(TargetFeature feature, TargetFeature[] allFeatures, Set<TargetFeature> requiredFeatures) {
        NameVersionDescriptor[] dependents;
        NameVersionDescriptor[] nameVersionDescriptorArray = dependents = feature.getDependentFeatures();
        int n = dependents.length;
        int n2 = 0;
        while (n2 < n) {
            NameVersionDescriptor dependent = nameVersionDescriptorArray[n2];
            int j = 0;
            while (j < allFeatures.length) {
                if (allFeatures[j].getId().equals(dependent.getId())) {
                    if (requiredFeatures.contains(allFeatures[j])) break;
                    requiredFeatures.add(allFeatures[j]);
                    this.getFeatureDependencies(allFeatures[j], allFeatures, requiredFeatures);
                    break;
                }
                ++j;
            }
            ++n2;
        }
    }

    private void handleGroupChange() {
        int index = this.fGroupCombo != null ? this.fGroupCombo.getSelectionIndex() : this.fGroupComboPart.getSelectionIndex();
        if (index != this.fGrouping) {
            this.fGrouping = index;
            this.fTree.getControl().setRedraw(false);
            this.fTree.refresh(false);
            this.fTree.expandAll();
            this.updateCheckState();
            this.updateButtons();
            this.fTree.getControl().setRedraw(true);
        }
    }

    private void updateButtons() {
        if (this.fTargetDefinition != null && !this.fTree.getSelection().isEmpty()) {
            Object[] selection = this.fTree.getStructuredSelection().toArray();
            boolean hasResolveBundle = false;
            boolean hasParent = false;
            boolean allSelected = true;
            boolean noneSelected = true;
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                boolean checked;
                Object element = objectArray[n2];
                if (!hasResolveBundle || !hasParent) {
                    if (element instanceof TargetBundle) {
                        hasResolveBundle = true;
                    } else {
                        hasParent = true;
                    }
                }
                if (checked = this.fTree.getChecked(element)) {
                    noneSelected = false;
                } else {
                    allSelected = false;
                }
                ++n2;
            }
            this.fSelectButton.setEnabled(!allSelected && (!hasResolveBundle || !hasParent));
            this.fDeselectButton.setEnabled(!noneSelected && (!hasResolveBundle || !hasParent));
        } else {
            this.fSelectButton.setEnabled(false);
            this.fDeselectButton.setEnabled(false);
        }
        int total = this.fAllBundles.size();
        if (this.fFeaureModeButton.getSelection()) {
            if (this.fTargetDefinition == null) {
                total = 0;
            } else {
                total = this.fTargetDefinition.getAllFeatures().length;
                total += this.fTargetDefinition.getOtherBundles().length;
            }
        }
        if (this.fMissing != null) {
            total += this.fMissing.size();
        }
        this.fSelectAllButton.setEnabled(this.fTargetDefinition != null && this.fTree.getCheckedLeafCount() != total);
        this.fDeselectAllButton.setEnabled(this.fTargetDefinition != null && this.fTree.getCheckedLeafCount() != 0);
        this.fSelectRequiredButton.setEnabled(this.fTargetDefinition != null && this.fTree.getCheckedLeafCount() > 0 && this.fTree.getCheckedLeafCount() != total);
        if (this.fTargetDefinition != null) {
            this.fCountLabel.setText(MessageFormat.format((String)Messages.TargetContentsGroup_9, (Object[])new Object[]{Integer.toString(this.fTree.getCheckedLeafCount()), Integer.toString(total)}));
        } else {
            this.fCountLabel.setText("");
        }
    }

    public void setInput(ITargetDefinition input) {
        this.fFileBundleMapping = null;
        this.fAllBundles.clear();
        if (this.fMissing != null) {
            this.fMissing.clear();
            this.fMissing = null;
        }
        if (!(input instanceof TargetDefinition)) {
            this.setEnabled(false);
            return;
        }
        this.fTargetDefinition = (TargetDefinition)input;
        if (!input.isResolved()) {
            this.fTree.setInput(Messages.TargetContentsGroup_10);
            this.setEnabled(false);
            return;
        }
        TargetBundle[] allResolvedBundles = input.getAllBundles();
        if (allResolvedBundles == null || allResolvedBundles.length == 0) {
            this.fTree.setInput(Messages.TargetContentsGroup_11);
            this.setEnabled(false);
            return;
        }
        TargetBundle[] targetBundleArray = allResolvedBundles;
        int n = allResolvedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle bundle = targetBundleArray[n2];
            if (bundle.getBundleInfo().getSymbolicName() != null) {
                this.fAllBundles.add(bundle);
            }
            ++n2;
        }
        boolean isFeatureMode = this.fTargetDefinition.getUIMode() == 1;
        this.fFeaureModeButton.setSelection(isFeatureMode);
        this.fPluginModeButton.setSelection(!isFeatureMode);
        this.fGroupLabel.setEnabled(!isFeatureMode);
        this.fTree.getControl().setRedraw(false);
        this.fTree.setInput(this.fTargetDefinition);
        this.fTree.expandAll();
        this.updateCheckState();
        this.updateButtons();
        this.setEnabled(true);
        this.fTree.getControl().setRedraw(true);
    }

    private void updateCheckState() {
        ArrayList<TargetBundle> result = new ArrayList<TargetBundle>();
        if (this.fMissing != null) {
            result.addAll(this.fMissing);
        }
        if (this.fFeaureModeButton.getSelection()) {
            result.addAll(this.fTargetDefinition.getFeaturesAndBundles());
        } else {
            TargetBundle[] bundles;
            TargetBundle[] targetBundleArray = bundles = this.fTargetDefinition.getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                TargetBundle bundle = targetBundleArray[n2];
                if (bundle.getStatus().isOK()) {
                    result.add(bundle);
                }
                ++n2;
            }
        }
        this.fTree.setCheckedElements(result.toArray());
    }

    public void setCancelled() {
        this.fTargetDefinition = null;
        this.fTree.setInput(Messages.TargetContentsGroup_resolveCancelled);
        this.setEnabled(false);
    }

    private Map<IPath, List<TargetBundle>> getFileBundleMapping() {
        if (this.fFileBundleMapping != null) {
            return this.fFileBundleMapping;
        }
        this.fFileBundleMapping = new HashMap<IPath, List<TargetBundle>>();
        for (TargetBundle currentBundle : this.fAllBundles) {
            IPath parentPath = this.getParentPath(currentBundle);
            List<TargetBundle> bundles = this.fFileBundleMapping.get(parentPath);
            if (bundles == null) {
                bundles = new ArrayList<TargetBundle>();
                bundles.add(currentBundle);
                this.fFileBundleMapping.put(parentPath, bundles);
                continue;
            }
            bundles.add(currentBundle);
        }
        return this.fFileBundleMapping;
    }

    private Object[] getBundleChildren(Object parent) {
        List<TargetBundle> bundles;
        Object[] result = null;
        if (parent == null) {
            result = this.fAllBundles.toArray();
        } else if (this.fFeaureModeButton.getSelection() && parent == OTHER_CATEGORY) {
            result = this.fTargetDefinition.getOtherBundles();
        } else if (this.fGrouping == 2 && parent instanceof ITargetLocation) {
            ITargetLocation container = (ITargetLocation)parent;
            result = container.getBundles();
        } else if (this.fGrouping == 1 && parent instanceof IPath && (bundles = this.getFileBundleMapping().get(parent)) != null && !bundles.isEmpty()) {
            result = bundles.toArray();
        }
        if (result == null) {
            return new Object[0];
        }
        return result;
    }

    public boolean isFeatureModeEnabled() {
        if (this.fFeaureModeButton != null) {
            return this.fFeaureModeButton.getSelection();
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.fTree.getControl().setEnabled(enabled);
        if (enabled) {
            this.updateButtons();
        } else {
            this.fSelectButton.setEnabled(false);
            this.fSelectAllButton.setEnabled(false);
            this.fDeselectButton.setEnabled(false);
            this.fDeselectAllButton.setEnabled(false);
            this.fSelectRequiredButton.setEnabled(false);
            this.fCountLabel.setText("");
        }
        this.fModeLabel.setEnabled(enabled);
        this.fPluginModeButton.setEnabled(enabled);
        this.fFeaureModeButton.setEnabled(enabled);
        this.fShowLabel.setEnabled(enabled);
        this.fShowPluginsButton.setEnabled(enabled);
        this.fShowSourceButton.setEnabled(enabled);
        boolean isPluginMode = !this.fFeaureModeButton.getSelection();
        this.fGroupLabel.setEnabled(enabled && isPluginMode);
        if (this.fGroupCombo != null) {
            this.fGroupCombo.setEnabled(enabled && isPluginMode);
        } else {
            this.fGroupComboPart.setEnabled(enabled && isPluginMode);
        }
    }

    public void saveIncludedBundleState() {
        if (this.fFeaureModeButton.getSelection()) {
            Object[] checked;
            ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
            int missingCount = 0;
            Object[] objectArray = checked = this.fTree.getCheckedLeafElements();
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedElement = objectArray[n2];
                if (checkedElement instanceof TargetFeature) {
                    included.add(new NameVersionDescriptor(((TargetFeature)checkedElement).getId(), null, "feature"));
                }
                if (checkedElement instanceof TargetBundle) {
                    if (((TargetBundle)checkedElement).getStatus().getCode() == 100) {
                        included.add(new NameVersionDescriptor(((TargetBundle)checkedElement).getBundleInfo().getSymbolicName(), null, "plugin"));
                        ++missingCount;
                    } else if (((TargetBundle)checkedElement).getStatus().getCode() == 110) {
                        included.add(new NameVersionDescriptor(((TargetBundle)checkedElement).getBundleInfo().getSymbolicName(), null, "feature"));
                        ++missingCount;
                    } else {
                        included.add(new NameVersionDescriptor(((TargetBundle)checkedElement).getBundleInfo().getSymbolicName(), null));
                    }
                }
                ++n2;
            }
            if (included.isEmpty()) {
                this.fTargetDefinition.setIncluded(new NameVersionDescriptor[0]);
            } else if (included.isEmpty() || included.size() - missingCount == this.fTargetDefinition.getAllFeatures().length + this.fTargetDefinition.getOtherBundles().length) {
                this.fTargetDefinition.setIncluded(null);
            } else {
                this.fTargetDefinition.setIncluded(included.toArray(new NameVersionDescriptor[included.size()]));
            }
        } else {
            Object[] checked;
            HashSet<String> multi = new HashSet<String>();
            HashSet<String> all = new HashSet<String>();
            for (TargetBundle bundle : this.fAllBundles) {
                if (all.add(bundle.getBundleInfo().getSymbolicName())) continue;
                multi.add(bundle.getBundleInfo().getSymbolicName());
            }
            ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
            Object[] objectArray = checked = this.fTree.getCheckedLeafElements();
            int n = checked.length;
            int n3 = 0;
            while (n3 < n) {
                String bsn;
                Object checkedElement = objectArray[n3];
                if (checkedElement instanceof TargetBundle && (bsn = ((TargetBundle)checkedElement).getBundleInfo().getSymbolicName()) != null) {
                    NameVersionDescriptor info = null;
                    info = multi.contains(bsn) ? new NameVersionDescriptor(bsn, ((TargetBundle)checkedElement).getBundleInfo().getVersion()) : new NameVersionDescriptor(bsn, null);
                    included.add(info);
                }
                ++n3;
            }
            if (included.isEmpty()) {
                this.fTargetDefinition.setIncluded(new NameVersionDescriptor[0]);
            } else if (included.size() == this.fAllBundles.size() + this.fMissing.size()) {
                this.fTargetDefinition.setIncluded(null);
            } else {
                this.fTargetDefinition.setIncluded(included.toArray(new NameVersionDescriptor[included.size()]));
            }
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return TargetContentsGroup.this.getBundleChildren(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (TargetContentsGroup.this.fFeaureModeButton.getSelection() && element == OTHER_CATEGORY) {
                return true;
            }
            if (TargetContentsGroup.this.fGrouping == 0 || element instanceof TargetBundle) {
                return false;
            }
            if (element instanceof ITargetLocation || element instanceof IPath) {
                return TargetContentsGroup.this.getBundleChildren(element).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITargetDefinition) {
                ArrayList<Object> result = new ArrayList<Object>();
                if (TargetContentsGroup.this.fMissing == null || TargetContentsGroup.this.fMissing.isEmpty()) {
                    TargetContentsGroup.this.fMissing = new HashSet();
                    TargetBundle[] bundles = TargetContentsGroup.this.fTargetDefinition.getBundles();
                    int i = 0;
                    while (i < bundles.length) {
                        if (!bundles[i].getStatus().isOK() && bundles[i].getBundleInfo().getSymbolicName() != null) {
                            TargetContentsGroup.this.fMissing.add(bundles[i]);
                        }
                        ++i;
                    }
                    result.addAll(TargetContentsGroup.this.fMissing);
                } else {
                    result.addAll(TargetContentsGroup.this.fMissing);
                }
                if (TargetContentsGroup.this.fFeaureModeButton.getSelection()) {
                    TargetFeature[] features = TargetContentsGroup.this.fTargetDefinition.getAllFeatures();
                    result.addAll(Arrays.asList(features));
                    if (TargetContentsGroup.this.fTargetDefinition.getOtherBundles().length > 0) {
                        result.add(OTHER_CATEGORY);
                    }
                } else if (TargetContentsGroup.this.fGrouping == 2 && TargetContentsGroup.this.fTargetDefinition.getTargetLocations() != null) {
                    result.addAll(Arrays.asList(TargetContentsGroup.this.fTargetDefinition.getTargetLocations()));
                } else if (TargetContentsGroup.this.fGrouping == 0) {
                    TargetBundle[] allBundles;
                    TargetBundle[] targetBundleArray = allBundles = TargetContentsGroup.this.fTargetDefinition.getAllBundles();
                    int n = allBundles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TargetBundle bundle = targetBundleArray[n2];
                        if (bundle.getStatus().isOK()) {
                            result.add(bundle);
                        }
                        ++n2;
                    }
                } else {
                    result.addAll(Arrays.asList(TargetContentsGroup.this.getFileBundleMapping().keySet().toArray()));
                }
                return result.toArray();
            }
            return new Object[]{inputElement};
        }
    }
}

