/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeString;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueString;
import org.eclipse.ptp.internal.debug.core.pdi.aif.AIFTypeString;
import org.eclipse.ptp.internal.debug.core.pdi.aif.AIFValue;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFValueString
extends AIFValue
implements IAIFValueString {
    public AIFValueString(IAIFTypeString type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
        ((AIFTypeString)type).setSizeof(this.sizeof());
    }

    @Override
    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        this.setSize(this.getSize(buffer));
        byte[] bytes = new byte[this.sizeof()];
        int i = 0;
        while (i < this.sizeof()) {
            bytes[i] = buffer.get();
            ++i;
        }
        this.setResult(new String(bytes));
    }

    public int getSize(AIFFactory.SimpleByteBuffer buffer) {
        String hex = "";
        int i = 0;
        while (i < 2) {
            hex = String.valueOf(hex) + Integer.toHexString(256 + (buffer.get() & 0xFF)).substring(1);
            ++i;
        }
        try {
            return Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    public String getValueString() throws AIFException {
        if (this.getResult() == null) {
            return "";
        }
        return this.getResult();
    }

    public static void main(String[] args) {
        int length = 30;
        byte[] bytes = new byte[]{(byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        System.err.println("---- bytes: " + bytes);
        String hex = "";
        int i = 0;
        while (i < 2) {
            hex = String.valueOf(hex) + Integer.toHexString(256 + (bytes[i] & 0xFF));
            System.err.println("hex: " + hex);
            ++i;
        }
        int test = 0;
        try {
            test = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            test = -1;
        }
        System.out.println("---- test: " + test);
    }
}

