/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.commons.Q7ContainerContentProvider;
import org.eclipse.rcptt.ui.panels.Actions;
import org.eclipse.rcptt.ui.wizards.LocationComposite;
import org.eclipse.rcptt.ui.wizards.NewQ7ProjectWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.newresource.BasicNewFolderResourceWizard;

public class Q7ContainerSelectionGroup
extends Composite {
    private Listener listener;
    private IContainer selectedContainer;
    DataBindingContext dbc = new DataBindingContext();
    private TreeViewer treeViewer;

    public Q7ContainerSelectionGroup(Composite parent, Listener listener, String message, int heightHint, int widthHint) {
        super(parent, 0);
        this.listener = listener;
        this.createContents(message, heightHint, widthHint);
    }

    public void containerSelectionChanged(IContainer container) {
        this.selectedContainer = container;
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message, int heightHint, int widthHint) {
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    private void createNewFolder() {
        BasicNewFolderResourceWizard wizard = new BasicNewFolderResourceWizard();
        IWorkbench workbench = PlatformUI.getWorkbench();
        wizard.init(workbench, (IStructuredSelection)new StructuredSelection((Object)ResourcesPlugin.getWorkspace().getRoot()));
        wizard.setWindowTitle(Messages.Q7ContainerSelectionGroup_NewFolder_WindowTitle);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)this.treeViewer.getSelection());
        WizardDialog dialog = new WizardDialog(this.getParent().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            ISelection selection = this.treeViewer.getSelection();
            this.treeViewer.refresh();
            this.treeViewer.setSelection(selection);
        }
    }

    private void createNewProject() {
        IProject newProject;
        NewQ7ProjectWizard wizard = new NewQ7ProjectWizard();
        IWorkbench workbench = PlatformUI.getWorkbench();
        wizard.init(workbench, (IStructuredSelection)new StructuredSelection((Object)ResourcesPlugin.getWorkspace().getRoot()));
        wizard.setWindowTitle(Messages.Q7ContainerSelectionGroup_NewQ7Project_WindowTitle);
        WizardDialog dialog = new WizardDialog(this.getParent().getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (newProject = wizard.getNewProject()) != null) {
            this.treeViewer.refresh();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newProject));
        }
    }

    protected void createTreeViewer(int heightHint) {
        LocationComposite drillDown = new LocationComposite(this, 0){

            @Override
            public void fillToolItems(ToolBarManager toolBarMgr) {
                Action newProject = new Action(Messages.Q7ContainerSelectionGroup_NewProject_ActionName){

                    public void run() {
                        Q7ContainerSelectionGroup.this.createNewProject();
                    }
                };
                newProject.setImageDescriptor(Images.getImageDescriptor("icons/newProject.gif"));
                toolBarMgr.add((IAction)newProject);
                Action newFolder = new Action(Messages.Q7ContainerSelectionGroup_NewFolder_ActionName){

                    public void run() {
                        Q7ContainerSelectionGroup.this.createNewFolder();
                    }
                };
                newFolder.setImageDescriptor(Images.getImageDescriptor("icons/newFolder.gif"));
                toolBarMgr.add((IAction)newFolder);
                DeleteResourceAction deleteAction = new DeleteResourceAction((IShellProvider)new SameShellProvider((Control)this)){

                    public void run() {
                        super.run();
                        Q7ContainerSelectionGroup.this.treeViewer.refresh();
                    }
                };
                deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
                deleteAction.setText("");
                deleteAction.setEnabled(false);
                toolBarMgr.add((IAction)deleteAction);
                Q7ContainerSelectionGroup.this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)deleteAction);
                toolBarMgr.add((IContributionItem)new Separator());
                UpdateValueStrategy enablement = new UpdateValueStrategy(){

                    public Object convert(Object value) {
                        if (value != null) {
                            return true;
                        }
                        return false;
                    }
                };
                Q7ContainerSelectionGroup.this.dbc.bindValue(Actions.observeEnabled((IAction)newFolder), (IObservableValue)ViewersObservables.observeSingleSelection((Viewer)Q7ContainerSelectionGroup.this.treeViewer), null, enablement);
            }
        };
        GridData spec = new GridData(4, -1, true, false);
        spec.widthHint = 300;
        drillDown.setLayoutData(spec);
        this.treeViewer = new TreeViewer((Composite)this, 2048);
        drillDown.setChildTree(this.treeViewer);
        Q7ContainerContentProvider cp = new Q7ContainerContentProvider();
        cp.showClosedProjects(false);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Q7ContainerSelectionGroup.this.containerSelectionChanged((IContainer)selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item == null) {
                        return;
                    }
                    if (Q7ContainerSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        Q7ContainerSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        Q7ContainerSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getContainerFullPath() {
        if (this.selectedContainer == null) {
            return null;
        }
        return this.selectedContainer.getFullPath();
    }

    public void setInitialFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setSelectedContainer(IContainer container) {
        this.selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }
}

