/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ItemHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableItemHandler
extends ItemHandler {
    private static TableItemHandler instance;

    public static TableItemHandler getInstance() {
        if (instance == null) {
            instance = new TableItemHandler();
        }
        return instance;
    }

    public boolean isSelected(final TableItem tableItem) {
        boolean selectionState = (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                TableItem[] tableItemArray = tableItem.getParent().getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem i = tableItemArray[n2];
                    if (i.equals(tableItem)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        return selectionState;
    }

    public String getText(final TableItem tableItem, final int cellIndex) {
        String text = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return tableItem.getText(cellIndex);
            }
        });
        return text;
    }

    public void select(final TableItem swtTableItem) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTableItem.getParent().setFocus();
                swtTableItem.getParent().setSelection(swtTableItem);
                TableItemHandler.this.notifyItem(13, 0, (Widget)swtTableItem.getParent(), (Widget)swtTableItem);
            }
        });
    }

    public void setChecked(final TableItem swtTableItem, final boolean check) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((swtTableItem.getParent().getStyle() & 0x20) != 32) {
                    throw new CoreLayerException("Unable to check table item " + swtTableItem.getText() + " because table does not have SWT.CHECK style");
                }
            }
        });
        final TableCheckListener listener = new TableCheckListener();
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTableItem.getParent().addListener(13, (Listener)listener);
            }
        });
        try {
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    swtTableItem.setChecked(check);
                    swtTableItem.getParent().update();
                }
            });
            new WaitUntil((WaitCondition)new TableHeardCheckNotification(swtTableItem, listener), TimePeriod.SHORT);
        }
        catch (Throwable throwable) {
            Display.syncExec((Runnable)new Runnable(swtTableItem, listener){
                private final /* synthetic */ TableItem val$swtTableItem;
                private final /* synthetic */ TableCheckListener val$listener;
                {
                    this.val$swtTableItem = tableItem;
                    this.val$listener = tableCheckListener;
                }

                @Override
                public void run() {
                    this.val$swtTableItem.getParent().removeListener(13, (Listener)this.val$listener);
                }
            });
            throw throwable;
        }
        Display.syncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
    }

    public boolean isChecked(final TableItem swtTableItem) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return swtTableItem.getChecked();
            }
        });
    }

    public Image getImage(final TableItem tableItem, final int imageIndex) {
        return (Image)Display.syncExec((ResultRunnable)new ResultRunnable<Image>(){

            public Image run() {
                return tableItem.getImage(imageIndex);
            }
        });
    }

    public Table getParent(final TableItem table) {
        return (Table)Display.syncExec((ResultRunnable)new ResultRunnable<Table>(){

            public Table run() {
                return table.getParent();
            }
        });
    }

    public void setFocus(TableItem tableItem) {
        ControlHandler.getInstance().setFocus((Control)this.getParent(tableItem));
    }

    public boolean isGrayed(final TableItem tableItem) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return tableItem.getGrayed();
            }
        });
    }

    public void setDefaultSelection(final TableItem tableItem) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                TableItemHandler.this.select(tableItem);
                TableItemHandler.this.notifyItem(14, 0, (Widget)tableItem.getParent(), (Widget)tableItem);
            }
        });
    }

    public void click(final TableItem tableItem, final int column) {
        this.select(tableItem);
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Rectangle rectangle = tableItem.getBounds(column);
                int x = rectangle.x + rectangle.width / 2;
                int y = rectangle.y + rectangle.height / 2;
                TableItemHandler.this.notifyItemMouse(3, 0, (Widget)tableItem.getParent(), (Widget)tableItem, x, y, 1);
                TableItemHandler.this.notifyItemMouse(4, 0, (Widget)tableItem.getParent(), (Widget)tableItem, x, y, 1);
            }
        });
    }

    public void doubleClick(final TableItem tableItem, final int column) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                TableItemHandler.this.select(tableItem);
                Rectangle rectangle = tableItem.getBounds(column);
                int x = rectangle.x + rectangle.width / 2;
                int y = rectangle.y + rectangle.height / 2;
                TableItemHandler.this.notifyItemMouse(8, 0, (Widget)tableItem.getParent(), (Widget)tableItem, x, y, 1);
            }
        });
    }

    private class TableCheckListener
    implements Listener {
        private boolean heard = false;

        private TableCheckListener() {
        }

        public void handleEvent(Event arg0) {
            this.heard = true;
        }

        public boolean isHeard() {
            return this.heard;
        }
    }

    private class TableHeardCheckNotification
    extends AbstractWaitCondition {
        private TableItem tableItem;
        private TableCheckListener listener;

        public TableHeardCheckNotification(TableItem tableItem, TableCheckListener listener) {
            this.tableItem = tableItem;
            this.listener = listener;
        }

        public boolean test() {
            TableItemHandler.this.notifyItem(13, 32, (Widget)TableItemHandler.this.getParent(this.tableItem), (Widget)this.tableItem);
            return this.listener.isHeard();
        }

        public String description() {
            return "table heard check notification";
        }
    }
}

