/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.operations;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.IContainerMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DSemanticDiagramHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementSpecOperations;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.DragSource;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public final class DDiagramElementContainerSpecOperations {
    private DDiagramElementContainerSpecOperations() {
    }

    public static Collection<AbstractDNode> getNodes(DDiagramElementContainer container) {
        ArrayList<AbstractDNode> result = new ArrayList<AbstractDNode>();
        for (DDiagramElement elem : container.getElements()) {
            if (elem instanceof DNode) {
                result.add((DNode)elem);
                DNode node = (DNode)elem;
                for (DNode borderNode : node.getOwnedBorderedNodes()) {
                    result.add(borderNode);
                }
            } else if (elem instanceof DNodeListElement) {
                result.add((DNodeListElement)elem);
            }
            if (!(elem instanceof DDiagramElementContainer)) continue;
            DDiagramElementContainerSpecOperations.addViewNodes((DDiagramElementContainer)elem, result);
        }
        return result;
    }

    private static void addViewNodes(DDiagramElementContainer elem, Collection<AbstractDNode> result) {
        block5: {
            block4: {
                if (!(elem instanceof DNodeContainer)) break block4;
                DNodeContainer container = (DNodeContainer)elem;
                result.addAll((Collection<AbstractDNode>)container.getOwnedBorderedNodes());
                for (DDiagramElement subElem : container.getOwnedDiagramElements()) {
                    if (subElem instanceof DNode) {
                        result.add((DNode)subElem);
                    }
                    if (!(subElem instanceof DDiagramElementContainer)) continue;
                    DDiagramElementContainerSpecOperations.addViewNodes((DDiagramElementContainer)subElem, result);
                }
                break block5;
            }
            if (!(elem instanceof DNodeList)) break block5;
            DNodeList container = (DNodeList)elem;
            for (DDiagramElement subElem : container.getOwnedElements()) {
                if (subElem instanceof DNode) {
                    result.add((DNode)subElem);
                }
                if (!(subElem instanceof DDiagramElementContainer)) continue;
                DDiagramElementContainerSpecOperations.addViewNodes((DDiagramElementContainer)subElem, result);
            }
        }
    }

    public static Collection<DDiagramElementContainer> getContainers(DDiagramElementContainer container) {
        ArrayList<DDiagramElementContainer> result = new ArrayList<DDiagramElementContainer>();
        for (DDiagramElement elem : container.getElements()) {
            if (elem instanceof DDiagramElementContainer) {
                result.add((DDiagramElementContainer)elem);
            }
            if (!(elem instanceof DNodeContainer)) continue;
            DDiagramElementContainerSpecOperations.addSiriusElementContainers((DNodeContainer)elem, result);
        }
        return result;
    }

    private static void addSiriusElementContainers(DNodeContainer container, Collection<DDiagramElementContainer> result) {
        for (DDiagramElement elem : container.getOwnedDiagramElements()) {
            if (elem instanceof DDiagramElementContainer) {
                result.add((DDiagramElementContainer)elem);
            }
            if (!(elem instanceof DNodeContainer)) continue;
            DDiagramElementContainerSpecOperations.addSiriusElementContainers((DNodeContainer)elem, result);
        }
    }

    public static EList<DDiagramElement> getElements(DDiagramElementContainer container) {
        return new BasicEList();
    }

    public static EList<DNode> getNodesFromMapping(DDiagramElementContainer container, NodeMapping mapping) {
        BasicEList result = new BasicEList();
        for (DNode node : container.getNodes()) {
            if (node.getMapping() != mapping) continue;
            result.add((Object)node);
        }
        return result;
    }

    public static EList<DDiagramElementContainer> getContainersFromMapping(DDiagramElementContainer current, ContainerMapping mapping) {
        BasicEList result = new BasicEList();
        for (DDiagramElementContainer container : DDiagramElementContainerSpecOperations.getContainers(current)) {
            if (container.getActualMapping() != mapping) continue;
            result.add((Object)container);
        }
        return result;
    }

    public static DDiagram getParentDiagram(DDiagramElementContainer container) {
        return DDiagramElementSpecOperations.getParentDiagram(container);
    }

    public static boolean validate(DDiagramElementContainer container) {
        ContainerMapping actualMapping = container.getActualMapping();
        if (actualMapping != null && container.getTarget() != null && DDiagramElementContainerSpecOperations.getFirstParentWithSemantic(container) != null) {
            EObject mySemanticElement = container.getTarget();
            DSemanticDecorator representedParent = DDiagramElementContainerSpecOperations.getFirstParentWithSemantic(container);
            EObject representedParentSemantic = DDiagramElementContainerSpecOperations.getFirstParentWithSemantic(container).getTarget();
            if (representedParent instanceof DSemanticDiagram) {
                representedParentSemantic = DSemanticDiagramHelper.getRootContent((DSemanticDiagram)representedParent);
            }
            if (!ContainerMappingHelper.getNodesCandidates((IContainerMappingExt)actualMapping, representedParentSemantic, representedParent.getTarget(), (EObject)container).contains((Object)mySemanticElement)) {
                return false;
            }
        }
        return true;
    }

    public static DSemanticDecorator getFirstParentWithSemantic(DDiagramElementContainer container) {
        DSemanticDecorator result = null;
        EObject cur = container.eContainer();
        while (cur != null && result == null) {
            if (cur instanceof DSemanticDecorator) {
                result = (DSemanticDecorator)cur;
            }
            cur = cur.eContainer();
        }
        return result;
    }

    public static DragAndDropTargetDescription getDragAndDropDescription(DDiagramElementContainer self) {
        return self.getActualMapping();
    }

    public static ContainerDropDescription getBestDropDescription(DragAndDropTargetDescription description, EObject droppedElement, EObject oldContainer, EObject newContainer, EObject newViewContainer, DragSource dragSource, EObject droppedDiagramElement) {
        DDiagram diagram = newViewContainer instanceof DDiagram ? (DDiagram)newViewContainer : ((DDiagramElement)newViewContainer).getParentDiagram();
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(droppedElement);
        if (oldContainer != null) {
            interpreter.setVariable("oldContainer", (Object)oldContainer);
        }
        interpreter.setVariable("newContainer", (Object)newContainer);
        interpreter.setVariable("newViewContainer", (Object)newViewContainer);
        interpreter.setVariable("element", (Object)droppedElement);
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        ContainerDropDescription bestDropDescription = null;
        ArrayList<ContainerDropDescription> candidates = new ArrayList<ContainerDropDescription>();
        for (ContainerDropDescription dropTool : DDiagramElementContainerSpecOperations.getDropToolsOnActivatedLayers(diagram, description)) {
            if (!DDiagramElementContainerSpecOperations.checkDragSource(dropTool, dragSource) || !DDiagramElementContainerSpecOperations.checkDroppedDiagramElement(dropTool, droppedDiagramElement, newViewContainer) || !DDiagramElementContainerSpecOperations.checkPrecondition(dropTool, safeInterpreter, droppedElement)) continue;
            candidates.add(dropTool);
        }
        for (ContainerDropDescription dropTool : candidates) {
            if (dropTool.getBestMapping((DragAndDropTarget)newViewContainer, droppedElement) == null) continue;
            if (bestDropDescription == null) {
                bestDropDescription = dropTool;
                continue;
            }
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DDiagramElementContainerSpecOperations_tooMuchDropDescErrorMsg, droppedElement, bestDropDescription.getName(), dropTool), (Exception)new RuntimeException());
        }
        if (dragSource == DragSource.PROJECT_EXPLORER_LITERAL && bestDropDescription == null && !candidates.isEmpty()) {
            bestDropDescription = (ContainerDropDescription)candidates.toArray()[0];
        }
        return bestDropDescription;
    }

    private static boolean checkDragSource(ContainerDropDescription dropTool, DragSource dragSource) {
        return dropTool.getDragSource() == DragSource.BOTH_LITERAL || dropTool.getDragSource() == dragSource;
    }

    private static boolean checkDroppedDiagramElement(ContainerDropDescription dropTool, EObject droppedDiagramElement, EObject newViewContainer) {
        boolean valid = true;
        if (droppedDiagramElement instanceof DDiagramElement) {
            valid = droppedDiagramElement.equals(newViewContainer) ? dropTool.getContainers().contains((Object)((DDiagramElement)droppedDiagramElement).getMapping()) : dropTool.getMappings().contains((Object)((DDiagramElement)droppedDiagramElement).getMapping());
        }
        return valid;
    }

    private static boolean checkPrecondition(ContainerDropDescription dropTool, RuntimeLoggerInterpreter safeInterpreter, EObject droppedElement) {
        String precondition = dropTool.getPrecondition();
        if (precondition != null && !StringUtil.isEmpty((String)precondition.trim())) {
            return safeInterpreter.evaluateBoolean(droppedElement, (EObject)dropTool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
        }
        return true;
    }

    private static Collection<ContainerDropDescription> getDropToolsOnActivatedLayers(DDiagram diagram, DragAndDropTargetDescription mapping) {
        if (diagram.getDescription().getDefaultLayer() != null) {
            HashSet<AbstractToolDescription> allActivatedTools = new HashSet<AbstractToolDescription>();
            allActivatedTools.addAll((Collection<AbstractToolDescription>)diagram.getDescription().getDefaultLayer().getAllTools());
            for (Layer layer : new DDiagramQuery(diagram).getAllActivatedLayers()) {
                allActivatedTools.addAll((Collection<AbstractToolDescription>)layer.getAllTools());
            }
            Collection<ContainerDropDescription> dropTools = DDiagramElementContainerSpecOperations.getDropTools(mapping);
            dropTools.retainAll(allActivatedTools);
            return dropTools;
        }
        return DDiagramElementContainerSpecOperations.getDropTools(mapping);
    }

    private static Collection<ContainerDropDescription> getDropTools(DragAndDropTargetDescription mapping) {
        HashSet dropTools = mapping instanceof DiagramElementMapping ? Sets.newHashSet(new DiagramElementMappingQuery((DiagramElementMapping)((Object)mapping)).getDropTools()) : Sets.newHashSet(mapping.getDropDescriptions());
        return dropTools;
    }
}

