/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.construction.plancompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.EnumerablePConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.construction.plancompiler.ReteRecipeCompiler;
import org.eclipse.viatra.query.runtime.rete.recipes.EqualityFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerBasedAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.JoinRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.Mask;
import org.eclipse.viatra.query.runtime.rete.recipes.MonotonicityInfo;
import org.eclipse.viatra.query.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.RecipesFactory;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.SingleColumnAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.TrimmerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.helper.RecipesHelper;
import org.eclipse.viatra.query.runtime.rete.traceability.CompiledQuery;
import org.eclipse.viatra.query.runtime.rete.traceability.PlanningTrace;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;
import org.eclipse.viatra.query.runtime.rete.util.ReteHintOptions;

public class CompilerHelper {
    static final RecipesFactory FACTORY = RecipesFactory.eINSTANCE;

    private CompilerHelper() {
    }

    public static PlanningTrace checkAndTrimEqualVariables(SubPlan plan, PlanningTrace coreTrace) {
        int distinctVariables;
        List<PVariable> coreVariablesTuple = coreTrace.getVariablesTuple();
        int constraintArity = coreVariablesTuple.size();
        if (constraintArity == (distinctVariables = coreTrace.getPosMapping().size())) {
            return coreTrace;
        }
        HashMap<PVariable, TreeSet<Integer>> posMultimap = new HashMap<PVariable, TreeSet<Integer>>();
        ArrayList<PVariable> trimmedVariablesTuple = new ArrayList<PVariable>(distinctVariables);
        int[] trimIndices = new int[distinctVariables];
        int i = 0;
        while (i < constraintArity) {
            PVariable variable = coreVariablesTuple.get(i);
            TreeSet<Integer> indexSet = (TreeSet<Integer>)posMultimap.get(variable);
            if (indexSet == null) {
                indexSet = new TreeSet<Integer>();
                posMultimap.put(variable, indexSet);
                trimIndices[trimmedVariablesTuple.size()] = i;
                trimmedVariablesTuple.add(variable);
            }
            indexSet.add(i);
            ++i;
        }
        PlanningTrace lastTrace = coreTrace;
        for (Map.Entry entry : posMultimap.entrySet()) {
            if (((SortedSet)entry.getValue()).size() <= 1) continue;
            EqualityFilterRecipe equalityFilterRecipe = FACTORY.createEqualityFilterRecipe();
            equalityFilterRecipe.setParent(lastTrace.getRecipe());
            equalityFilterRecipe.getIndices().addAll((Collection)entry.getValue());
            lastTrace = new PlanningTrace(plan, coreVariablesTuple, (ReteNodeRecipe)equalityFilterRecipe, lastTrace);
        }
        TrimmerRecipe trimmerRecipe = FACTORY.createTrimmerRecipe();
        trimmerRecipe.setParent(lastTrace.getRecipe());
        trimmerRecipe.setMask(RecipesHelper.mask((int)constraintArity, (int[])trimIndices));
        return new PlanningTrace(plan, trimmedVariablesTuple, (ReteNodeRecipe)trimmerRecipe, lastTrace);
    }

    public static List<PVariable> convertVariablesTuple(EnumerablePConstraint constraint) {
        return CompilerHelper.convertVariablesTuple(constraint.getVariablesTuple());
    }

    public static List<PVariable> convertVariablesTuple(Tuple variablesTuple) {
        ArrayList<PVariable> result = new ArrayList<PVariable>();
        Object[] objectArray = variablesTuple.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            result.add((PVariable)o);
            ++n2;
        }
        return result;
    }

    public static RecipeTraceInfo makeIndexerTrace(SubPlan planToCompile, PlanningTrace parentTrace, TupleMask mask) {
        ReteNodeRecipe parentRecipe = parentTrace.getRecipe();
        if (parentRecipe instanceof IndexerBasedAggregatorRecipe || parentRecipe instanceof SingleColumnAggregatorRecipe) {
            throw new IllegalArgumentException("Cannot take projection indexer of aggregator node at plan " + planToCompile);
        }
        ProjectionIndexerRecipe recipe = RecipesHelper.projectionIndexerRecipe((ReteNodeRecipe)parentRecipe, (Mask)CompilerHelper.toRecipeMask(mask));
        return new PlanningTrace(planToCompile, parentTrace.getVariablesTuple(), (ReteNodeRecipe)recipe, parentTrace);
    }

    protected static TrimmerRecipe makeTrimmerRecipe(PlanningTrace compiledParent, List<PVariable> projectedVariables) {
        Mask projectionMask = CompilerHelper.makeProjectionMask(compiledParent, projectedVariables);
        TrimmerRecipe trimmerRecipe = ReteRecipeCompiler.FACTORY.createTrimmerRecipe();
        trimmerRecipe.setParent(compiledParent.getRecipe());
        trimmerRecipe.setMask(projectionMask);
        return trimmerRecipe;
    }

    public static Mask makeProjectionMask(PlanningTrace compiledParent, Iterable<PVariable> projectedVariables) {
        ArrayList<Integer> projectionSourceIndices = new ArrayList<Integer>();
        for (PVariable pVariable : projectedVariables) {
            projectionSourceIndices.add(compiledParent.getPosMapping().get(pVariable));
        }
        Mask projectionMask = RecipesHelper.mask((int)compiledParent.getRecipe().getArity(), projectionSourceIndices);
        return projectionMask;
    }

    public static PosetTriplet computePosetInfo(List<PVariable> variables, PBody body, IQueryMetaContext context) {
        Map typeMap = TypeHelper.inferUnaryTypesFor(variables, (Set)body.getConstraints(), (IQueryMetaContext)context);
        LinkedList<Set<IInputKey>> keys = new LinkedList<Set<IInputKey>>();
        int i = 0;
        while (i < variables.size()) {
            keys.add((Set)typeMap.get(variables.get(i)));
            ++i;
        }
        return CompilerHelper.computePosetInfo(keys, context);
    }

    public static PosetTriplet computePosetInfo(List<PParameter> parameters, IQueryMetaContext context) {
        LinkedList<Set<IInputKey>> keys = new LinkedList<Set<IInputKey>>();
        int i = 0;
        while (i < parameters.size()) {
            IInputKey key = parameters.get(i).getDeclaredUnaryType();
            if (key == null) {
                keys.add(Collections.emptySet());
            } else {
                keys.add(Collections.singleton(parameters.get(i).getDeclaredUnaryType()));
            }
            ++i;
        }
        return CompilerHelper.computePosetInfo(keys, context);
    }

    public static PosetTriplet computePosetInfo(Iterable<Set<IInputKey>> keys, IQueryMetaContext context) {
        PosetTriplet result = new PosetTriplet();
        ArrayList<Integer> coreIndices = new ArrayList<Integer>();
        ArrayList<Integer> posetIndices = new ArrayList<Integer>();
        ArrayList<IInputKey> filtered = new ArrayList<IInputKey>();
        boolean posetKey = false;
        int index = -1;
        for (Set<IInputKey> _keys : keys) {
            ++index;
            posetKey = false;
            for (IInputKey key : _keys) {
                if (key == null || !context.isPosetKey(key)) continue;
                posetKey = true;
                filtered.add(key);
                break;
            }
            if (posetKey) {
                posetIndices.add(index);
                continue;
            }
            coreIndices.add(index);
        }
        result.comparator = context.getPosetComparator(filtered);
        result.coreMask = RecipesHelper.mask((int)(index + 1), coreIndices);
        result.posetMask = RecipesHelper.mask((int)(index + 1), posetIndices);
        return result;
    }

    public static CompiledQuery makeQueryTrace(PQuery query, Map<PBody, RecipeTraceInfo> bodyFinalTraces, Collection<ReteNodeRecipe> bodyFinalRecipes, QueryEvaluationHint hint, IQueryMetaContext context) {
        ProductionRecipe recipe = ReteRecipeCompiler.FACTORY.createProductionRecipe();
        boolean deleteRederiveEvaluation = (Boolean)ReteHintOptions.deleteRederiveEvaluation.getValueOrDefault(hint);
        if (deleteRederiveEvaluation) {
            PosetTriplet triplet = CompilerHelper.computePosetInfo(query.getParameters(), context);
            if (triplet.comparator != null) {
                MonotonicityInfo info = FACTORY.createMonotonicityInfo();
                info.setCoreMask(triplet.coreMask);
                info.setPosetMask(triplet.posetMask);
                info.setPosetComparator((Object)triplet.comparator);
                recipe.setOptionalMonotonicityInfo(info);
            }
        }
        recipe.setDeleteRederiveEvaluation(deleteRederiveEvaluation);
        recipe.setPattern((Object)query);
        recipe.setPatternFQN(query.getFullyQualifiedName());
        recipe.setTraceInfo(recipe.getPatternFQN());
        recipe.getParents().addAll(bodyFinalRecipes);
        int i = 0;
        while (i < query.getParameterNames().size()) {
            recipe.getMappedIndices().put((Object)((String)query.getParameterNames().get(i)), (Object)i);
            ++i;
        }
        return new CompiledQuery((ReteNodeRecipe)recipe, bodyFinalTraces, query);
    }

    public static Mask toRecipeMask(TupleMask mask) {
        return RecipesHelper.mask((int)mask.sourceWidth, (int[])mask.indices);
    }

    public static class JoinHelper {
        private TupleMask primaryMask;
        private TupleMask secondaryMask;
        private TupleMask complementerMask;
        private RecipeTraceInfo primaryIndexer;
        private RecipeTraceInfo secondaryIndexer;
        private JoinRecipe naturalJoinRecipe;
        private List<PVariable> naturalJoinVariablesTuple;

        public JoinHelper(SubPlan planToCompile, PlanningTrace primaryCompiled, PlanningTrace callTrace) {
            LinkedHashSet<PVariable> primaryVariables = new LinkedHashSet<PVariable>(primaryCompiled.getVariablesTuple());
            LinkedHashSet<PVariable> secondaryVariables = new LinkedHashSet<PVariable>(callTrace.getVariablesTuple());
            int oldNodes = 0;
            TreeSet<Integer> introducingSecondaryIndices = new TreeSet<Integer>();
            for (PVariable var : secondaryVariables) {
                if (primaryVariables.contains(var)) {
                    ++oldNodes;
                    continue;
                }
                introducingSecondaryIndices.add(callTrace.getPosMapping().get(var));
            }
            ArrayList<Integer> primaryIndices = new ArrayList<Integer>(oldNodes);
            ArrayList<Integer> secondaryIndices = new ArrayList<Integer>(oldNodes);
            for (PVariable var : secondaryVariables) {
                if (!primaryVariables.contains(var)) continue;
                primaryIndices.add(primaryCompiled.getPosMapping().get(var));
                secondaryIndices.add(callTrace.getPosMapping().get(var));
            }
            TreeSet<Integer> complementerIndices = introducingSecondaryIndices;
            this.primaryMask = TupleMask.fromSelectedIndices((int)primaryCompiled.getVariablesTuple().size(), primaryIndices);
            this.secondaryMask = TupleMask.fromSelectedIndices((int)callTrace.getVariablesTuple().size(), secondaryIndices);
            this.complementerMask = TupleMask.fromSelectedIndices((int)callTrace.getVariablesTuple().size(), complementerIndices);
            this.primaryIndexer = CompilerHelper.makeIndexerTrace(planToCompile, primaryCompiled, this.primaryMask);
            this.secondaryIndexer = CompilerHelper.makeIndexerTrace(planToCompile, callTrace, this.secondaryMask);
            this.naturalJoinRecipe = FACTORY.createJoinRecipe();
            this.naturalJoinRecipe.setLeftParent((ProjectionIndexerRecipe)this.primaryIndexer.getRecipe());
            this.naturalJoinRecipe.setRightParent((IndexerRecipe)this.secondaryIndexer.getRecipe());
            this.naturalJoinRecipe.setRightParentComplementaryMask(CompilerHelper.toRecipeMask(this.complementerMask));
            this.naturalJoinVariablesTuple = new ArrayList<PVariable>(primaryCompiled.getVariablesTuple());
            int[] nArray = this.complementerMask.indices;
            int n = this.complementerMask.indices.length;
            int n2 = 0;
            while (n2 < n) {
                int complementerIndex = nArray[n2];
                this.naturalJoinVariablesTuple.add(callTrace.getVariablesTuple().get(complementerIndex));
                ++n2;
            }
        }

        public TupleMask getPrimaryMask() {
            return this.primaryMask;
        }

        public TupleMask getSecondaryMask() {
            return this.secondaryMask;
        }

        public TupleMask getComplementerMask() {
            return this.complementerMask;
        }

        public RecipeTraceInfo getPrimaryIndexer() {
            return this.primaryIndexer;
        }

        public RecipeTraceInfo getSecondaryIndexer() {
            return this.secondaryIndexer;
        }

        public JoinRecipe getNaturalJoinRecipe() {
            return this.naturalJoinRecipe;
        }

        public List<PVariable> getNaturalJoinVariablesTuple() {
            return this.naturalJoinVariablesTuple;
        }
    }

    public static final class PosetTriplet {
        public Mask coreMask;
        public Mask posetMask;
        public IPosetComparator comparator;
    }
}

