/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.instr;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.MethodVisitor;

public final class InstrSupport {
    public static final int ASM_API_VERSION = 458752;
    public static final String DATAFIELD_NAME = "$jacocoData";
    public static final int DATAFIELD_ACC = 4234;
    public static final int DATAFIELD_INTF_ACC = 4121;
    public static final String DATAFIELD_DESC = "[Z";
    public static final String INITMETHOD_NAME = "$jacocoInit";
    public static final String INITMETHOD_DESC = "()[Z";
    public static final int INITMETHOD_ACC = 4106;
    static final String CLINIT_NAME = "<clinit>";
    static final String CLINIT_DESC = "()V";
    static final int CLINIT_ACC = 4104;
    private static final int MAJOR_VERSION_INDEX = 6;

    private InstrSupport() {
    }

    public static int getVersionMajor(byte[] b) {
        return (short)((b[6] & 0xFF) << 8 | b[7] & 0xFF);
    }

    public static boolean needsFrames(int version) {
        return (version & 0xFF) >= 50;
    }

    public static void assertNotInstrumented(String member, String owner) throws IllegalStateException {
        if (member.equals(DATAFIELD_NAME) || member.equals(INITMETHOD_NAME)) {
            throw new IllegalStateException(String.format("Cannot process instrumented class %s. Please supply original non-instrumented classes.", owner));
        }
    }

    public static void push(MethodVisitor mv, int value) {
        if (value >= -1 && value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn((Object)value);
        }
    }

    public static ClassReader classReaderFor(byte[] b) {
        byte[] originalVersion = new byte[]{b[4], b[5], b[6], b[7]};
        if (InstrSupport.getVersionMajor(b) == 57) {
            b[4] = 0;
            b[5] = 0;
            b[6] = 0;
            b[7] = 56;
        }
        ClassReader classReader = new ClassReader(b);
        System.arraycopy(originalVersion, 0, b, 4, originalVersion.length);
        return classReader;
    }
}

