/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatNumberPattern;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class FormatCurrencyNumPattern
extends FormatNumberPattern {
    private int decPlaces = 0;
    private boolean useSep = false;
    private boolean useSpace = false;
    private boolean useBracket = false;
    private String symbol = "";
    private String symPos = "";
    public static String[] BUILT_IN_SYMBOLS;

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Messages.getString("FormatNumberPage.currency.symbol.none"));
        list.add("\u00a5");
        list.add("$");
        list.add("\u20ac");
        list.add("\u00a3");
        list.add("DKK");
        String defaultSymbol = null;
        Currency defaultCurrency = Currency.getInstance((ULocale)ULocale.getDefault());
        if (defaultCurrency != null) {
            defaultSymbol = defaultCurrency.getSymbol();
        }
        if (defaultSymbol != null && !list.contains(defaultSymbol)) {
            list.add(1, defaultSymbol);
        }
        BUILT_IN_SYMBOLS = list.toArray(new String[list.size()]);
    }

    public static String getDefaultSymbolPosition(ULocale locale) {
        Currency currency;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        if ((currency = Currency.getInstance((ULocale)locale)) != null) {
            String symbol = currency.getSymbol();
            if (symbol == null) {
                return null;
            }
            NumberFormat formater = NumberFormat.getCurrencyInstance((ULocale)locale);
            String result = formater.format(1L);
            if (result.endsWith(symbol)) {
                return FormatNumberPattern.SYMBOL_POSITION_AFTER;
            }
            return FormatNumberPattern.SYMBOL_POSITION_BEFORE;
        }
        return null;
    }

    public static int getDefaultFractionDigits(ULocale locale) {
        Currency currency;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        if ((currency = Currency.getInstance((ULocale)locale)) != null) {
            return currency.getDefaultFractionDigits();
        }
        return 2;
    }

    public static boolean getDefaultUsingSymbolSpace(ULocale locale) {
        block8: {
            Currency currency;
            if (locale == null) {
                locale = ULocale.getDefault();
            }
            if ((currency = Currency.getInstance((ULocale)locale)) == null) break block8;
            String symbol = currency.getSymbol();
            if (symbol == null) {
                return false;
            }
            NumberFormat formater = NumberFormat.getCurrencyInstance((ULocale)locale);
            String result = formater.format(1L);
            if (result.endsWith(symbol)) {
                result = result.substring(0, result.indexOf(symbol));
                int i = result.length() - 1;
                while (i >= 0) {
                    if (UCharacter.isSpaceChar((int)result.codePointAt(i))) {
                        return true;
                    }
                    --i;
                }
            } else {
                result = result.substring(result.indexOf(symbol) + symbol.length());
                int i = 0;
                while (i < result.length()) {
                    if (UCharacter.isSpaceChar((int)result.codePointAt(i))) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public FormatCurrencyNumPattern(String category) {
        super(category);
        this.setType('C');
    }

    @Override
    public String getPattern() {
        String numStr = "###0";
        String decStr = "";
        String positivePatt = numStr;
        String negativePatt = null;
        if (this.useSep) {
            positivePatt = "#,##0";
        }
        if (!StringUtil.isEmpty((String)(decStr = DEUtil.getDecmalStr(this.decPlaces)))) {
            positivePatt = String.valueOf(positivePatt) + "." + decStr;
        }
        if (this.useBracket) {
            negativePatt = "(" + positivePatt + ")";
        }
        if (this.symbol.length() != 0 && !this.symbol.equalsIgnoreCase(FormatNumberPattern.TEXT_CURRENCY_SYMBOL_NONE)) {
            if (this.symPos.equalsIgnoreCase(FormatNumberPattern.SYMBOL_POSITION_BEFORE)) {
                positivePatt = String.valueOf(this.symbol) + (this.getUseSpace() ? " " : "") + positivePatt;
                if (negativePatt != null) {
                    negativePatt = String.valueOf(this.symbol) + (this.getUseSpace() ? " " : "") + negativePatt;
                }
            } else if (this.symPos.equalsIgnoreCase(FormatNumberPattern.SYMBOL_POSITION_AFTER)) {
                positivePatt = String.valueOf(positivePatt) + (this.getUseSpace() ? " " : "") + this.symbol;
                if (negativePatt != null) {
                    negativePatt = String.valueOf(negativePatt) + (this.getUseSpace() ? " " : "") + this.symbol;
                }
            }
        }
        String pattern = negativePatt != null ? String.valueOf(positivePatt) + ";" + negativePatt : positivePatt;
        pattern = this.applyRoundingMode(pattern);
        return pattern;
    }

    @Override
    public void setPattern(String patternStr) {
        String patt = this.valPattern(patternStr);
        this.useSep = (patt = this.checkRoundingMode(patt)).indexOf(",") != -1;
        this.useSpace = patt.indexOf(" ") != -1;
        this.useBracket = patt.indexOf("(") != -1 && patt.indexOf(")") != -1;
        this.decPlaces = 0;
        if (patt.indexOf(".") != -1) {
            this.decPlaces = patt.lastIndexOf("0") - patt.lastIndexOf(".");
        }
        this.symbol = "";
        this.symPos = "";
        int i = 0;
        while (i < BUILT_IN_SYMBOLS.length) {
            String sTemp = BUILT_IN_SYMBOLS[i];
            int sPos = patt.indexOf(sTemp);
            if (sPos != -1) {
                this.symbol = sTemp;
                if (sPos == 0) {
                    this.symPos = FormatNumberPattern.SYMBOL_POSITION_BEFORE;
                    break;
                }
                this.symPos = FormatNumberPattern.SYMBOL_POSITION_AFTER;
                break;
            }
            ++i;
        }
        this.symbol.length();
    }

    @Override
    protected String getDefaultPatt() {
        return this.DEFAULT_CURRENCY_PATTERN;
    }

    public int getDecPlaces() {
        return this.decPlaces;
    }

    public void setDecPlaces(int decPlaces) {
        this.decPlaces = decPlaces;
    }

    public boolean getUseSep() {
        return this.useSep;
    }

    public void setUseSep(boolean useSep) {
        this.useSep = useSep;
    }

    public boolean getUseBracket() {
        return this.useBracket;
    }

    public void setUseBracket(boolean useBracket) {
        this.useBracket = useBracket;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymPos() {
        return this.symPos;
    }

    public void setSymPos(String symPos) {
        this.symPos = symPos;
    }

    public boolean getUseSpace() {
        return this.useSpace;
    }

    public void setUseSpace(boolean useSpace) {
        this.useSpace = useSpace;
    }

    public String getRoundingMode() {
        return this.rounding;
    }

    public void setRoundingMode(String mode) {
        this.rounding = mode;
    }
}

