/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.preferences;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ArduinoPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text urlsText;
    private Text homeText;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Composite homeComp = new Composite(control, 0);
        homeComp.setLayoutData((Object)new GridData(4, 4, true, false));
        homeComp.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(homeComp, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("Arduino home:");
        this.homeText = new Text(homeComp, 2048);
        this.homeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.homeText.setText(ArduinoPreferences.getArduinoHome().toString());
        Button browse = new Button(homeComp, 0);
        browse.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ArduinoPreferencePage.this.getShell());
                dialog.setMessage("Select directory for the Arduino SDKs and toolchains.");
                String dir = dialog.open();
                if (dir != null) {
                    ArduinoPreferencePage.this.homeText.setText(dir);
                }
            }
        });
        Text desc = new Text(control, 72);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = 500;
        desc.setLayoutData((Object)layoutData);
        desc.setBackground(parent.getBackground());
        desc.setText(Messages.ArduinoPreferencePage_desc);
        this.urlsText = new Text(control, 2050);
        this.urlsText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.urlsText.setText(ArduinoPreferences.getBoardUrls());
        return control;
    }

    public boolean performOk() {
        ArduinoPreferences.setBoardUrls((String)this.urlsText.getText());
        ArduinoPreferences.setArduinoHome((Path)Paths.get(this.homeText.getText(), new String[0]));
        return true;
    }

    protected void performDefaults() {
        String defaultHome = ArduinoPreferences.getDefaultArduinoHome();
        this.homeText.setText(defaultHome);
        ArduinoPreferences.setArduinoHome((Path)Paths.get(defaultHome, new String[0]));
        String defaultBoardUrl = ArduinoPreferences.getDefaultBoardUrls();
        this.urlsText.setText(defaultBoardUrl);
        ArduinoPreferences.setBoardUrls((String)defaultBoardUrl);
        super.performDefaults();
    }
}

