/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains implementations of {@link org.eclipse.collections.api.set.FixedSizeSet}.
 * <p>
 *     This package contains the following implementations:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.fixed.EmptySet} -  a set with 0 elements.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.fixed.SingletonSet} -  a set with 1 element.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.fixed.DoubletonSet} - a set with 2 elements.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.fixed.TripletonSet} - a set with 3 elements.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.fixed.QuadrupletonSet} - a set with 4 elements.
 *     </li>
 * </ul>
 * <p>
 *     This package contains one factory implementation:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.fixed.FixedSizeSetFactoryImpl} - a factory which creates instances of type {@link org.eclipse.collections.api.set.FixedSizeSet}.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.impl.set.fixed;
