/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver3;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.spi.cdo.CDOMergingConflictResolver;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOHandlingConflictResolver
extends CDOMergingConflictResolver
implements CDOConflictResolver3 {
    private ConflictHandlerSelector conflictHandlerSelector;

    public CDOHandlingConflictResolver() {
    }

    public CDOHandlingConflictResolver(boolean ensureRemoteNotifications) {
        super(ensureRemoteNotifications);
    }

    public CDOHandlingConflictResolver(CDOMerger merger, boolean ensureRemoteNotifications) {
        super(merger, ensureRemoteNotifications);
    }

    public CDOHandlingConflictResolver(CDOMerger merger) {
        super(merger);
    }

    public CDOHandlingConflictResolver(DefaultCDOMerger.ResolutionPreference resolutionPreference, boolean ensureRemoteNotifications, ConflictHandler conflictHandler) {
        super(resolutionPreference, ensureRemoteNotifications);
    }

    public CDOHandlingConflictResolver(DefaultCDOMerger.ResolutionPreference resolutionPreference) {
        super(resolutionPreference);
    }

    public final ConflictHandlerSelector getConflictHandlerSelector() {
        return this.conflictHandlerSelector;
    }

    public final void setConflictHandlerSelector(ConflictHandlerSelector conflictHandlerSelector) {
        this.conflictHandlerSelector = conflictHandlerSelector;
    }

    @Override
    public boolean preCommit() {
        if (this.isConflict()) {
            ConflictHandler conflictHandler;
            CDOTransaction transaction = this.getTransaction();
            try {
                conflictHandler = this.getConflictHandler(transaction);
            }
            catch (CancelException ex) {
                return false;
            }
            if (conflictHandler != null) {
                long lastNonConflictTimeStamp = this.getLastNonConflictTimeStamp();
                return this.handleConflict(conflictHandler, lastNonConflictTimeStamp);
            }
        }
        return true;
    }

    protected boolean handleConflict(ConflictHandler conflictHandler, long lastNonConflictTimeStamp) {
        return conflictHandler.handleConflict(this, lastNonConflictTimeStamp);
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected ConflictHandler getConflictHandler(CDOTransaction transaction) throws CancelException {
        if (this.conflictHandlerSelector == null) {
            return null;
        }
        List<ConflictHandler> conflictHandlers = this.getConflictHandlers(transaction);
        if (conflictHandlers.isEmpty()) {
            return null;
        }
        ConflictHandler conflictHandler = this.conflictHandlerSelector.selectConflictHandler(transaction, conflictHandlers);
        if (conflictHandler == null) {
            throw new CancelException();
        }
        return conflictHandler;
    }

    protected List<ConflictHandler> getConflictHandlers(CDOTransaction transaction) {
        ArrayList<ConflictHandler> result = new ArrayList<ConflictHandler>();
        IManagedContainer container = this.getContainer();
        String productGroup = "org.eclipse.emf.cdo.conflictHandlers";
        for (String factoryType : container.getFactoryTypes(productGroup)) {
            try {
                ConflictHandler conflictHandler = (ConflictHandler)container.getElement(productGroup, factoryType, null);
                result.add(conflictHandler);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        Collections.sort(result, new Comparator<ConflictHandler>(){

            @Override
            public int compare(ConflictHandler h1, ConflictHandler h2) {
                return h1.getPriority() - h2.getPriority();
            }
        });
        return result;
    }

    protected static final class CancelException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static interface ConflictHandler {
        public static final int DEFAULT_PRIORITY = 500;

        public String getLabel();

        public int getPriority();

        public boolean canHandleConflict(CDOMergingConflictResolver var1, long var2);

        public boolean handleConflict(CDOMergingConflictResolver var1, long var2);

        public static abstract class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.conflictHandlers";

            public Factory(String type) {
                super(PRODUCT_GROUP, type);
            }

            public abstract ConflictHandler create(String var1) throws ProductCreationException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConflictHandlerSelector {
        public ConflictHandler selectConflictHandler(CDOTransaction var1, List<ConflictHandler> var2);
    }
}

